/*
 * Decompiled with CFR 0.152.
 */
package opennlp.grok.preprocess.postag;

import java.util.ArrayList;
import java.util.List;
import opennlp.common.morph.MorphAnalyzer;
import opennlp.common.util.Pair;
import opennlp.common.util.PerlHelp;
import opennlp.maxent.ContextGenerator;

public class SwedishPOSContextGenerator
implements ContextGenerator {
    private MorphAnalyzer _manalyzer;
    private static final boolean DEBUG = false;
    private static final boolean USELEX = true;
    private static final boolean TEST = true;

    public SwedishPOSContextGenerator() {
        this._manalyzer = null;
    }

    public SwedishPOSContextGenerator(MorphAnalyzer ma) {
        this._manalyzer = ma;
    }

    public String[] getContext(Object o) {
        boolean rare = false;
        boolean all = true;
        if (o instanceof Pair) {
            rare = (Boolean)((Pair)o).b;
            all = false;
            o = ((Pair)o).a;
        }
        Object[] data = (Object[])o;
        List ls = (List)data[0];
        List tags = (List)data[1];
        int pos = (Integer)data[2];
        String tagprev3 = null;
        String tagprevprev = null;
        String tagprev = null;
        String prevprev = null;
        String prev = null;
        String lex = null;
        String nextnext = null;
        String next = null;
        lex = (String)ls.get(pos);
        if (ls.size() > pos + 1) {
            next = (String)ls.get(pos + 1);
            if (SwedishPOSContextGenerator.isEOS((String)ls.get(pos + 1))) {
                nextnext = "*SE*";
            } else if (ls.size() > pos + 2) {
                nextnext = (String)ls.get(pos + 2);
            }
        } else if (ls.size() > 1) {
            next = "*SE*";
        }
        if (pos - 1 >= 0) {
            prev = (String)ls.get(pos - 1);
            tagprev = (String)tags.get(pos - 1);
            if (pos - 2 >= 0) {
                prevprev = (String)ls.get(pos - 2);
                tagprevprev = (String)tags.get(pos - 2);
            } else {
                prevprev = "*SB*";
            }
            if (pos - 3 >= 0) {
                tagprev3 = (String)tags.get(pos - 3);
            }
        } else if (ls.size() > 1) {
            prev = "*SB*";
        }
        ArrayList<String> e = new ArrayList<String>();
        if (!rare || all) {
            e.add("w=" + lex.toLowerCase());
            e.add("w=" + lex.toLowerCase());
            e.add("w=" + lex.toLowerCase());
            e.add("w=" + lex.toLowerCase());
        }
        e.add("l=" + lex.length());
        if (this._manalyzer != null) {
            String[] affs = this._manalyzer.getSuffixes(lex);
            int i = 0;
            while (i < affs.length) {
                e.add("suf=" + affs[i]);
                ++i;
            }
        }
        if (lex.indexOf(45) != -1) {
            e.add("h");
        }
        if (PerlHelp.hasCap((String)lex)) {
            e.add("c");
        }
        if (PerlHelp.hasNum((String)lex)) {
            e.add("d");
        }
        if (prev != null) {
            e.add("p=" + prev.toLowerCase());
        }
        if (tagprev != null) {
            e.add("t=" + tagprev);
            e.add("tpref=" + SwedishPOSContextGenerator.tagPrefix(tagprev));
        }
        if (next != null) {
            e.add("n=" + next.toLowerCase());
        }
        String[] context = new String[e.size()];
        e.toArray(context);
        return context;
    }

    private static final String filterEOS(String s) {
        if (s.length() != 1) {
            return s;
        }
        char c = s.charAt(0);
        if (c == '.' || c == '?' | c == '!') {
            return "*SE*";
        }
        return s;
    }

    private static final boolean isEOS(String s) {
        if (s.length() != 1) {
            return false;
        }
        char c = s.charAt(0);
        return c == '.' || c == '?' | c == '!';
    }

    private static final String tagPrefix(String s) {
        if (s != null) {
            if (s.length() > 1) {
                return s.substring(0, 2);
            }
            if (s.length() == 1) {
                return s.substring(0, 1);
            }
        }
        return "";
    }

    public static void main(String[] args) {
        SwedishPOSContextGenerator gen = new SwedishPOSContextGenerator();
        String[] lexA = new String[]{"the", "stories", "about", "well-heeled", "communities", "and", "developers"};
        String[] tagsA = new String[]{"DT", "NNS", "IN", "JJ", "NNS", "CC", "NNS"};
        ArrayList<String> lex = new ArrayList<String>();
        ArrayList<String> tags = new ArrayList<String>();
        int i = 0;
        while (i < lexA.length) {
            lex.add(lexA[i]);
            tags.add(tagsA[i]);
            ++i;
        }
        Object[] a = new Object[]{lex, tags, new Integer(2)};
        Object[] b = new Object[]{lex, tags, new Integer(0)};
        String[] ans1 = gen.getContext(new Pair((Object)a, (Object)Boolean.FALSE));
        String[] ans2 = gen.getContext(b);
        int i2 = 0;
        while (i2 < ans1.length) {
            System.out.println(ans1[i2]);
            ++i2;
        }
        System.out.println();
        int i3 = 0;
        while (i3 < ans2.length) {
            System.out.println(ans2[i3]);
            ++i3;
        }
    }
}

