/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.DescendingComparer;
import net.sf.saxon.expr.sort.GenericAtomicComparer;
import net.sf.saxon.functions.CollatingFunction;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.PlainType;
import net.sf.saxon.type.StringToDouble;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.UntypedAtomicValue;

public class Minimax
extends CollatingFunction {
    public static final int MIN = 2;
    public static final int MAX = 3;
    private BuiltInAtomicType argumentType = BuiltInAtomicType.ANY_ATOMIC;
    private boolean ignoreNaN = false;
    private AtomicComparer comparer;

    public void setIgnoreNaN(boolean ignore) {
        this.ignoreNaN = ignore;
    }

    public boolean isIgnoreNaN() {
        return this.ignoreNaN;
    }

    public AtomicComparer getComparer() {
        return this.comparer;
    }

    public BuiltInAtomicType getArgumentType() {
        return this.argumentType;
    }

    public int getImplementationMethod() {
        return super.getImplementationMethod() | 0x10;
    }

    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
        super.checkArguments(visitor);
        Optimizer opt = visitor.getConfiguration().obtainOptimizer();
        this.argument[0] = ExpressionTool.unsorted(opt, this.argument[0], false);
    }

    public int computeCardinality() {
        int c = super.computeCardinality();
        if (!Cardinality.allowsZero(this.argument[0].getCardinality())) {
            c = 16384;
        }
        return c;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        StringCollator comp;
        Expression e2 = super.typeCheck(visitor, contextItemType);
        if (e2 != this) {
            return e2;
        }
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        StaticContext env = visitor.getStaticContext();
        if (Literal.isEmptySequence(this.argument[0])) {
            return this.argument[0];
        }
        this.argumentType = (BuiltInAtomicType)this.argument[0].getItemType(th).getPrimitiveItemType();
        PlainType t0 = (PlainType)this.argument[0].getItemType(th);
        if (t0.isExternalType()) {
            XPathException err = new XPathException("Cannot perform computation involving external objects");
            err.setIsTypeError(true);
            err.setErrorCode("XPTY0004");
            err.setLocator(this);
            throw err;
        }
        BuiltInAtomicType p0 = (BuiltInAtomicType)t0.getPrimitiveItemType();
        if (p0.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
            p0 = BuiltInAtomicType.DOUBLE;
        }
        if (this.comparer == null && (comp = this.getStringCollator()) != null) {
            this.comparer = GenericAtomicComparer.makeAtomicComparer(p0, p0, comp, env.getConfiguration().getConversionContext());
        }
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        int card;
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        Expression e = super.optimize(visitor, contextItemType);
        if (e != this) {
            return e;
        }
        if (this.getNumberOfArguments() == 1 && !Cardinality.allowsMany(card = this.argument[0].getCardinality()) && th.isSubType(this.argument[0].getItemType(th), BuiltInAtomicType.NUMERIC)) {
            return this.argument[0];
        }
        return this;
    }

    public ItemType getItemType(TypeHierarchy th) {
        ItemType t = Atomizer.getAtomizedItemType(this.argument[0], false, th);
        if (t.getPrimitiveType() == 631) {
            return BuiltInAtomicType.DOUBLE;
        }
        return t;
    }

    public Expression copy() {
        Minimax m = (Minimax)super.copy();
        m.argumentType = this.argumentType;
        m.stringCollator = this.stringCollator;
        m.comparer = this.comparer;
        m.ignoreNaN = this.ignoreNaN;
        return m;
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        AtomicComparer aComparer = this.comparer;
        if (aComparer == null) {
            aComparer = this.getAtomicComparer(context);
        }
        SequenceIterator<? extends Item> iter = this.argument[0].iterate(context);
        try {
            return Minimax.minimax(iter, this.operation, aComparer, this.ignoreNaN, context);
        }
        catch (XPathException err) {
            err.setLocator(this);
            throw err;
        }
    }

    public AtomicComparer getAtomicComparer(XPathContext context) throws XPathException {
        StringCollator collator = this.getCollator(1, context);
        BuiltInAtomicType type = this.argumentType;
        if (type.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
            type = BuiltInAtomicType.DOUBLE;
        }
        return GenericAtomicComparer.makeAtomicComparer(type, type, collator, context);
    }

    public static AtomicValue minimax(SequenceIterator iter, int operation, AtomicComparer atomicComparer, boolean ignoreNaN, XPathContext context) throws XPathException {
        AtomicValue test;
        AtomicValue prim;
        AtomicValue min;
        boolean foundNaN;
        boolean foundFloat;
        boolean foundDouble;
        StringToDouble converter;
        ConversionRules rules;
        TypeHierarchy th;
        block33: {
            block32: {
                th = context.getConfiguration().getTypeHierarchy();
                rules = context.getConfiguration().getConversionRules();
                converter = context.getConfiguration().getConversionRules().getStringToDoubleConverter();
                foundDouble = false;
                foundFloat = false;
                foundNaN = false;
                if (operation == 3) {
                    atomicComparer = new DescendingComparer(atomicComparer);
                }
                atomicComparer = atomicComparer.provideContext(context);
                do {
                    if ((min = (AtomicValue)iter.next()) == null) {
                        return null;
                    }
                    prim = min;
                    if (min instanceof UntypedAtomicValue) {
                        try {
                            prim = min = new DoubleValue(converter.stringToNumber(min.getStringValueCS()));
                            foundDouble = true;
                        }
                        catch (NumberFormatException e) {
                            XPathException de = new XPathException("Failure converting " + Err.wrap(min.getStringValueCS()) + " to a number");
                            de.setErrorCode("FORG0001");
                            de.setXPathContext(context);
                            throw de;
                        }
                    } else if (prim instanceof DoubleValue) {
                        foundDouble = true;
                    } else if (prim instanceof FloatValue) {
                        foundFloat = true;
                    }
                    if (!prim.isNaN()) break block32;
                } while (ignoreNaN);
                if (prim instanceof DoubleValue) {
                    return min;
                }
                foundNaN = true;
                min = FloatValue.NaN;
                break block33;
            }
            if (!prim.getPrimitiveType().isOrdered()) {
                XPathException de = new XPathException("Type " + prim.getPrimitiveType() + " is not an ordered type");
                de.setErrorCode("FORG0006");
                de.setIsTypeError(true);
                de.setXPathContext(context);
                throw de;
            }
        }
        AtomicType lowestCommonSuperType = min.getTypeLabel();
        while ((test = (AtomicValue)iter.next()) != null) {
            AtomicValue test2;
            prim = test2 = test;
            if (test instanceof UntypedAtomicValue) {
                try {
                    test2 = new DoubleValue(converter.stringToNumber(test.getStringValueCS()));
                    if (foundNaN) {
                        return DoubleValue.NaN;
                    }
                    prim = test2;
                    foundDouble = true;
                }
                catch (NumberFormatException e) {
                    XPathException de = new XPathException("Failure converting " + Err.wrap(test.getStringValueCS()) + " to a number");
                    de.setErrorCode("FORG0001");
                    de.setXPathContext(context);
                    throw de;
                }
            } else if (prim instanceof DoubleValue) {
                if (foundNaN) {
                    return DoubleValue.NaN;
                }
                foundDouble = true;
            } else if (prim instanceof FloatValue) {
                foundFloat = true;
            }
            lowestCommonSuperType = (AtomicType)Type.getCommonSuperType(lowestCommonSuperType, prim.getTypeLabel(), th);
            if (prim.isNaN()) {
                if (ignoreNaN) continue;
                if (foundDouble) {
                    return DoubleValue.NaN;
                }
                foundNaN = true;
                continue;
            }
            try {
                if (atomicComparer.compareAtomicValues(prim, min) >= 0) continue;
                min = test2;
            }
            catch (ClassCastException err) {
                XPathException de = new XPathException("Cannot compare " + min.getItemType(th) + " with " + test2.getItemType(th));
                de.setErrorCode("FORG0006");
                de.setIsTypeError(true);
                de.setXPathContext(context);
                throw de;
            }
        }
        if (foundNaN) {
            return FloatValue.NaN;
        }
        if (foundDouble) {
            if (!(min instanceof DoubleValue)) {
                min = Converter.convert(min, BuiltInAtomicType.DOUBLE, rules);
            }
        } else if (foundFloat && !(min instanceof FloatValue)) {
            min = Converter.convert(min, BuiltInAtomicType.FLOAT, rules);
        }
        if (lowestCommonSuperType == BuiltInAtomicType.NUMERIC || min.getPrimitiveType() == lowestCommonSuperType) {
            return min;
        }
        return Converter.convert(min, lowestCommonSuperType, rules);
    }
}

