use Test;

use lib './lib';
use lib '.';

use Lingua::NumericWordForms::Roles::Russian::WordedNumberSpec;
use Lingua::NumericWordForms::Actions::Russian::WordedNumberSpec;

grammar ParseObj
        does Lingua::NumericWordForms::Roles::Russian::WordedNumberSpec {
    rule TOP { <numeric-word-form>  }
};

sub parse-func(Str:D $spec) {
    ParseObj.parse(
            $spec.lc,
            rule => 'numeric-word-form',
            actions => Lingua::NumericWordForms::Actions::Russian::WordedNumberSpec.new).made,
}

plan 42;

#-----------------------------------------------------------
# Worded number specifications parsing
#-----------------------------------------------------------
# The tests below are generated with the following Mathematica code:
#SeedRandom[39902];
#testLanguage = "Russian";
#k = 6;
#lsTestNumbers =
#  Union[Join @@
#    Map[RandomInteger[#, k] &, {{0, 19}, {20, 100}, {101,
#       1000}, {1001, 10000}, {10001, 10^6}, {10^6, 10^9}, {10^9,
#       10^12}}]];
#Length[lsTestNumbers]
#
#lsSentences =
#  Map[IntegerName[#, {"Russian", "Words"}] &, lsTestNumbers];
#Shallow[lsSentences]
#
#StringRiffle[
# MapThread[
#  "## " <> #3 <> "\n" <> "is parse-func('" <> #1 <> "'), " <> #2 <>
#    ",\n'" <> #1 <> "';" &, {lsSentences, ToString /@ lsTestNumbers,
#   ToString /@ Range[Length[lsTestNumbers]]}], "\n\n"]

## 1
is parse-func('ноль'), 0,
        'ноль';

## 2
is parse-func('три'), 3,
        'три';

## 3
is parse-func('четыре'), 4,
        'четыре';

## 4
is parse-func('девять'), 9,
        'девять';

## 5
is parse-func('восемнадцать'), 18,
        'восемнадцать';

## 6
is parse-func('девятнадцать'), 19,
        'девятнадцать';

## 7
is parse-func('двадцать один'), 21,
        'двадцать один';

## 8
is parse-func('двадцать девять'), 29,
        'двадцать девять';

## 9
is parse-func('пятьдесят шесть'), 56,
        'пятьдесят шесть';

## 10
is parse-func('семьдесят шесть'), 76,
        'семьдесят шесть';

## 11
is parse-func('восемьдесят пять'), 85,
        'восемьдесят пять';

## 12
is parse-func('девяносто семь'), 97,
        'девяносто семь';

## 13
is parse-func('сто шестьдесят три'), 163,
        'сто шестьдесят три';

## 14
is parse-func('сто шестьдесят восемь'), 168,
        'сто шестьдесят восемь';

## 15
is parse-func('двести четыре'), 204,
        'двести четыре';

## 16
is parse-func('двести шестьдесят'), 260,
        'двести шестьдесят';

## 17
is parse-func('четыреста двадцать семь'), 427,
        'четыреста двадцать семь';

## 18
is parse-func('восемьсот четыре'), 804,
        'восемьсот четыре';

## 19
is parse-func('две тысячи семьдесят два'), 2072,
        'две тысячи семьдесят два';

## 20
is parse-func('две тысячи двести двадцать восемь'), 2228,
        'две тысячи двести двадцать восемь';

## 21
is parse-func('пять тысяч пятьсот двадцать восемь'), 5528,
        'пять тысяч пятьсот двадцать восемь';

## 22
is parse-func('пять тысяч восемьсот пятьдесят'), 5850,
        'пять тысяч восемьсот пятьдесят';

## 23
is parse-func('шесть тысяч пятьсот восемь'), 6508,
        'шесть тысяч пятьсот восемь';

## 24
is parse-func('семь тысяч четыреста двенадцать'), 7412,
        'семь тысяч четыреста двенадцать';

## 25
is parse-func('двести сорок пять тысяч триста двадцать четыре'), 245324,
        'двести сорок пять тысяч триста двадцать четыре';

## 26
is parse-func('шестьсот пятнадцать тысяч двести девяносто восемь'), 615298,
        'шестьсот пятнадцать тысяч двести девяносто восемь';

## 27
is parse-func('семьсот тридцать одна тысяча сто шесть'), 731106,
        'семьсот тридцать одна тысяча сто шесть';

## 28
is parse-func('восемьсот двадцать три тысячи восемьсот двадцать четыре'), 823824,
        'восемьсот двадцать три тысячи восемьсот двадцать четыре';

## 29
is parse-func('восемьсот девяносто одна тысяча восемьсот семьдесят один'), 891871,
        'восемьсот девяносто одна тысяча восемьсот семьдесят один';

## 30
is parse-func('девятьсот сорок одна тысяча пятьсот шесть'), 941506,
        'девятьсот сорок одна тысяча пятьсот шесть';

## 31
is parse-func('пятьдесят пять миллионов триста девяносто тысяч пятьсот двадцать семь'), 55390527,
        'пятьдесят пять миллионов триста девяносто тысяч пятьсот двадцать семь';

## 32
is parse-func('семьдесят шесть миллионов семьсот двадцать четыре тысячи четыреста тридцать шесть'), 76724436,
        'семьдесят шесть миллионов семьсот двадцать четыре тысячи четыреста тридцать шесть';

## 33
is parse-func('двести сорок семь миллионов пятьсот семь тысяч восемнадцать'), 247507018,
        'двести сорок семь миллионов пятьсот семь тысяч восемнадцать';

## 34
is parse-func('пятьсот шестнадцать миллионов семьсот пятьдесят три тысячи триста семьдесят восемь'), 516753378,
        'пятьсот шестнадцать миллионов семьсот пятьдесят три тысячи триста семьдесят восемь';

## 35
is parse-func('восемьсот сорок два миллиона семьсот четыре тысячи семьсот восемьдесят три'), 842704783,
        'восемьсот сорок два миллиона семьсот четыре тысячи семьсот восемьдесят три';

## 36
is parse-func('девятьсот восемьдесят восемь миллионов девятьсот шестьдесят одна тысяча триста двадцать четыре'),
        988961324,
        'девятьсот восемьдесят восемь миллионов девятьсот шестьдесят одна тысяча триста двадцать четыре';

## 37
is
        parse-func('пятьсот восемьдесят семь миллиардов семьсот двадцать семь миллионов двести тридцать тысяч сто девяносто девять'),
        587727230199,
        'пятьсот восемьдесят семь миллиардов семьсот двадцать семь миллионов двести тридцать тысяч сто девяносто девять';

## 38
is
        parse-func('шестьсот двадцать семь миллиардов пятьсот восемьдесят миллионов девятьсот тридцать пять тысяч семьдесят два'),
        627580935072,
        'шестьсот двадцать семь миллиардов пятьсот восемьдесят миллионов девятьсот тридцать пять тысяч семьдесят два';

## 39
is
        parse-func('семьсот восемьдесят четыре миллиарда шестьсот тридцать миллионов семьсот тридцать восемь тысяч сто двадцать'),
        784630738120,
        'семьсот восемьдесят четыре миллиарда шестьсот тридцать миллионов семьсот тридцать восемь тысяч сто двадцать';

## 40
is
        parse-func('восемьсот четыре миллиарда триста девяносто семь миллионов четыреста шестнадцать тысяч семьсот тридцать шесть'),
        804397416736,
        'восемьсот четыре миллиарда триста девяносто семь миллионов четыреста шестнадцать тысяч семьсот тридцать шесть';

## 41
is
        parse-func('восемьсот шестьдесят семь миллиардов пятьсот шестьдесят один миллион триста восемьдесят тысяч четыреста четырнадцать'),
        867561380414,
        'восемьсот шестьдесят семь миллиардов пятьсот шестьдесят один миллион триста восемьдесят тысяч четыреста четырнадцать';

## 42
is
        parse-func('девятьсот восемьдесят миллиардов семьсот тридцать шесть миллионов сто тридцать восемь тысяч восемьсот тридцать девять'),
        980736138839,
        'девятьсот восемьдесят миллиардов семьсот тридцать шесть миллионов сто тридцать восемь тысяч восемьсот тридцать девять';

done-testing;