"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getComponentNames = getComponentNames;
const language_core_1 = require("@vue/language-core");
const utils_1 = require("./utils");
function getComponentNames(fileName) {
    const { typescript: ts, language, languageService } = this;
    const sourceScript = language.scripts.get(fileName);
    const root = sourceScript?.generated?.root;
    if (!sourceScript?.generated || !(root instanceof language_core_1.VueVirtualCode)) {
        return [];
    }
    const names = (0, utils_1.getVariableType)(ts, languageService, root, '__VLS_components')
        ?.type
        ?.getProperties()
        .map(c => c.name)
        .filter(entry => !entry.includes('$') && !entry.startsWith('_'))
        ?? [];
    names.push((0, utils_1.getSelfComponentName)(fileName));
    return names;
}
//# sourceMappingURL=getComponentNames.js.map