/*
 * Decompiled with CFR 0.152.
 */
package org.apache.el.util;

import jakarta.el.ELException;
import jakarta.el.MethodNotFoundException;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.el.lang.ELSupport;
import org.apache.el.lang.EvaluationContext;
import org.apache.el.util.MessageFactory;

public class ReflectionUtil {
    protected static final String[] PRIMITIVE_NAMES = new String[]{"boolean", "byte", "char", "double", "float", "int", "long", "short", "void"};
    protected static final Class<?>[] PRIMITIVES = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE, Void.TYPE};

    private ReflectionUtil() {
    }

    public static Class<?> forName(String string) throws ClassNotFoundException {
        if (null == string || string.isEmpty()) {
            return null;
        }
        Class<?> clazz = ReflectionUtil.forNamePrimitive(string);
        if (clazz == null) {
            if (string.endsWith("[]")) {
                String string2 = string.substring(0, string.length() - 2);
                clazz = Class.forName(string2, true, ReflectionUtil.getContextClassLoader());
                clazz = Array.newInstance(clazz, 0).getClass();
            } else {
                clazz = Class.forName(string, true, ReflectionUtil.getContextClassLoader());
            }
        }
        return clazz;
    }

    protected static Class<?> forNamePrimitive(String string) {
        int n;
        if (string.length() <= 8 && (n = Arrays.binarySearch(PRIMITIVE_NAMES, string)) >= 0) {
            return PRIMITIVES[n];
        }
        return null;
    }

    public static Class<?>[] toTypeArray(String[] stringArray) throws ClassNotFoundException {
        if (stringArray == null) {
            return null;
        }
        Class[] classArray = new Class[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            classArray[i] = ReflectionUtil.forName(stringArray[i]);
        }
        return classArray;
    }

    public static String[] toTypeNameArray(Class<?>[] classArray) {
        if (classArray == null) {
            return null;
        }
        String[] stringArray = new String[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            stringArray[i] = classArray[i].getName();
        }
        return stringArray;
    }

    public static Method getMethod(EvaluationContext evaluationContext, Object object, Object object2, Class<?>[] classArray, Object[] objectArray) throws MethodNotFoundException {
        int n;
        if (object == null || object2 == null) {
            throw new MethodNotFoundException(MessageFactory.get("error.method.notfound", object, object2, ReflectionUtil.paramString(classArray)));
        }
        String string = object2 instanceof String ? (String)object2 : object2.toString();
        int n2 = classArray == null ? 0 : classArray.length;
        Class<?> clazz = object.getClass();
        if (n2 == 0) {
            try {
                Method method = clazz.getMethod(string, classArray);
                return ReflectionUtil.getMethod(clazz, object, method);
            }
            catch (NoSuchMethodException | SecurityException exception) {
                // empty catch block
            }
        }
        Method[] methodArray = clazz.getMethods();
        HashMap<Method, MatchResult> hashMap = new HashMap<Method, MatchResult>();
        for (Method object32 : methodArray) {
            if (!object32.getName().equals(string)) continue;
            Class<?>[] classArray2 = object32.getParameterTypes();
            n = classArray2.length;
            if (!object32.isVarArgs() && n2 != n || object32.isVarArgs() && n2 < n - 1 || object32.isVarArgs() && n2 == n && objectArray != null && objectArray.length > n2 && !classArray[n - 1].isArray() || object32.isVarArgs() && n2 > n && objectArray != null && objectArray.length != n2 || !object32.isVarArgs() && objectArray != null && n2 != objectArray.length) continue;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            boolean bl = false;
            block3: for (int i = 0; i < n; ++i) {
                if (object32.isVarArgs() && i == n - 1) {
                    if (i == n2 || objectArray != null && objectArray.length == i) {
                        n6 = Integer.MAX_VALUE;
                        break;
                    }
                    Class<?> clazz2 = classArray2[i].getComponentType();
                    for (int j = i; j < n2; ++j) {
                        if (ReflectionUtil.isAssignableFrom(classArray[j], clazz2)) {
                            ++n4;
                            ++n6;
                            continue;
                        }
                        if (objectArray == null) {
                            bl = true;
                            continue block3;
                        }
                        if (ReflectionUtil.isCoercibleFrom(evaluationContext, objectArray[j], clazz2)) {
                            ++n5;
                            ++n6;
                            continue;
                        }
                        bl = true;
                        continue block3;
                    }
                    continue;
                }
                if (classArray2[i].equals(classArray[i])) {
                    ++n3;
                    continue;
                }
                if (classArray[i] != null && ReflectionUtil.isAssignableFrom(classArray[i], classArray2[i])) {
                    ++n4;
                    continue;
                }
                if (objectArray == null) {
                    bl = true;
                    break;
                }
                if (ReflectionUtil.isCoercibleFrom(evaluationContext, objectArray[i], classArray2[i])) {
                    ++n5;
                    continue;
                }
                bl = true;
                break;
            }
            if (bl) continue;
            if (n3 == n2 && n6 == 0) {
                Method method = ReflectionUtil.getMethod(clazz, object, object32);
                if (method == null) {
                    throw new MethodNotFoundException(MessageFactory.get("error.method.notfound", object, object2, ReflectionUtil.paramString(classArray)));
                }
                return method;
            }
            hashMap.put(object32, new MatchResult(object32.isVarArgs(), n3, n4, n5, n6, object32.isBridge()));
        }
        Object object5 = new MatchResult(true, 0, 0, 0, 0, true);
        Method method = null;
        int n7 = 0;
        for (Map.Entry entry : hashMap.entrySet()) {
            n = ((MatchResult)entry.getValue()).compareTo((MatchResult)object5);
            if (n > 0 || method == null) {
                object5 = (MatchResult)entry.getValue();
                method = (Method)entry.getKey();
                n7 = 0;
                continue;
            }
            if (n != 0) continue;
            n7 = 1;
        }
        if (n7 != 0 && (method = ((MatchResult)object5).getExactCount() == n2 - 1 ? ReflectionUtil.resolveAmbiguousMethod(hashMap.keySet(), classArray) : null) == null) {
            throw new MethodNotFoundException(MessageFactory.get("error.method.ambiguous", object, object2, ReflectionUtil.paramString(classArray)));
        }
        if (method == null) {
            throw new MethodNotFoundException(MessageFactory.get("error.method.notfound", object, object2, ReflectionUtil.paramString(classArray)));
        }
        Method method2 = ReflectionUtil.getMethod(clazz, object, method);
        if (method2 == null) {
            throw new MethodNotFoundException(MessageFactory.get("error.method.notfound", object, object2, ReflectionUtil.paramString(classArray)));
        }
        return method2;
    }

    private static Method resolveAmbiguousMethod(Set<Method> set, Class<?>[] classArray) {
        Object object;
        Method method = set.iterator().next();
        int n = 0;
        Class<?> clazz = null;
        for (int i = 0; i < classArray.length; ++i) {
            if (method.getParameterTypes()[i] == classArray[i]) continue;
            n = i;
            clazz = classArray[i];
            break;
        }
        if (clazz == null) {
            return null;
        }
        Class clazz2 = set.iterator();
        while (clazz2.hasNext()) {
            object = clazz2.next();
            if (((Method)object).getParameterTypes()[n] != classArray[n]) continue;
            return null;
        }
        for (clazz2 = clazz.getSuperclass(); clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            for (Method object2 : set) {
                if (!object2.getParameterTypes()[n].equals(clazz2)) continue;
                return object2;
            }
        }
        object = null;
        if (Number.class.isAssignableFrom(clazz)) {
            for (Method method2 : set) {
                Class<?> clazz3 = method2.getParameterTypes()[n];
                if (!Number.class.isAssignableFrom(clazz3) && !clazz3.isPrimitive()) continue;
                if (object == null) {
                    object = method2;
                    continue;
                }
                object = null;
                break;
            }
        }
        return object;
    }

    private static boolean isAssignableFrom(Class<?> clazz, Class<?> clazz2) {
        if (clazz == null) {
            return true;
        }
        Class<Object> clazz3 = clazz2.isPrimitive() ? (clazz2 == Boolean.TYPE ? Boolean.class : (clazz2 == Character.TYPE ? Character.class : (clazz2 == Byte.TYPE ? Byte.class : (clazz2 == Short.TYPE ? Short.class : (clazz2 == Integer.TYPE ? Integer.class : (clazz2 == Long.TYPE ? Long.class : (clazz2 == Float.TYPE ? Float.class : Double.class))))))) : clazz2;
        return clazz3.isAssignableFrom(clazz);
    }

    private static boolean isCoercibleFrom(EvaluationContext evaluationContext, Object object, Class<?> clazz) {
        try {
            ELSupport.coerceToType(evaluationContext, object, clazz);
        }
        catch (ELException eLException) {
            return false;
        }
        return true;
    }

    private static Method getMethod(Class<?> clazz, Object object, Method method) {
        Method method2;
        if (method == null || Modifier.isPublic(clazz.getModifiers()) && (Modifier.isStatic(method.getModifiers()) && method.canAccess(null) || method.canAccess(object))) {
            return method;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        for (Class<?> clazz2 : classArray) {
            try {
                method2 = clazz2.getMethod(method.getName(), method.getParameterTypes());
                method2 = ReflectionUtil.getMethod(method2.getDeclaringClass(), object, method2);
                if (method2 == null) continue;
                return method2;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        Class<?> clazz3 = clazz.getSuperclass();
        if (clazz3 != null) {
            try {
                method2 = clazz3.getMethod(method.getName(), method.getParameterTypes());
                method2 = ReflectionUtil.getMethod(method2.getDeclaringClass(), object, method2);
                if (method2 != null) {
                    return method2;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return null;
    }

    private static String paramString(Class<?>[] classArray) {
        if (classArray != null) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Class<?> clazz : classArray) {
                if (clazz == null) {
                    stringBuilder.append("null, ");
                    continue;
                }
                stringBuilder.append(clazz.getName()).append(", ");
            }
            if (stringBuilder.length() > 2) {
                stringBuilder.setLength(stringBuilder.length() - 2);
            }
            return stringBuilder.toString();
        }
        return null;
    }

    private static ClassLoader getContextClassLoader() {
        ClassLoader classLoader;
        if (System.getSecurityManager() != null) {
            PrivilegedGetTccl privilegedGetTccl = new PrivilegedGetTccl();
            classLoader = AccessController.doPrivileged(privilegedGetTccl);
        } else {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        return classLoader;
    }

    private static class MatchResult
    implements Comparable<MatchResult> {
        private final boolean varArgs;
        private final int exactCount;
        private final int assignableCount;
        private final int coercibleCount;
        private final int varArgsCount;
        private final boolean bridge;

        MatchResult(boolean bl, int n, int n2, int n3, int n4, boolean bl2) {
            this.varArgs = bl;
            this.exactCount = n;
            this.assignableCount = n2;
            this.coercibleCount = n3;
            this.varArgsCount = n4;
            this.bridge = bl2;
        }

        public boolean isVarArgs() {
            return this.varArgs;
        }

        public int getExactCount() {
            return this.exactCount;
        }

        public int getAssignableCount() {
            return this.assignableCount;
        }

        public int getCoercible() {
            return this.coercibleCount;
        }

        public int getVarArgsCount() {
            return this.varArgsCount;
        }

        public boolean isBridge() {
            return this.bridge;
        }

        @Override
        public int compareTo(MatchResult matchResult) {
            int n = Boolean.compare(matchResult.isVarArgs(), this.isVarArgs());
            if (n == 0 && (n = Integer.compare(this.getExactCount(), matchResult.getExactCount())) == 0 && (n = Integer.compare(this.getAssignableCount(), matchResult.getAssignableCount())) == 0 && (n = Integer.compare(this.getCoercible(), matchResult.getCoercible())) == 0 && (n = Integer.compare(matchResult.getVarArgsCount(), this.getVarArgsCount())) == 0) {
                n = Boolean.compare(matchResult.isBridge(), this.isBridge());
            }
            return n;
        }

        public boolean equals(Object object) {
            return object == this || null != object && this.getClass().equals(object.getClass()) && ((MatchResult)object).getExactCount() == this.getExactCount() && ((MatchResult)object).getAssignableCount() == this.getAssignableCount() && ((MatchResult)object).getCoercible() == this.getCoercible() && ((MatchResult)object).getVarArgsCount() == this.getVarArgsCount() && ((MatchResult)object).isVarArgs() == this.isVarArgs() && ((MatchResult)object).isBridge() == this.isBridge();
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + this.assignableCount;
            n = 31 * n + (this.bridge ? 1231 : 1237);
            n = 31 * n + this.coercibleCount;
            n = 31 * n + this.exactCount;
            n = 31 * n + (this.varArgs ? 1231 : 1237);
            n = 31 * n + this.varArgsCount;
            return n;
        }
    }

    private static class PrivilegedGetTccl
    implements PrivilegedAction<ClassLoader> {
        private PrivilegedGetTccl() {
        }

        @Override
        public ClassLoader run() {
            return Thread.currentThread().getContextClassLoader();
        }
    }
}

