/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram;

import net.sourceforge.plantuml.klimt.Fashion;
import net.sourceforge.plantuml.sequencediagram.AbstractEvent;
import net.sourceforge.plantuml.sequencediagram.AbstractMessage;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.LifeEventType;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.style.StyleSignature;

public class LifeEvent
extends AbstractEvent
implements Event {
    private final Participant p;
    private final LifeEventType type;
    private final Fashion backcolor;
    private final StyleBuilder styleBuilder;
    private AbstractMessage message;

    public LifeEvent(Participant p, LifeEventType type, Fashion backcolor, StyleBuilder styleBuilder) {
        this.styleBuilder = styleBuilder;
        this.p = p;
        this.type = type;
        this.backcolor = backcolor;
    }

    public String toString() {
        return "LifeEvent:" + this.p + " " + this.type;
    }

    public Participant getParticipant() {
        return this.p;
    }

    public LifeEventType getType() {
        return this.type;
    }

    public Fashion getSpecificColors() {
        return this.backcolor;
    }

    @Override
    public boolean dealWith(Participant someone) {
        return this.p == someone;
    }

    public boolean isActivate() {
        return this.type == LifeEventType.ACTIVATE;
    }

    public boolean isDeactivateOrDestroy() {
        return this.type == LifeEventType.DEACTIVATE || this.type == LifeEventType.DESTROY;
    }

    public boolean isDeactivate() {
        return this.type == LifeEventType.DEACTIVATE;
    }

    public boolean isDestroy(Participant p) {
        return this.p == p && this.type == LifeEventType.DESTROY;
    }

    public void setMessage(AbstractMessage message) {
        this.message = message;
    }

    public AbstractMessage getMessage() {
        return this.message;
    }

    public StyleSignature getStyleSignature() {
        return this.type.getStyleSignature();
    }

    public Style[] getUsedStyle() {
        Style style = this.type.getStyleSignature().getMergedStyle(this.styleBuilder);
        return new Style[]{style};
    }
}

