/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.script.filter.lucene.relevance;

import java.util.List;
import java.util.Map;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.sql.exception.SemanticCheckException;
import org.opensearch.sql.expression.NamedArgumentExpression;
import org.opensearch.sql.expression.ReferenceExpression;
import org.opensearch.sql.opensearch.storage.script.filter.lucene.relevance.RelevanceQuery;

abstract class SingleFieldQuery<T extends QueryBuilder>
extends RelevanceQuery<T> {
    public SingleFieldQuery(Map<String, RelevanceQuery.QueryBuilderStep<T>> queryBuildActions) {
        super(queryBuildActions);
    }

    @Override
    protected T createQueryBuilder(List<NamedArgumentExpression> arguments2) {
        NamedArgumentExpression field = arguments2.stream().filter(a -> a.getArgName().equalsIgnoreCase("field")).findFirst().orElseThrow(() -> new SemanticCheckException("'field' parameter is missing."));
        NamedArgumentExpression query = arguments2.stream().filter(a -> a.getArgName().equalsIgnoreCase("query")).findFirst().orElseThrow(() -> new SemanticCheckException("'query' parameter is missing"));
        return this.createBuilder(((ReferenceExpression)field.getValue()).getAttr(), query.getValue().valueOf().stringValue());
    }

    protected abstract T createBuilder(String var1, String var2);
}

