/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.data.utils;

import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.sql.opensearch.data.utils.Content;

public class ObjectContent
implements Content {
    private final Object value;

    @Override
    public Integer intValue() {
        return this.parseNumberValue(this.value, v -> Double.valueOf(v).intValue(), Number::intValue);
    }

    @Override
    public Long longValue() {
        return this.parseNumberValue(this.value, v -> Double.valueOf(v).longValue(), Number::longValue);
    }

    @Override
    public Short shortValue() {
        return this.parseNumberValue(this.value, v -> Double.valueOf(v).shortValue(), Number::shortValue);
    }

    @Override
    public Byte byteValue() {
        return this.parseNumberValue(this.value, v -> Double.valueOf(v).byteValue(), Number::byteValue);
    }

    @Override
    public Float floatValue() {
        return this.parseNumberValue(this.value, Float::valueOf, Number::floatValue);
    }

    @Override
    public Double doubleValue() {
        return this.parseNumberValue(this.value, Double::valueOf, Number::doubleValue);
    }

    @Override
    public String stringValue() {
        return (String)this.value;
    }

    @Override
    public Boolean booleanValue() {
        if (this.value instanceof String) {
            return Boolean.valueOf((String)this.value);
        }
        if (this.value instanceof Number) {
            return ((Number)this.value).intValue() != 0;
        }
        return (Boolean)this.value;
    }

    @Override
    public Object objectValue() {
        return this.value;
    }

    @Override
    public Iterator<Map.Entry<String, Content>> map() {
        return ((Map)this.value).entrySet().stream().map(entry -> new AbstractMap.SimpleEntry<String, ObjectContent>((String)entry.getKey(), new ObjectContent(entry.getValue()))).iterator();
    }

    @Override
    public Iterator<? extends Content> array() {
        return ((List)this.value).stream().map(ObjectContent::new).iterator();
    }

    @Override
    public boolean isNull() {
        return this.value == null;
    }

    @Override
    public boolean isNumber() {
        return this.value instanceof Number;
    }

    @Override
    public boolean isFloat() {
        return this.value instanceof Float;
    }

    @Override
    public boolean isDouble() {
        return this.value instanceof Double;
    }

    @Override
    public boolean isLong() {
        return this.value instanceof Long;
    }

    @Override
    public boolean isBoolean() {
        return this.value instanceof Boolean;
    }

    @Override
    public boolean isArray() {
        return this.value instanceof ArrayNode;
    }

    @Override
    public boolean isString() {
        return this.value instanceof String;
    }

    @Override
    public Pair<Double, Double> geoValue() {
        String[] split = ((String)this.value).split(",");
        return Pair.of(Double.valueOf(split[0]), Double.valueOf(split[1]));
    }

    private <T> T parseNumberValue(Object value, Function<String, T> stringTFunction, Function<Number, T> numberTFunction) {
        if (value instanceof String) {
            return stringTFunction.apply((String)value);
        }
        return numberTFunction.apply((Number)value);
    }

    @Generated
    public ObjectContent(Object value) {
        this.value = value;
    }
}

