/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.executor;

import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rel.type.RelDataTypeSystemImpl;
import org.apache.calcite.sql.type.SqlTypeName;

public class OpenSearchTypeSystem
extends RelDataTypeSystemImpl {
    public static final RelDataTypeSystem INSTANCE = new OpenSearchTypeSystem();

    private OpenSearchTypeSystem() {
    }

    @Override
    public RelDataType deriveAvgAggType(RelDataTypeFactory typeFactory, RelDataType argumentType) {
        if (SqlTypeName.DECIMAL == argumentType.getSqlTypeName()) {
            return typeFactory.createTypeWithNullability(OpenSearchTypeSystem.highPrecision(typeFactory, argumentType), false);
        }
        if (SqlTypeName.INT_TYPES.contains((Object)argumentType.getSqlTypeName())) {
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.DOUBLE), false);
        }
        return argumentType;
    }

    public static RelDataType highPrecision(RelDataTypeFactory typeFactory, RelDataType type2) {
        if (type2.getSqlTypeName() == SqlTypeName.DECIMAL) {
            return typeFactory.createSqlType(type2.getSqlTypeName(), Math.min(type2.getPrecision() + 4, typeFactory.getTypeSystem().getMaxPrecision(SqlTypeName.DECIMAL)), Math.min(type2.getScale() + 4, typeFactory.getTypeSystem().getMaxScale(SqlTypeName.DECIMAL)));
        }
        return type2;
    }
}

