/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import java.util.Objects;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.adapter.enumerable.JavaRowFormat;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.FunctionExpression;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Collect;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.util.BuiltInMethod;

public class EnumerableCollect
extends Collect
implements EnumerableRel {
    public EnumerableCollect(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RelDataType rowType) {
        super(cluster, traitSet, input, rowType);
        assert (this.getConvention() instanceof EnumerableConvention);
        assert (this.getConvention() == input.getConvention());
    }

    @Deprecated
    public EnumerableCollect(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, String fieldName) {
        this(cluster, traitSet, input, EnumerableCollect.deriveRowType(cluster.getTypeFactory(), SqlTypeName.MULTISET, fieldName, input.getRowType()));
    }

    public static Collect create(RelNode input, RelDataType rowType) {
        RelOptCluster cluster = input.getCluster();
        RelTraitSet traitSet = cluster.traitSet().replace(EnumerableConvention.INSTANCE);
        return new EnumerableCollect(cluster, traitSet, input, rowType);
    }

    @Override
    public EnumerableCollect copy(RelTraitSet traitSet, RelNode newInput) {
        return new EnumerableCollect(this.getCluster(), traitSet, newInput, this.rowType());
    }

    @Override
    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        Expression collectionExpr;
        Expression child_;
        BlockBuilder builder = new BlockBuilder();
        EnumerableRel child = (EnumerableRel)this.getInput();
        EnumerableRel.Result result2 = implementor.visitChild(this, 0, child, EnumerableRel.Prefer.ARRAY);
        PhysType physType = PhysTypeImpl.of(implementor.getTypeFactory(), this.getRowType(), JavaRowFormat.LIST);
        SqlTypeName collectionType = this.getCollectionType();
        Expression conv_ = child_ = builder.append("child", result2.block);
        switch (collectionType) {
            case ARRAY: 
            case MULTISET: {
                RelDataType collectionComponentType = Objects.requireNonNull(this.rowType().getFieldList().get(0).getType().getComponentType());
                RelDataType childRecordType = result2.physType.getRowType().getFieldList().get(0).getType();
                if (!SqlTypeUtil.sameNamedType(collectionComponentType, childRecordType)) {
                    conv_ = builder.append("converted", result2.physType.convertTo(child_, JavaRowFormat.ARRAY));
                }
                collectionExpr = builder.append("list", Expressions.call(conv_, BuiltInMethod.ENUMERABLE_TO_LIST.method, new Expression[0]));
                break;
            }
            case MAP: {
                ParameterExpression input = Expressions.parameter(Object.class, "input");
                FunctionExpression keySelector = Expressions.lambda((Expression)Expressions.arrayIndex(Expressions.convert_(input, Object[].class), Expressions.constant(0)), input);
                FunctionExpression valueSelector = Expressions.lambda((Expression)Expressions.arrayIndex(Expressions.convert_(input, Object[].class), Expressions.constant(1)), input);
                collectionExpr = builder.append("map", Expressions.call(conv_, BuiltInMethod.ENUMERABLE_TO_MAP.method, keySelector, valueSelector));
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown collection type " + (Object)((Object)collectionType));
            }
        }
        builder.add(Expressions.return_(null, Expressions.call(BuiltInMethod.SINGLETON_ENUMERABLE.method, collectionExpr)));
        return implementor.result(physType, builder.toBlock());
    }
}

