/*
 * Decompiled with CFR 0.152.
 */
package com.google.uzaygezen.core;

import com.google.uzaygezen.core.Content;
import java.math.BigInteger;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import shaded.com.google.common.base.Preconditions;

public class BigIntegerContent
implements Content<BigIntegerContent> {
    private BigInteger value;

    public BigIntegerContent(BigInteger v) {
        Preconditions.checkArgument(v.signum() >= 0);
        this.value = v;
    }

    public BigInteger value() {
        return this.value;
    }

    @Override
    public void add(BigIntegerContent other) {
        this.value = this.value.add(other.value);
    }

    @Override
    public boolean isZero() {
        return this.value.signum() == 0;
    }

    @Override
    public int compareTo(BigIntegerContent o) {
        return this.value.compareTo(o.value);
    }

    @Override
    public void shiftRight(int n) {
        this.value = this.value.shiftRight(n);
    }

    @Override
    public boolean isOne() {
        return this.value.equals(BigInteger.ONE);
    }

    public int hashCode() {
        return ~this.value.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BigIntegerContent)) {
            return false;
        }
        BigIntegerContent other = (BigIntegerContent)obj;
        return this.value.equals(other.value);
    }

    @Override
    public BigIntegerContent clone() {
        return new BigIntegerContent(this.value);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

