/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.AggregationVariant;
import org.opensearch.client.opensearch._types.aggregations.BucketAggregationBase;
import org.opensearch.client.opensearch._types.aggregations.HistogramOrder;
import org.opensearch.client.opensearch._types.aggregations.MultiTermLookup;
import org.opensearch.client.opensearch._types.aggregations.TermsAggregationCollectMode;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class MultiTermsAggregation
extends BucketAggregationBase
implements AggregationVariant,
ToCopyableBuilder<Builder, MultiTermsAggregation> {
    @Nullable
    private final TermsAggregationCollectMode collectMode;
    @Nullable
    private final Integer minDocCount;
    @Nullable
    private final HistogramOrder order;
    @Nullable
    private final Integer shardMinDocCount;
    @Nullable
    private final Integer shardSize;
    @Nullable
    private final Boolean showTermDocCountError;
    @Nullable
    private final Integer size;
    @Nonnull
    private final List<MultiTermLookup> terms;
    public static final JsonpDeserializer<MultiTermsAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MultiTermsAggregation::setupMultiTermsAggregationDeserializer);

    private MultiTermsAggregation(Builder builder) {
        super(builder);
        this.collectMode = builder.collectMode;
        this.minDocCount = builder.minDocCount;
        this.order = builder.order;
        this.shardMinDocCount = builder.shardMinDocCount;
        this.shardSize = builder.shardSize;
        this.showTermDocCountError = builder.showTermDocCountError;
        this.size = builder.size;
        this.terms = ApiTypeHelper.unmodifiableRequired(builder.terms, (Object)this, "terms");
    }

    public static MultiTermsAggregation of(Function<Builder, ObjectBuilder<MultiTermsAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.MultiTerms;
    }

    @Nullable
    public final TermsAggregationCollectMode collectMode() {
        return this.collectMode;
    }

    @Nullable
    public final Integer minDocCount() {
        return this.minDocCount;
    }

    @Nullable
    public final HistogramOrder order() {
        return this.order;
    }

    @Nullable
    public final Integer shardMinDocCount() {
        return this.shardMinDocCount;
    }

    @Nullable
    public final Integer shardSize() {
        return this.shardSize;
    }

    @Nullable
    public final Boolean showTermDocCountError() {
        return this.showTermDocCountError;
    }

    @Nullable
    public final Integer size() {
        return this.size;
    }

    @Nonnull
    public final List<MultiTermLookup> terms() {
        return this.terms;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.collectMode != null) {
            generator.writeKey("collect_mode");
            this.collectMode.serialize(generator, mapper);
        }
        if (this.minDocCount != null) {
            generator.writeKey("min_doc_count");
            generator.write(this.minDocCount.intValue());
        }
        if (this.order != null) {
            generator.writeKey("order");
            this.order.serialize(generator, mapper);
        }
        if (this.shardMinDocCount != null) {
            generator.writeKey("shard_min_doc_count");
            generator.write(this.shardMinDocCount.intValue());
        }
        if (this.shardSize != null) {
            generator.writeKey("shard_size");
            generator.write(this.shardSize.intValue());
        }
        if (this.showTermDocCountError != null) {
            generator.writeKey("show_term_doc_count_error");
            generator.write(this.showTermDocCountError.booleanValue());
        }
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size.intValue());
        }
        generator.writeKey("terms");
        generator.writeStartArray();
        for (MultiTermLookup item0 : this.terms) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupMultiTermsAggregationDeserializer(ObjectDeserializer<Builder> op) {
        MultiTermsAggregation.setupBucketAggregationBaseDeserializer(op);
        op.add(Builder::collectMode, TermsAggregationCollectMode._DESERIALIZER, "collect_mode");
        op.add(Builder::minDocCount, JsonpDeserializer.integerDeserializer(), "min_doc_count");
        op.add(Builder::order, HistogramOrder._DESERIALIZER, "order");
        op.add(Builder::shardMinDocCount, JsonpDeserializer.integerDeserializer(), "shard_min_doc_count");
        op.add(Builder::shardSize, JsonpDeserializer.integerDeserializer(), "shard_size");
        op.add(Builder::showTermDocCountError, JsonpDeserializer.booleanDeserializer(), "show_term_doc_count_error");
        op.add(Builder::size, JsonpDeserializer.integerDeserializer(), "size");
        op.add(Builder::terms, JsonpDeserializer.arrayDeserializer(MultiTermLookup._DESERIALIZER), "terms");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.collectMode);
        result = 31 * result + Objects.hashCode(this.minDocCount);
        result = 31 * result + Objects.hashCode(this.order);
        result = 31 * result + Objects.hashCode(this.shardMinDocCount);
        result = 31 * result + Objects.hashCode(this.shardSize);
        result = 31 * result + Objects.hashCode(this.showTermDocCountError);
        result = 31 * result + Objects.hashCode(this.size);
        result = 31 * result + this.terms.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiTermsAggregation other = (MultiTermsAggregation)o;
        return Objects.equals(this.collectMode, other.collectMode) && Objects.equals(this.minDocCount, other.minDocCount) && Objects.equals(this.order, other.order) && Objects.equals(this.shardMinDocCount, other.shardMinDocCount) && Objects.equals(this.shardSize, other.shardSize) && Objects.equals(this.showTermDocCountError, other.showTermDocCountError) && Objects.equals(this.size, other.size) && this.terms.equals(other.terms);
    }

    public static class Builder
    extends BucketAggregationBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, MultiTermsAggregation> {
        @Nullable
        private TermsAggregationCollectMode collectMode;
        @Nullable
        private Integer minDocCount;
        @Nullable
        private HistogramOrder order;
        @Nullable
        private Integer shardMinDocCount;
        @Nullable
        private Integer shardSize;
        @Nullable
        private Boolean showTermDocCountError;
        @Nullable
        private Integer size;
        private List<MultiTermLookup> terms;

        public Builder() {
        }

        private Builder(MultiTermsAggregation o) {
            super(o);
            this.collectMode = o.collectMode;
            this.minDocCount = o.minDocCount;
            this.order = o.order;
            this.shardMinDocCount = o.shardMinDocCount;
            this.shardSize = o.shardSize;
            this.showTermDocCountError = o.showTermDocCountError;
            this.size = o.size;
            this.terms = Builder._listCopy(o.terms);
        }

        private Builder(Builder o) {
            super(o);
            this.collectMode = o.collectMode;
            this.minDocCount = o.minDocCount;
            this.order = o.order;
            this.shardMinDocCount = o.shardMinDocCount;
            this.shardSize = o.shardSize;
            this.showTermDocCountError = o.showTermDocCountError;
            this.size = o.size;
            this.terms = Builder._listCopy(o.terms);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder collectMode(@Nullable TermsAggregationCollectMode value) {
            this.collectMode = value;
            return this;
        }

        @Nonnull
        public final Builder minDocCount(@Nullable Integer value) {
            this.minDocCount = value;
            return this;
        }

        @Nonnull
        public final Builder order(@Nullable HistogramOrder value) {
            this.order = value;
            return this;
        }

        @Nonnull
        public final Builder order(Function<HistogramOrder.Builder, ObjectBuilder<HistogramOrder>> fn) {
            return this.order(fn.apply(new HistogramOrder.Builder()).build());
        }

        @Nonnull
        public final Builder shardMinDocCount(@Nullable Integer value) {
            this.shardMinDocCount = value;
            return this;
        }

        @Nonnull
        public final Builder shardSize(@Nullable Integer value) {
            this.shardSize = value;
            return this;
        }

        @Nonnull
        public final Builder showTermDocCountError(@Nullable Boolean value) {
            this.showTermDocCountError = value;
            return this;
        }

        @Nonnull
        public final Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        @Nonnull
        public final Builder terms(List<MultiTermLookup> list) {
            this.terms = Builder._listAddAll(this.terms, list);
            return this;
        }

        @Nonnull
        public final Builder terms(MultiTermLookup value, MultiTermLookup ... values) {
            this.terms = Builder._listAdd(this.terms, value, values);
            return this;
        }

        @Nonnull
        public final Builder terms(Function<MultiTermLookup.Builder, ObjectBuilder<MultiTermLookup>> fn) {
            return this.terms(fn.apply(new MultiTermLookup.Builder()).build(), new MultiTermLookup[0]);
        }

        @Override
        @Nonnull
        public MultiTermsAggregation build() {
            this._checkSingleUse();
            return new MultiTermsAggregation(this);
        }
    }
}

