/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.util.prune;

import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public enum PruneType {
    NONE("none"),
    TOP_K("top_k"),
    ALPHA_MASS("alpha_mass"),
    MAX_RATIO("max_ratio"),
    ABS_VALUE("abs_value");

    private final String value;
    private static final Map<String, PruneType> VALUE_MAP;

    private PruneType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static PruneType fromString(String value) {
        if (StringUtils.isEmpty((String)value)) {
            return NONE;
        }
        PruneType type = VALUE_MAP.get(value);
        if (type == null) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Unknown prune type: %s", value));
        }
        return type;
    }

    static {
        VALUE_MAP = Arrays.stream(PruneType.values()).collect(Collectors.toUnmodifiableMap(status -> status.value, Function.identity()));
    }
}

