/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.CoipAddressUsage;
import software.amazon.awssdk.services.ec2.model.CoipAddressUsageSetCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCoipPoolUsageResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, GetCoipPoolUsageResponse> {
    private static final SdkField<String> COIP_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CoipPoolId").getter(GetCoipPoolUsageResponse.getter(GetCoipPoolUsageResponse::coipPoolId)).setter(GetCoipPoolUsageResponse.setter(Builder::coipPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoipPoolId").unmarshallLocationName("coipPoolId").build()}).build();
    private static final SdkField<List<CoipAddressUsage>> COIP_ADDRESS_USAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CoipAddressUsages").getter(GetCoipPoolUsageResponse.getter(GetCoipPoolUsageResponse::coipAddressUsages)).setter(GetCoipPoolUsageResponse.setter(Builder::coipAddressUsages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoipAddressUsageSet").unmarshallLocationName("coipAddressUsageSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CoipAddressUsage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> LOCAL_GATEWAY_ROUTE_TABLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocalGatewayRouteTableId").getter(GetCoipPoolUsageResponse.getter(GetCoipPoolUsageResponse::localGatewayRouteTableId)).setter(GetCoipPoolUsageResponse.setter(Builder::localGatewayRouteTableId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalGatewayRouteTableId").unmarshallLocationName("localGatewayRouteTableId").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetCoipPoolUsageResponse.getter(GetCoipPoolUsageResponse::nextToken)).setter(GetCoipPoolUsageResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COIP_POOL_ID_FIELD, COIP_ADDRESS_USAGES_FIELD, LOCAL_GATEWAY_ROUTE_TABLE_ID_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetCoipPoolUsageResponse.memberNameToFieldInitializer();
    private final String coipPoolId;
    private final List<CoipAddressUsage> coipAddressUsages;
    private final String localGatewayRouteTableId;
    private final String nextToken;

    private GetCoipPoolUsageResponse(BuilderImpl builder) {
        super(builder);
        this.coipPoolId = builder.coipPoolId;
        this.coipAddressUsages = builder.coipAddressUsages;
        this.localGatewayRouteTableId = builder.localGatewayRouteTableId;
        this.nextToken = builder.nextToken;
    }

    public final String coipPoolId() {
        return this.coipPoolId;
    }

    public final boolean hasCoipAddressUsages() {
        return this.coipAddressUsages != null && !(this.coipAddressUsages instanceof SdkAutoConstructList);
    }

    public final List<CoipAddressUsage> coipAddressUsages() {
        return this.coipAddressUsages;
    }

    public final String localGatewayRouteTableId() {
        return this.localGatewayRouteTableId;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.coipPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCoipAddressUsages() ? this.coipAddressUsages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.localGatewayRouteTableId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCoipPoolUsageResponse)) {
            return false;
        }
        GetCoipPoolUsageResponse other = (GetCoipPoolUsageResponse)((Object)obj);
        return Objects.equals(this.coipPoolId(), other.coipPoolId()) && this.hasCoipAddressUsages() == other.hasCoipAddressUsages() && Objects.equals(this.coipAddressUsages(), other.coipAddressUsages()) && Objects.equals(this.localGatewayRouteTableId(), other.localGatewayRouteTableId()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetCoipPoolUsageResponse").add("CoipPoolId", (Object)this.coipPoolId()).add("CoipAddressUsages", this.hasCoipAddressUsages() ? this.coipAddressUsages() : null).add("LocalGatewayRouteTableId", (Object)this.localGatewayRouteTableId()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CoipPoolId": {
                return Optional.ofNullable(clazz.cast(this.coipPoolId()));
            }
            case "CoipAddressUsages": {
                return Optional.ofNullable(clazz.cast(this.coipAddressUsages()));
            }
            case "LocalGatewayRouteTableId": {
                return Optional.ofNullable(clazz.cast(this.localGatewayRouteTableId()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CoipPoolId", COIP_POOL_ID_FIELD);
        map.put("CoipAddressUsageSet", COIP_ADDRESS_USAGES_FIELD);
        map.put("LocalGatewayRouteTableId", LOCAL_GATEWAY_ROUTE_TABLE_ID_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCoipPoolUsageResponse, T> g) {
        return obj -> g.apply((GetCoipPoolUsageResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String coipPoolId;
        private List<CoipAddressUsage> coipAddressUsages = DefaultSdkAutoConstructList.getInstance();
        private String localGatewayRouteTableId;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCoipPoolUsageResponse model) {
            super(model);
            this.coipPoolId(model.coipPoolId);
            this.coipAddressUsages(model.coipAddressUsages);
            this.localGatewayRouteTableId(model.localGatewayRouteTableId);
            this.nextToken(model.nextToken);
        }

        public final String getCoipPoolId() {
            return this.coipPoolId;
        }

        public final void setCoipPoolId(String coipPoolId) {
            this.coipPoolId = coipPoolId;
        }

        @Override
        public final Builder coipPoolId(String coipPoolId) {
            this.coipPoolId = coipPoolId;
            return this;
        }

        public final List<CoipAddressUsage.Builder> getCoipAddressUsages() {
            List<CoipAddressUsage.Builder> result = CoipAddressUsageSetCopier.copyToBuilder(this.coipAddressUsages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCoipAddressUsages(Collection<CoipAddressUsage.BuilderImpl> coipAddressUsages) {
            this.coipAddressUsages = CoipAddressUsageSetCopier.copyFromBuilder(coipAddressUsages);
        }

        @Override
        public final Builder coipAddressUsages(Collection<CoipAddressUsage> coipAddressUsages) {
            this.coipAddressUsages = CoipAddressUsageSetCopier.copy(coipAddressUsages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder coipAddressUsages(CoipAddressUsage ... coipAddressUsages) {
            this.coipAddressUsages(Arrays.asList(coipAddressUsages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder coipAddressUsages(Consumer<CoipAddressUsage.Builder> ... coipAddressUsages) {
            this.coipAddressUsages(Stream.of(coipAddressUsages).map(c -> (CoipAddressUsage)((CoipAddressUsage.Builder)CoipAddressUsage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getLocalGatewayRouteTableId() {
            return this.localGatewayRouteTableId;
        }

        public final void setLocalGatewayRouteTableId(String localGatewayRouteTableId) {
            this.localGatewayRouteTableId = localGatewayRouteTableId;
        }

        @Override
        public final Builder localGatewayRouteTableId(String localGatewayRouteTableId) {
            this.localGatewayRouteTableId = localGatewayRouteTableId;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetCoipPoolUsageResponse build() {
            return new GetCoipPoolUsageResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCoipPoolUsageResponse> {
        public Builder coipPoolId(String var1);

        public Builder coipAddressUsages(Collection<CoipAddressUsage> var1);

        public Builder coipAddressUsages(CoipAddressUsage ... var1);

        public Builder coipAddressUsages(Consumer<CoipAddressUsage.Builder> ... var1);

        public Builder localGatewayRouteTableId(String var1);

        public Builder nextToken(String var1);
    }
}

