"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDependentState = useDependentState;

var _react = require("react");

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; } /*
                                                                       * SPDX-License-Identifier: Apache-2.0
                                                                       *
                                                                       * The OpenSearch Contributors require contributions made to
                                                                       * this file be licensed under the Apache-2.0 license or a
                                                                       * compatible open source license.
                                                                       *
                                                                       * Modifications Copyright OpenSearch Contributors. See
                                                                       * GitHub history for details.
                                                                       */ /*
                                                                           * Licensed to Elasticsearch B.V. under one or more contributor
                                                                           * license agreements. See the NOTICE file distributed with
                                                                           * this work for additional information regarding copyright
                                                                           * ownership. Elasticsearch B.V. licenses this file to you under
                                                                           * the Apache License, Version 2.0 (the "License"); you may
                                                                           * not use this file except in compliance with the License.
                                                                           * You may obtain a copy of the License at
                                                                           *
                                                                           *    http://www.apache.org/licenses/LICENSE-2.0
                                                                           *
                                                                           * Unless required by applicable law or agreed to in writing,
                                                                           * software distributed under the License is distributed on an
                                                                           * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
                                                                           * KIND, either express or implied.  See the License for the
                                                                           * specific language governing permissions and limitations
                                                                           * under the License.
                                                                           */

function useDependentState(valueFn, deps) {
  var _useState = (0, _react.useState)(valueFn),
      _useState2 = _slicedToArray(_useState, 2),
      state = _useState2[0],
      setState = _useState2[1]; // use ref instead of a state to avoid causing an unnecessary re-render


  var hasMounted = (0, _react.useRef)(false);
  (0, _react.useEffect)(function () {
    // don't call setState on initial mount
    if (hasMounted.current === true) {
      setState(valueFn);
    } else {
      hasMounted.current = true;
    } // purposefully omitting `updateCount.current` and `valueFn`
    // this means updating only the valueFn has no effect, but allows for more natural feeling hook use
    // eslint-disable-next-line react-hooks/exhaustive-deps

  }, deps);
  return [state, setState];
}