/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rule.autotagging;

import java.util.HashMap;
import java.util.Map;
import org.opensearch.ResourceNotFoundException;
import org.opensearch.rule.autotagging.FeatureType;

public class AutoTaggingRegistry {
    public static final Map<String, FeatureType> featureTypesRegistryMap = new HashMap<String, FeatureType>();
    public static final int MAX_FEATURE_TYPE_NAME_LENGTH = 30;

    private AutoTaggingRegistry() {
    }

    public static void registerFeatureType(FeatureType featureType) {
        AutoTaggingRegistry.validateFeatureType(featureType);
        String name = featureType.getName();
        if (featureTypesRegistryMap.containsKey(name) && featureTypesRegistryMap.get(name) != featureType) {
            throw new IllegalStateException("Feature type " + name + " is already registered. Duplicate feature type is not allowed.");
        }
        featureTypesRegistryMap.put(name, featureType);
    }

    private static void validateFeatureType(FeatureType featureType) {
        if (featureType == null) {
            throw new IllegalStateException("Feature type can't be null. Unable to register.");
        }
        String name = featureType.getName();
        if (name == null || name.isEmpty() || name.length() > 30) {
            throw new IllegalStateException("Feature type name " + name + " should not be null, empty or have more than  30characters");
        }
        if (featureType.getFeatureValueValidator() == null) {
            throw new IllegalStateException("FeatureValueValidator is not defined for feature type " + name);
        }
    }

    public static FeatureType getFeatureType(String featureTypeName) {
        FeatureType featureType = featureTypesRegistryMap.get(featureTypeName);
        if (featureType == null) {
            throw new ResourceNotFoundException("Couldn't find a feature type with name: " + featureTypeName + ". Make sure you have registered it.", new Object[0]);
        }
        return featureType;
    }
}

