/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.ChangePropertyKeyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.validation.tests.MapCSSTagCheckerRule;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.mapcss.Expression;
import org.openstreetmap.josm.gui.mappaint.mapcss.Selector;
import org.openstreetmap.josm.tools.CheckParameterUtil;

@FunctionalInterface
interface MapCSSTagCheckerFixCommand {
    public Command createCommand(OsmPrimitive var1, Selector var2);

    public static void checkObject(Object obj) {
        CheckParameterUtil.ensureThat(obj instanceof Expression || obj instanceof String, () -> "instance of Exception or String expected, but got " + obj);
    }

    public static String evaluateObject(Object obj, OsmPrimitive p, Selector matchingSelector) {
        String s;
        if (obj instanceof Expression) {
            s = (String)((Expression)obj).evaluate(new Environment(p).withSelector(matchingSelector));
        } else if (obj instanceof String) {
            s = (String)obj;
        } else {
            return null;
        }
        return MapCSSTagCheckerRule.insertArguments(matchingSelector, s, p);
    }

    public static MapCSSTagCheckerFixCommand fixAdd(final Object obj) {
        MapCSSTagCheckerFixCommand.checkObject(obj);
        return new MapCSSTagCheckerFixCommand(){

            @Override
            public Command createCommand(OsmPrimitive p, Selector matchingSelector) {
                Tag tag = Tag.ofString(MapCSSTagCheckerFixCommand.evaluateObject(obj, p, matchingSelector));
                return new ChangePropertyCommand(p, tag.getKey(), tag.getValue());
            }

            public String toString() {
                return "fixAdd: " + obj;
            }
        };
    }

    public static MapCSSTagCheckerFixCommand fixRemove(final Object obj) {
        MapCSSTagCheckerFixCommand.checkObject(obj);
        return new MapCSSTagCheckerFixCommand(){

            @Override
            public Command createCommand(OsmPrimitive p, Selector matchingSelector) {
                String key = MapCSSTagCheckerFixCommand.evaluateObject(obj, p, matchingSelector);
                return new ChangePropertyCommand(p, key, "");
            }

            public String toString() {
                return "fixRemove: " + obj;
            }
        };
    }

    public static MapCSSTagCheckerFixCommand fixChangeKey(final String oldKey, final String newKey) {
        return new MapCSSTagCheckerFixCommand(){

            @Override
            public Command createCommand(OsmPrimitive p, Selector matchingSelector) {
                return new ChangePropertyKeyCommand(p, MapCSSTagCheckerRule.insertArguments(matchingSelector, oldKey, p), MapCSSTagCheckerRule.insertArguments(matchingSelector, newKey, p));
            }

            public String toString() {
                return "fixChangeKey: " + oldKey + " => " + newKey;
            }
        };
    }
}

