#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 http-client-restricted
version:              0.1.0
visibility:           public
id:                   http-client-restricted-0.1.0-HUlwKpM7kO17lJvNCDwWII
key:                  http-client-restricted-0.1.0-HUlwKpM7kO17lJvNCDwWII
license:              MIT
copyright:            2018 Joey Hess, 2013 Michael Snoyman
maintainer:           Joey Hess <id@joeyh.name>
author:               Joey Hess
synopsis:             restricting the servers that http-client will use
description:
    Addition to the http-client and http-client-tls
    libraries, that restricts the HTTP servers that can be used.

    This is useful when a security policy needs to eg, prevent connections to
    HTTP servers on localhost or a local network, or only allow connections
    to a specific HTTP server.

    It handles restricting redirects as well as the initial HTTP connection,
    and it also guards against DNS poisoning attacks.

category:             Network
abi:                  eafd666e2c359c15064d07870c6ac930
exposed:              True
exposed-modules:      Network.HTTP.Client.Restricted
import-dirs:          /usr/lib/ghc-9.4.8/site-local/http-client-restricted-0.1.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/http-client-restricted-0.1.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/http-client-restricted-0.1.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-http-client-restricted
hs-libraries:         HShttp-client-restricted-0.1.0-HUlwKpM7kO17lJvNCDwWII
depends:
    base-4.17.2.1 crypton-connection-0.4.1-CpKZ6WFKfG37vcT27Gpidb
    data-default-0.7.1.1-86NXSPgvsmt76HSLrJaFnV
    http-client-0.7.18-459exqS5txS1OoId3JMPZk
    http-client-tls-0.3.6.4-7S2cUrl1lPP9SbVvzQv2U1
    network-3.1.4.0-FVkzt15CfOKCnNYpElqt5j
    network-bsd-2.8.1.0-DayS7el2eeMFTBhJuYB6hZ
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm

haddock-interfaces:
    /usr/share/doc/haskell-http-client-restricted/html/http-client-restricted.haddock

haddock-html:         /usr/share/doc/haskell-http-client-restricted/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

