#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 HTF
version:              0.15.0.1
visibility:           public
id:                   HTF-0.15.0.1-AJl8WNMUZhNCHl3UjGEFPI
key:                  HTF-0.15.0.1-AJl8WNMUZhNCHl3UjGEFPI
license:              LGPL-2.1-only
copyright:            (c) 2005-2023 Stefan Wehr
maintainer:           Stefan Wehr
author:               Stefan Wehr
stability:            Beta
homepage:             https://github.com/skogsbaer/HTF/
synopsis:             The Haskell Test Framework
description:
    The Haskell Test Framework (/HTF/ for short) lets you define and organize unit tests,
    QuickCheck properties,
    and black box tests in an
    easy and convenient way. HTF uses a custom preprocessor that collects
    test definitions automatically.

    HTF produces highly readable output
    for failing test cases: it provides exact file name and line number
    information,
    it colors and pretty prints expected and
    actual results, and it displays a diff highlighting the mismatching parts.

    The documentation of the "Test.Framework.Tutorial" module
    provides a tutorial for HTF. The /sample/ directory in
    the HTF repo provides a good starting point for
    a project using HTF.

category:             Testing
abi:                  fb8e3fe6206e7a3a5959a8faf2793de5
exposed:              True
exposed-modules:
    Test.Framework Test.Framework.AssertM Test.Framework.BlackBoxTest
    Test.Framework.HUnitWrapper Test.Framework.History
    Test.Framework.JsonOutput Test.Framework.Location
    Test.Framework.Preprocessor Test.Framework.Pretty
    Test.Framework.PrettyHaskell Test.Framework.QuickCheckWrapper
    Test.Framework.TestInterface Test.Framework.TestManager
    Test.Framework.TestTypes Test.Framework.ThreadPool
    Test.Framework.Tutorial Test.Framework.XmlOutput

hidden-modules:
    Paths_HTF Test.Framework.CmdlineOptions Test.Framework.Colors
    Test.Framework.Diff Test.Framework.Process
    Test.Framework.TestReporter Test.Framework.Utils

import-dirs:          /usr/lib/ghc-9.4.8/site-local/HTF-0.15.0.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/HTF-0.15.0.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/HTF-0.15.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-htf
hs-libraries:         HSHTF-0.15.0.1-AJl8WNMUZhNCHl3UjGEFPI
depends:
    Diff-0.4.1-L8DOUuNGxiiH0X79lq9Zn6
    HUnit-1.6.2.0-DUvlqmsw2Kp6tCDRl9WtXA
    QuickCheck-2.14.3-BltPJloV4Un5EUIM4U1iqr
    aeson-2.1.2.1-Gng3eoGBP2Sj2fbUBsnWH array-0.5.4.0 base-4.17.2.1
    base64-bytestring-1.2.1.0-8gOUUHpnCxrFKKvfql8iQu
    bytestring-0.11.5.3 containers-0.6.7
    cpphs-1.20.9.1-KMTErBmnvc26XA8bncSIwV directory-1.3.7.1
    haskell-src-1.0.4.1-Bu6uOfOhs9S5AjV6XCB4Ta
    lifted-base-0.2.3.12-6OqlNqkqxecGXuzHrLeTRE
    monad-control-1.0.3.1-Cs9DEjCH5Lv8Ysa7NCV3pS mtl-2.2.2
    old-time-1.1.0.4-7kNg8VzooGoExH4yeT9sv9 pretty-1.1.3.6
    process-1.6.18.0 random-1.2.1.2-FNtVSr9AyR5Fv650rjDfzJ
    regex-compat-0.95.2.2-XQpODnagAHFJ9GlOSqau8 text-2.0.2 time-1.12.2
    unix-2.7.3 vector-0.13.2.0-G0g5gCprguQ6M58H7uQE53
    xmlgen-0.6.2.2-JF8R8LuASz9IZuWmP0uDcF

haddock-interfaces:   /usr/share/doc/haskell-htf/html/HTF.haddock
haddock-html:         /usr/share/doc/haskell-htf/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

