/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.execution.plan.Node;
import org.gradle.tooling.internal.protocol.events.InternalOperationDescriptor;
import org.gradle.tooling.internal.provider.runner.OperationDependencyLookup;

class OperationDependenciesResolver {
    private final List<OperationDependencyLookup> lookups = new ArrayList<OperationDependencyLookup>();

    OperationDependenciesResolver() {
    }

    void addLookup(OperationDependencyLookup lookup) {
        this.lookups.add(lookup);
    }

    Set<InternalOperationDescriptor> resolveDependencies(Node node) {
        return node.getDependencySuccessors().stream().map(this::lookupExistingOperationDescriptor).filter(Objects::nonNull).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private InternalOperationDescriptor lookupExistingOperationDescriptor(Node node) {
        return this.lookups.stream().map(entry -> entry.lookupExistingOperationDescriptor(node)).filter(Objects::nonNull).findFirst().orElse(null);
    }
}

