/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.runtime;

import io.cucumber.core.eventbus.EventBus;
import io.cucumber.plugin.event.EventHandler;
import java.time.Instant;
import java.util.UUID;

public final class SynchronizedEventBus
implements EventBus {
    private final EventBus delegate;

    private SynchronizedEventBus(EventBus delegate) {
        this.delegate = delegate;
    }

    public static SynchronizedEventBus synchronize(EventBus eventBus) {
        if (eventBus instanceof SynchronizedEventBus) {
            return (SynchronizedEventBus)eventBus;
        }
        return new SynchronizedEventBus(eventBus);
    }

    public synchronized <T> void registerHandlerFor(Class<T> eventType, EventHandler<T> handler) {
        this.delegate.registerHandlerFor(eventType, handler);
    }

    public synchronized <T> void removeHandlerFor(Class<T> eventType, EventHandler<T> handler) {
        this.delegate.removeHandlerFor(eventType, handler);
    }

    @Override
    public Instant getInstant() {
        return this.delegate.getInstant();
    }

    @Override
    public UUID generateId() {
        return this.delegate.generateId();
    }

    @Override
    public synchronized <T> void send(T event) {
        this.delegate.send(event);
    }

    @Override
    public synchronized <T> void sendAll(Iterable<T> events) {
        this.delegate.sendAll(events);
    }
}

