﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/mediapackagev2/Mediapackagev2_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

namespace Aws
{
namespace mediapackagev2
{
namespace Model
{
  enum class ValidationExceptionType
  {
    NOT_SET,
    CONTAINER_TYPE_IMMUTABLE,
    INVALID_PAGINATION_TOKEN,
    INVALID_PAGINATION_MAX_RESULTS,
    INVALID_POLICY,
    INVALID_ROLE_ARN,
    MANIFEST_NAME_COLLISION,
    ENCRYPTION_METHOD_CONTAINER_TYPE_MISMATCH,
    CENC_IV_INCOMPATIBLE,
    ENCRYPTION_CONTRACT_WITHOUT_AUDIO_RENDITION_INCOMPATIBLE,
    ENCRYPTION_CONTRACT_WITH_ISM_CONTAINER_INCOMPATIBLE,
    ENCRYPTION_CONTRACT_UNENCRYPTED,
    ENCRYPTION_CONTRACT_SHARED,
    NUM_MANIFESTS_LOW,
    NUM_MANIFESTS_HIGH,
    MANIFEST_DRM_SYSTEMS_INCOMPATIBLE,
    DRM_SYSTEMS_ENCRYPTION_METHOD_INCOMPATIBLE,
    ROLE_ARN_NOT_ASSUMABLE,
    ROLE_ARN_LENGTH_OUT_OF_RANGE,
    ROLE_ARN_INVALID_FORMAT,
    URL_INVALID,
    URL_SCHEME,
    URL_USER_INFO,
    URL_PORT,
    URL_UNKNOWN_HOST,
    URL_LOCAL_ADDRESS,
    URL_LOOPBACK_ADDRESS,
    URL_LINK_LOCAL_ADDRESS,
    URL_MULTICAST_ADDRESS,
    MEMBER_INVALID,
    MEMBER_MISSING,
    MEMBER_MIN_VALUE,
    MEMBER_MAX_VALUE,
    MEMBER_MIN_LENGTH,
    MEMBER_MAX_LENGTH,
    MEMBER_INVALID_ENUM_VALUE,
    MEMBER_DOES_NOT_MATCH_PATTERN,
    INVALID_MANIFEST_FILTER,
    INVALID_TIME_DELAY_SECONDS,
    END_TIME_EARLIER_THAN_START_TIME,
    TS_CONTAINER_TYPE_WITH_DASH_MANIFEST,
    DIRECT_MODE_WITH_TIMING_SOURCE,
    NONE_MODE_WITH_TIMING_SOURCE,
    TIMING_SOURCE_MISSING,
    UPDATE_PERIOD_SMALLER_THAN_SEGMENT_DURATION,
    PERIOD_TRIGGERS_NONE_SPECIFIED_WITH_ADDITIONAL_VALUES,
    DRM_SIGNALING_MISMATCH_SEGMENT_ENCRYPTION_STATUS,
    ONLY_CMAF_INPUT_TYPE_ALLOW_FORCE_ENDPOINT_ERROR_CONFIGURATION,
    SOURCE_DISRUPTIONS_ENABLED_INCORRECTLY,
    HARVESTED_MANIFEST_HAS_START_END_FILTER_CONFIGURATION,
    HARVESTED_MANIFEST_NOT_FOUND_ON_ENDPOINT,
    TOO_MANY_IN_PROGRESS_HARVEST_JOBS,
    HARVEST_JOB_INELIGIBLE_FOR_CANCELLATION,
    INVALID_HARVEST_JOB_DURATION,
    HARVEST_JOB_S3_DESTINATION_MISSING_OR_INCOMPLETE,
    HARVEST_JOB_UNABLE_TO_WRITE_TO_S3_DESTINATION,
    HARVEST_JOB_CUSTOMER_ENDPOINT_READ_ACCESS_DENIED,
    CLIP_START_TIME_WITH_START_OR_END,
    START_TAG_TIME_OFFSET_INVALID,
    INCOMPATIBLE_DASH_PROFILE_DVB_DASH_CONFIGURATION,
    DASH_DVB_ATTRIBUTES_WITHOUT_DVB_DASH_PROFILE,
    INCOMPATIBLE_DASH_COMPACTNESS_CONFIGURATION,
    INCOMPATIBLE_XML_ENCODING,
    CMAF_EXCLUDE_SEGMENT_DRM_METADATA_INCOMPATIBLE_CONTAINER_TYPE,
    ONLY_CMAF_INPUT_TYPE_ALLOW_MQCS_INPUT_SWITCHING,
    ONLY_CMAF_INPUT_TYPE_ALLOW_MQCS_OUTPUT_CONFIGURATION,
    TS_CONTAINER_TYPE_WITH_MSS_MANIFEST,
    CMAF_CONTAINER_TYPE_WITH_MSS_MANIFEST,
    ISM_CONTAINER_TYPE_WITH_HLS_MANIFEST,
    ISM_CONTAINER_TYPE_WITH_LL_HLS_MANIFEST,
    ISM_CONTAINER_TYPE_WITH_DASH_MANIFEST,
    ISM_CONTAINER_TYPE_WITH_SCTE,
    ISM_CONTAINER_WITH_KEY_ROTATION,
    BATCH_GET_SECRET_VALUE_DENIED,
    GET_SECRET_VALUE_DENIED,
    DESCRIBE_SECRET_DENIED,
    INVALID_SECRET_FORMAT,
    SECRET_IS_NOT_ONE_KEY_VALUE_PAIR,
    INVALID_SECRET_KEY,
    INVALID_SECRET_VALUE,
    SECRET_ARN_RESOURCE_NOT_FOUND,
    DECRYPT_SECRET_FAILED,
    TOO_MANY_SECRETS,
    DUPLICATED_SECRET,
    MALFORMED_SECRET_ARN,
    SECRET_FROM_DIFFERENT_ACCOUNT,
    SECRET_FROM_DIFFERENT_REGION,
    INVALID_SECRET
  };

namespace ValidationExceptionTypeMapper
{
AWS_MEDIAPACKAGEV2_API ValidationExceptionType GetValidationExceptionTypeForName(const Aws::String& name);

AWS_MEDIAPACKAGEV2_API Aws::String GetNameForValidationExceptionType(ValidationExceptionType value);
} // namespace ValidationExceptionTypeMapper
} // namespace Model
} // namespace mediapackagev2
} // namespace Aws
