untrusted comment: verify with openbsd-76-base.pub
RWTkuwn4mbq8olesaoyqsH5tdAROAWQEnBOnUxYZ2UDgx8HvJNnlmjSlFewPvuvjEsSJXNlHwiVmqs5QyGGMhoapF5DJaDyoow8=

OpenBSD 7.6 errata 015, April 13, 2025:

In Perl, non-ASCII bytes in the left-hand-side of the `tr` operator
can overflow an insufficiently sized buffer.  CVE-2024-56406

Apply by doing:
    signify -Vep /etc/signify/openbsd-76-base.pub -x 015_perl.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install perl:
    cd /usr/src/gnu/usr.bin/perl
    make -f Makefile.bsd-wrapper obj
    make -f Makefile.bsd-wrapper
    make -f Makefile.bsd-wrapper install

Index: gnu/usr.bin/perl/op.c
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/op.c,v
diff -u -p -r1.28 op.c
--- gnu/usr.bin/perl/op.c	14 May 2024 19:38:54 -0000	1.28
+++ gnu/usr.bin/perl/op.c	10 Apr 2025 16:05:51 -0000
@@ -6520,6 +6520,7 @@ S_pmtrans(pTHX_ OP *o, OP *expr, OP *rep
                  * same time.  But otherwise one crosses before the other */
                 if (t_cp < 256 && r_cp_end > 255 && r_cp != t_cp) {
                     can_force_utf8 = TRUE;
+                    max_expansion = MAX(2, max_expansion);
                 }
             }
 
