untrusted comment: verify with openbsd-72-base.pub
RWQTKNnK3CZZ8NL3LBWgrWUq04X+YqIp8qGEMsOWhzfN5w16Twil3sCjgbzWGXBdOYLtr967y6cfDXReYa79ZucPtlncCYYmIgc=

OpenBSD 7.2 errata 037, July 25, 2023:

Some hypervisors remain unpatched for writes to Zenbleed DE_CFG bit.

Apply by doing:
    signify -Vep /etc/signify/openbsd-72-base.pub -x 037_hvamdcpu.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/arch/amd64/amd64/cpu.c
===================================================================
RCS file: /cvs/src/sys/arch/amd64/amd64/cpu.c,v
diff -u -p -u -r1.161.2.1 cpu.c
--- sys/arch/amd64/amd64/cpu.c	24 Jul 2023 19:33:25 -0000	1.161.2.1
+++ sys/arch/amd64/amd64/cpu.c	25 Jul 2023 03:37:08 -0000
@@ -1166,7 +1166,8 @@ cpu_fix_msrs(struct cpu_info *ci)
 			if (msr != nmsr)
 				wrmsr(MSR_DE_CFG, nmsr);
 		}
-		if (family == 0x17 && ci->ci_model >= 0x31) {
+		if (family == 0x17 && ci->ci_model >= 0x31 &&
+		    (cpu_ecxfeature & CPUIDECX_HV) == 0) {
 			nmsr = msr = rdmsr(MSR_DE_CFG);
 #define DE_CFG_SERIALIZE_9 (1 << 9)	/* Zenbleed chickenbit  */
 			nmsr |= DE_CFG_SERIALIZE_9;
Index: sys/arch/i386/i386/machdep.c
===================================================================
RCS file: /cvs/src/sys/arch/i386/i386/machdep.c,v
diff -u -p -u -r1.656.2.1 machdep.c
--- sys/arch/i386/i386/machdep.c	24 Jul 2023 19:33:25 -0000	1.656.2.1
+++ sys/arch/i386/i386/machdep.c	25 Jul 2023 03:37:08 -0000
@@ -2015,7 +2015,8 @@ identifycpu(struct cpu_info *ci)
 			if (msr != nmsr)
 				wrmsr(MSR_DE_CFG, nmsr);
 		}
-		if (family == 0x17 && ci->ci_model >= 0x31) {
+		if (family == 0x17 && ci->ci_model >= 0x31 &&
+		    (cpu_ecxfeature & CPUIDECX_HV) == 0) {
 			nmsr = msr = rdmsr(MSR_DE_CFG);
 #define DE_CFG_SERIALIZE_9 (1 << 9)		/* Zenbleed chickenbit */
 			nmsr |= DE_CFG_SERIALIZE_9;
