.\" This manpage has been automatically generated by docbook2man 
.\" from a DocBook document.  This tool can be found at:
.\" <http://shell.ipoline.com/~elmert/comp/docbook2X/> 
.\" Please send any bug reports, improvements, comments, patches, 
.\" etc. to Steve Cheng <steve@ggi-project.org>.
.TH "PG_CONNECT" "" "17 September 2020" "" "PostgreSQL Tcl Interface Documentation"

.SH NAME
pg_connect \- open a connection to the server

.SH SYNOPSIS

.nf
pg_connect -conninfo \fIconnectOptions\fR [-connhandle \fIconnectionHandleName\fR] [-async \fIbool\fR]
pg_connect \fIdbName\fR [-host \fIhostName\fR] [-port \fIportNumber\fR] [-tty \fItty\fR] [-options \fIserverOptions\fR] [-connhandle \fIconnectionHandleName\fR] [-async \fIbool\fR]
pg_connect -connlist \fIconnectNameValueList\fR [-connhandle \fIconnectionHandleName\fR] [-async \fIbool\fR]
.fi
.SH "DESCRIPTION"
.PP
\fBpg_connect\fR opens a connection to the
PostgreSQL server.
.PP
Three syntaxes are available.  In the older one, each possible option
has a separate option switch in the \fBpg_connect\fR
command.  In the newer form, a single option string is supplied
that can contain multiple option values. The third form takes
the parameters as a name value Tcl list.
\fBpg_conndefaults\fR can be used to retrieve
information about the available options in the newer syntax.
.SH "ARGUMENTS"
"NEW STYLE"
.TP
\fB\fIconnectOptions\fB\fR
\fBpg_connect\fR opens a new database connection using the 
parameters taken from the connectOptions string.  Unlike 
the old-style usage of \fBpg_connect\fR,
with the new-style usage the parameter set can be extended without 
requiring changes to either \fIlibpgtcl\fR or the underlying
\fBlibpq\fR library,
so use of the new style (or its nonexistent
nonblocking analogues \fBpg_connect_start\fR
and \fBpg_connect_poll\fR) is preferred for new 
application programming.

The passed string
can be empty to use all default parameters, or it can contain one or more
parameter settings separated by whitespace.
Each parameter setting is in the form keyword = value\&.
(To write an empty value or a value containing
spaces, surround it with single quotes, e.g.,
keyword = 'a value'\&.
Single quotes and backslashes within the value must be escaped with a
backslash, i.e., \\' and \\\\\&.)
Spaces around the equal sign are optional.

The currently recognized parameter key words are:
.RS
.TP
\fBhost\fR
Name of host to connect to.
If this begins with a slash, it specifies Unix-domain
communication rather than TCP/IP communication; the value is the
name of the directory in which the socket file is stored.  The
default is to connect to a Unix-domain socket in
\fI/tmp\fR\&.
.TP
\fBhostaddr\fR
Numeric IP address of host to connect to.  This should be in the
standard IPv4 address format, e.g., 172.28.40.9\&.  If
your machine supports IPv6, you can also use IPv6 address
format, e.g., fe80::203:93ff:fedb:49bc\&.
TCP/IP communication is
always used when a nonempty string is specified for this parameter.

Using hostaddr instead of host allows the
application to avoid a host name lookup, which may be important in
applications with time constraints. However, Kerberos authentication
requires the host name. The following therefore applies: If
host is specified without hostaddr, a host name
lookup occurs. If hostaddr is specified without
host, the value for hostaddr gives the remote
address. When Kerberos is used, a reverse name query occurs to obtain
the host name for Kerberos. If both
host and hostaddr are specified, the value for
hostaddr gives the remote address; the value for
host is ignored, unless Kerberos is used, in which case that
value is used for Kerberos authentication. (Note that authentication is
likely to fail if \fBlibpq\fR is passed a host name
that is not the name of the machine at hostaddr\&.)  Also,
host rather than hostaddr is used to identify
the connection in \fI$HOME/.pgpass\fR\&.

Without either a host name or host address,
\fBPgtcl\fR will connect using a
local Unix domain socket.
.TP
\fBport\fR
Port number to connect to at the server host, or socket file
name extension for Unix-domain
connections.
.TP
\fBdbname\fR
The database name.  Defaults to be the same as the user name.
.TP
\fBuser\fR
PostgreSQL user name to connect as.
.TP
\fBpassword\fR
Password to be used if the server demands password authentication.
.TP
\fBconnect_timeout\fR
Maximum wait for connection, in seconds (write as a decimal integer
string). Zero or not specified means wait indefinitely.  It is not
recommended to use a timeout of less than 2 seconds.
.TP
\fBoptions\fR
Command-line options to be sent to the server.
.TP
\fBtty\fR
Ignored (formerly, this specified where to send server debug output).
.TP
\fBsslmode\fR
This option determines whether or with what priority an
SSL connection will be negotiated with the
server. There are four modes: disable will attempt
only an unencrypted SSL connection;
allow will negotiate, trying first a
non-SSL connection, then if that fails, trying an
SSL connection; prefer (the default)
will negotiate, trying first an SSL connection,
then if that fails, trying a regular non-SSL
connection; require will try only an
SSL connection.

If PostgreSQL is compiled without SSL support,
using option require will cause an error, and
options allow and prefer will be
tolerated but \fBlibpq\fR will be unable to negotiate
an SSL
connection.
.TP
\fBrequiressl\fR
This option is deprecated in favor of the sslmode
setting.

If set to 1, an SSL connection to the server
is required (this is equivalent to sslmode
require).  \fBlibpq\fR will then refuse
to connect if the server does not accept an
SSL connection.  If set to 0 (default),
\fBlibpq\fR will negotiate the connection type with
the server (equivalent to sslmode
prefer).  This option is only available if
PostgreSQL is compiled with SSL support.
.TP
\fBservice\fR
Service name to use for additional parameters.  It specifies a service
name in \fIpg_service.conf\fR that holds additional connection parameters.
This allows applications to specify only a service name so connection parameters 
can be centrally maintained.  See 
\fIPREFIX/share/pg_service.conf.sample\fR for
information on how to set up the file.
.TP
\fB-connhandle \fIconnectionHandleName\fB\fR
Name to use for the connection handle, instead of pgtcl generating the
name automatically. Without the option, the name is auto-generated, prefixed with pgsql, and with a numeric id at the end. This gives the programmer control over the name of the connection handle.
.TP
\fB-async \fIbool\fB\fR
Connect asyncronously if [bool] is true.
.RE
If  any  parameter is unspecified, then the corresponding
environment variable (see libpq documentation in the PostgreSQL manual)
is checked. If the  environment  variable is not set either,
then built-in defaults are used.
"OLD STYLE"
.TP
\fB\fIdbName\fB\fR
The name of the database to connect to.
.TP
\fB-host \fIhostName\fB\fR
The host name of the database server to connect to.
.TP
\fB-port \fIportNumber\fB\fR
The TCP port number of the database server to connect to.
.TP
\fB-tty \fItty\fB\fR
A file or TTY for optional debug output from
the server.
.TP
\fB-options \fIserverOptions\fB\fR
Additional configuration options to pass to the server.
.TP
\fB-connhandle \fIconnectionHandleName\fB\fR
Name to use for the connection handle, instead of pgtcl generating the
name automatically. Without the option, the name is auto-generated, prefixed with pgsql, and with a numeric id at the end. This gives the programmer control over the name of the connection handle.
.TP
\fB-async \fIbool\fB\fR
Connect asyncronously if [bool] is true.
"THIRD STYLE (MOST RECENT ONE ADDED)"
.TP
\fB\fI-connlist connectNameValuelist\fB\fR
\fBpg_connect\fR opens a new database connection using the 
parameters taken from the connectNameValuelist list. The parameters are exactly the same for the New Style, but they are stored as a Tcl list, instead of a string. The list is a name value pair, for example: \fB[list host localhost port 5400 dbname template1]\fR\&.

.nf
array set conninfo {
    host    192.168.123.180
    port    5801
    dbname  template1
    user    postgres
}
set conn [pg::connect -connlist [array get ::conninfo]]
.fi
.TP
\fB-async \fIbool\fB\fR
Connect asyncronously if [bool] is true.
.TP
\fB-connhandle \fIconnectionHandleName\fB\fR
Name to use for the connection handle, instead of pgtcl generating the
name automatically. Without the option, the name is auto-generated, prefixed with pgsql, and with a numeric id at the end. This gives the programmer control over the name of the connection handle.
.SH "RETURN VALUE"
.PP
If successful, a handle for a database connection is returned.
Handles start with the prefix pgsql\&.
