/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.ModifyNetworkInterfaceAttributeDescription;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import java.util.Arrays;
import org.apache.commons.cli.Options;

public class ModifyNetworkInterfaceAttribute
extends BaseCmd {
    private static final String[] DESCRIPTION_DESC = new String[]{"Change the description of the network interface."};
    private static final String[] ATTACHMENT_DESC = new String[]{"Change properties of the attachment.", "Must be used in conjunction with --delete-on-termination"};
    private static final String[] DELETE_ON_TERMINATION_DESC = new String[]{"Sets whether the network interface shall be deleted when the network interface is detached.", "Must be used in conjunction with --attachment."};
    private static final String[] SOURCE_DEST_CHECK_DESC = new String[]{"Sets whether to enable the source/dest check on traffic through this network interface.", "Valid options are 'true' and 'false'."};
    private static final String[] GROUP_IDS_DESC = new String[]{"Replace the security groups for this network interface."};
    private String networkInterfaceId;
    private ModifyNetworkInterfaceAttributeDescription attribute;

    public ModifyNetworkInterfaceAttribute(String[] args) {
        super("ec2mnicatt", "ec2-modify-network-interface-attribute");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options result = new Options();
        result.addOption(ModifyNetworkInterfaceAttribute.createOptionWithArgs("d", "description", DESCRIPTION_DESC, "DESCRIPTION"));
        result.addOption(ModifyNetworkInterfaceAttribute.createOptionWithArgs("a", "attachment", ATTACHMENT_DESC, "ATTACHMENT"));
        result.addOption(ModifyNetworkInterfaceAttribute.createOptionWithArgs(null, "delete-on-termination", DELETE_ON_TERMINATION_DESC, "BOOLEAN"));
        result.addOption(ModifyNetworkInterfaceAttribute.createOptionWithArgs(null, "source-dest-check", SOURCE_DEST_CHECK_DESC, "BOOLEAN"));
        result.addOption(ModifyNetworkInterfaceAttribute.createOptionWithArgs(null, "group-id", GROUP_IDS_DESC, "GROUP_ID"));
        return result;
    }

    @Override
    protected String getOptionString() {
        return "NETWORKINTERFACE";
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption("description");
        this.printOption("attachment");
        this.printOption("delete-on-termination");
        this.printOption("source-dest-check");
        this.printOption("group-id");
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Modifies a network interface attribute. Only one attribute can be specified");
        System.out.println("     per call.");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.validateParameters();
        RequestResultPair rsp = jec2.modifyNetworkInterfaceAttribute(this.networkInterfaceId, this.attribute);
        if (((Boolean)rsp.getResponse()).booleanValue()) {
            out.outputNetworkInterfaceAttribute(System.out, this.networkInterfaceId, this.attribute);
        }
        out.printRequestId(System.out, (RequestResult)rsp);
        return (Boolean)rsp.getResponse();
    }

    protected void validateParameters() {
        this.assertNonOptionSet("NETWORKINTERFACE");
        this.networkInterfaceId = this.getNonOptions()[0];
        this.assertOnlyOneOptionSet(new String[]{"description", "attachment", "source-dest-check", "group-id"});
        this.warnIfTooManyNonOptions();
        if (this.isOptionSet("source-dest-check")) {
            this.attribute = ModifyNetworkInterfaceAttributeDescription.createSourceDestCheck((boolean)this.getBooleanOption("source-dest-check"));
        } else if (this.isOptionSet("group-id")) {
            String[] groupIds = this.getOptionValues("group-id");
            this.attribute = ModifyNetworkInterfaceAttributeDescription.createGroup(Arrays.asList(groupIds));
        } else if (this.isOptionSet("attachment")) {
            this.assertOptionSet("delete-on-termination");
            this.attribute = ModifyNetworkInterfaceAttributeDescription.createAttachment((String)this.getOptionValue("attachment"), (boolean)this.getBooleanOption("delete-on-termination"));
        } else if (this.isOptionSet("description")) {
            this.attribute = ModifyNetworkInterfaceAttributeDescription.createDescription((String)this.getOptionValue("description"));
        }
    }

    public static void main(String[] args) {
        new ModifyNetworkInterfaceAttribute(args).invoke();
    }
}

