/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.signature;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.algorithms.SignatureAlgorithm;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.test.signature.XPointerResourceResolver;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ECDSASignatureTest
extends TestCase {
    private static Log log = LogFactory.getLog((String)(class$org$apache$xml$security$test$signature$ECDSASignatureTest == null ? (class$org$apache$xml$security$test$signature$ECDSASignatureTest = ECDSASignatureTest.class$("org.apache.xml.security.test.signature.ECDSASignatureTest")) : class$org$apache$xml$security$test$signature$ECDSASignatureTest).getName());
    private static final String BASEDIR = System.getProperty("basedir");
    private static final String SEP = System.getProperty("file.separator");
    private static final String ECDSA_JKS = "data/org/apache/xml/security/samples/input/ecdsa.jks";
    private static final String ECDSA_JKS_PASSWORD = "security";
    private KeyStore keyStore;
    private DocumentBuilder db;
    static /* synthetic */ Class class$org$apache$xml$security$test$signature$ECDSASignatureTest;
    static /* synthetic */ Class class$org$apache$xml$security$test$signature$IndexedDocument;

    private File makeDataFile(String string) {
        if (BASEDIR != null && !"".equals(BASEDIR)) {
            return new File(BASEDIR + SEP + string);
        }
        return new File(string);
    }

    public static Test suite() {
        return new TestSuite(class$org$apache$xml$security$test$signature$ECDSASignatureTest == null ? (class$org$apache$xml$security$test$signature$ECDSASignatureTest = ECDSASignatureTest.class$("org.apache.xml.security.test.signature.ECDSASignatureTest")) : class$org$apache$xml$security$test$signature$ECDSASignatureTest);
    }

    public ECDSASignatureTest(String string) {
        super(string);
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"-noloading", (class$org$apache$xml$security$test$signature$ECDSASignatureTest == null ? (class$org$apache$xml$security$test$signature$ECDSASignatureTest = ECDSASignatureTest.class$("org.apache.xml.security.test.signature.ECDSASignatureTest")) : class$org$apache$xml$security$test$signature$ECDSASignatureTest).getName()};
        TestRunner.main((String[])stringArray2);
    }

    protected void setUp() throws Exception {
        Object object;
        Object object2;
        if (Security.getProvider("BC") == null) {
            object2 = null;
            try {
                object = Class.forName("org.bouncycastle.jce.provider.BouncyCastleProvider");
                object2 = ((Class)object).getConstructor(new Class[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (object2 == null) {
                return;
            }
            Security.addProvider((Provider)((Constructor)object2).newInstance(new Object[0]));
        }
        object2 = DocumentBuilderFactory.newInstance();
        ((DocumentBuilderFactory)object2).setNamespaceAware(true);
        log.info((Object)("dbf.isIgnoringComments()=" + ((DocumentBuilderFactory)object2).isIgnoringComments()));
        log.info((Object)("dbf.isIgnoringElementContentWhitespace()=" + ((DocumentBuilderFactory)object2).isIgnoringElementContentWhitespace()));
        object = "http://apache.org/xml/properties/dom/document-class-name";
        ((DocumentBuilderFactory)object2).setAttribute((String)object, (class$org$apache$xml$security$test$signature$IndexedDocument == null ? (class$org$apache$xml$security$test$signature$IndexedDocument = ECDSASignatureTest.class$("org.apache.xml.security.test.signature.IndexedDocument")) : class$org$apache$xml$security$test$signature$IndexedDocument).getName());
        this.db = ((DocumentBuilderFactory)object2).newDocumentBuilder();
        Init.init();
    }

    public void testOne() throws Exception {
        if (Security.getProvider("BC") == null) {
            return;
        }
        this.keyStore = KeyStore.getInstance("JKS");
        this.keyStore.load(new FileInputStream(ECDSA_JKS), ECDSA_JKS_PASSWORD.toCharArray());
        this.doVerify(this.doSign());
        this.doVerify(this.doSign());
    }

    public void testTwo() throws Exception {
        if (Security.getProvider("BC") == null) {
            return;
        }
        File file = this.makeDataFile("data/org/apache/xml/security/samples/input/ecdsaSignature.xml");
        FileInputStream fileInputStream = new FileInputStream(file);
        this.doVerify(fileInputStream);
    }

    public void testThree() throws Exception {
        if (Security.getProvider("BC") == null) {
            return;
        }
        File file = this.makeDataFile("data/at/buergerkarte/testresp.xml");
        FileInputStream fileInputStream = new FileInputStream(file);
        this.doVerify(fileInputStream);
    }

    private byte[] doSign() throws Exception {
        PrivateKey privateKey = (PrivateKey)this.keyStore.getKey("ECDSA", ECDSA_JKS_PASSWORD.toCharArray());
        Document document = this.db.newDocument();
        document.appendChild(document.createComment(" Comment before "));
        Element element = document.createElementNS("", "RootElement");
        document.appendChild(element);
        element.appendChild(document.createTextNode("Some simple text\n"));
        Element element2 = XMLUtils.createElementInSignatureSpace((Document)document, (String)"CanonicalizationMethod");
        element2.setAttributeNS(null, "Algorithm", "http://www.w3.org/2001/10/xml-exc-c14n#");
        SignatureAlgorithm signatureAlgorithm = new SignatureAlgorithm(document, "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1");
        XMLSignature xMLSignature = new XMLSignature(document, null, signatureAlgorithm.getElement(), element2);
        element.appendChild(xMLSignature.getElement());
        document.appendChild(document.createComment(" Comment after "));
        Transforms transforms = new Transforms(document);
        transforms.addTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
        transforms.addTransform("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
        xMLSignature.addDocument("", transforms, "http://www.w3.org/2000/09/xmldsig#sha1");
        X509Certificate x509Certificate = (X509Certificate)this.keyStore.getCertificate("ECDSA");
        xMLSignature.addKeyInfo(x509Certificate);
        xMLSignature.sign((Key)privateKey);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XMLUtils.outputDOMc14nWithComments((Node)document, (OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    private void doVerify(byte[] byArray) throws Exception {
        this.doVerify(new ByteArrayInputStream(byArray));
    }

    private void doVerify(InputStream inputStream) throws Exception {
        Document document = this.db.parse(inputStream);
        Element element = XMLUtils.createDSctx((Document)document, (String)"ds", (String)"http://www.w3.org/2000/09/xmldsig#");
        Element element2 = (Element)XPathAPI.selectSingleNode((Node)document, (String)"//ds:Signature[1]", (Node)element);
        XMLSignature xMLSignature = new XMLSignature(element2, "");
        xMLSignature.addResourceResolver((ResourceResolverSpi)new XPointerResourceResolver(element2));
        KeyInfo keyInfo = xMLSignature.getKeyInfo();
        if (keyInfo == null) {
            throw new RuntimeException("No keyinfo");
        }
        X509Certificate x509Certificate = xMLSignature.getKeyInfo().getX509Certificate();
        if (x509Certificate == null) {
            throw new RuntimeException("No certificate");
        }
        ECDSASignatureTest.assertTrue((boolean)xMLSignature.checkSignatureValue(x509Certificate));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

