/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.writer.util;

import com.android.tools.smali.dexlib2.base.BaseTryBlock;
import com.android.tools.smali.dexlib2.iface.ExceptionHandler;
import com.android.tools.smali.dexlib2.iface.TryBlock;
import com.android.tools.smali.util.ExceptionWithContext;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class TryListBuilder<EH extends ExceptionHandler> {
    private final MutableTryBlock<EH> listStart = new MutableTryBlock(0, 0);
    private final MutableTryBlock<EH> listEnd = new MutableTryBlock(0, 0);

    public TryListBuilder() {
        this.listStart.next = this.listEnd;
        this.listEnd.prev = this.listStart;
    }

    public static <EH extends ExceptionHandler> List<TryBlock<EH>> massageTryBlocks(List<? extends TryBlock<? extends EH>> tryBlocks) {
        TryListBuilder<ExceptionHandler> tlb = new TryListBuilder<ExceptionHandler>();
        for (TryBlock<EH> tryBlock : tryBlocks) {
            int startAddress = tryBlock.getStartCodeAddress();
            int endAddress = startAddress + tryBlock.getCodeUnitCount();
            for (ExceptionHandler exceptionHandler : tryBlock.getExceptionHandlers()) {
                tlb.addHandler(startAddress, endAddress, exceptionHandler);
            }
        }
        return tlb.getTryBlocks();
    }

    private TryBounds<EH> getBoundingRanges(int startAddress, int endAddress) {
        int currentEndAddress;
        int currentStartAddress;
        MutableTryBlock startBlock = null;
        MutableTryBlock tryBlock = this.listStart.next;
        while (tryBlock != this.listEnd) {
            currentStartAddress = tryBlock.startCodeAddress;
            currentEndAddress = tryBlock.endCodeAddress;
            if (startAddress == currentStartAddress) {
                startBlock = tryBlock;
                break;
            }
            if (startAddress > currentStartAddress && startAddress < currentEndAddress) {
                startBlock = tryBlock.split(startAddress);
                break;
            }
            if (startAddress < currentStartAddress) {
                if (endAddress <= currentStartAddress) {
                    startBlock = new MutableTryBlock(startAddress, endAddress);
                    tryBlock.prepend(startBlock);
                    return new TryBounds(startBlock, startBlock);
                }
                startBlock = new MutableTryBlock(startAddress, currentStartAddress);
                tryBlock.prepend(startBlock);
                break;
            }
            tryBlock = tryBlock.next;
        }
        if (startBlock == null) {
            startBlock = new MutableTryBlock(startAddress, endAddress);
            this.listEnd.prepend(startBlock);
            return new TryBounds(startBlock, startBlock);
        }
        tryBlock = startBlock;
        while (tryBlock != this.listEnd) {
            currentStartAddress = tryBlock.startCodeAddress;
            currentEndAddress = tryBlock.endCodeAddress;
            if (endAddress == currentEndAddress) {
                return new TryBounds(startBlock, tryBlock);
            }
            if (endAddress > currentStartAddress && endAddress < currentEndAddress) {
                tryBlock.split(endAddress);
                return new TryBounds(startBlock, tryBlock);
            }
            if (endAddress <= currentStartAddress) {
                MutableTryBlock endBlock = new MutableTryBlock(tryBlock.prev.endCodeAddress, endAddress);
                tryBlock.prepend(endBlock);
                return new TryBounds(startBlock, endBlock);
            }
            tryBlock = tryBlock.next;
        }
        MutableTryBlock endBlock = new MutableTryBlock(this.listEnd.prev.endCodeAddress, endAddress);
        this.listEnd.prepend(endBlock);
        return new TryBounds(startBlock, endBlock);
    }

    public void addHandler(int startAddress, int endAddress, EH handler) {
        TryBounds<EH> bounds = this.getBoundingRanges(startAddress, endAddress);
        MutableTryBlock<EH> startBlock = bounds.start;
        MutableTryBlock endBlock = bounds.end;
        int previousEnd = startAddress;
        MutableTryBlock<EH> tryBlock = startBlock;
        do {
            if (tryBlock.startCodeAddress > previousEnd) {
                MutableTryBlock newBlock = new MutableTryBlock(previousEnd, tryBlock.startCodeAddress);
                tryBlock.prepend(newBlock);
                tryBlock = newBlock;
            }
            tryBlock.addHandler(handler);
            previousEnd = tryBlock.endCodeAddress;
            tryBlock = tryBlock.next;
        } while (tryBlock.prev != endBlock);
    }

    public List<TryBlock<EH>> getTryBlocks() {
        return Lists.newArrayList(new Iterator<TryBlock<EH>>(){
            private MutableTryBlock<EH> next;
            {
                this.next = TryListBuilder.this.listStart;
                this.next = this.readNextItem();
            }

            protected MutableTryBlock<EH> readNextItem() {
                MutableTryBlock ret = this.next.next;
                if (ret == TryListBuilder.this.listEnd) {
                    return null;
                }
                while (ret.next != TryListBuilder.this.listEnd && ret.endCodeAddress == ret.next.startCodeAddress && ret.getExceptionHandlers().equals(ret.next.getExceptionHandlers())) {
                    ret.mergeNext();
                }
                return ret;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public TryBlock<EH> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                MutableTryBlock ret = this.next;
                this.next = this.readNextItem();
                return ret;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        });
    }

    private static class MutableTryBlock<EH extends ExceptionHandler>
    extends BaseTryBlock<EH> {
        public MutableTryBlock<EH> prev = null;
        public MutableTryBlock<EH> next = null;
        public int startCodeAddress;
        public int endCodeAddress;
        public List<EH> exceptionHandlers = Lists.newArrayList();

        public MutableTryBlock(int startCodeAddress, int endCodeAddress) {
            this.startCodeAddress = startCodeAddress;
            this.endCodeAddress = endCodeAddress;
        }

        public MutableTryBlock(int startCodeAddress, int endCodeAddress, List<EH> exceptionHandlers) {
            this.startCodeAddress = startCodeAddress;
            this.endCodeAddress = endCodeAddress;
            this.exceptionHandlers = Lists.newArrayList(exceptionHandlers);
        }

        @Override
        public int getStartCodeAddress() {
            return this.startCodeAddress;
        }

        @Override
        public int getCodeUnitCount() {
            return this.endCodeAddress - this.startCodeAddress;
        }

        @Override
        public List<EH> getExceptionHandlers() {
            return this.exceptionHandlers;
        }

        public MutableTryBlock<EH> split(int splitAddress) {
            MutableTryBlock<EH> newTryBlock = new MutableTryBlock<EH>(splitAddress, this.endCodeAddress, this.exceptionHandlers);
            this.endCodeAddress = splitAddress;
            this.append(newTryBlock);
            return newTryBlock;
        }

        public void delete() {
            this.next.prev = this.prev;
            this.prev.next = this.next;
        }

        public void mergeNext() {
            this.endCodeAddress = this.next.endCodeAddress;
            this.next.delete();
        }

        public void append(MutableTryBlock<EH> tryBlock) {
            this.next.prev = tryBlock;
            tryBlock.next = this.next;
            tryBlock.prev = this;
            this.next = tryBlock;
        }

        public void prepend(MutableTryBlock<EH> tryBlock) {
            this.prev.next = tryBlock;
            tryBlock.prev = this.prev;
            tryBlock.next = this;
            this.prev = tryBlock;
        }

        public void addHandler(EH handler) {
            for (ExceptionHandler existingHandler : this.exceptionHandlers) {
                String existingType = existingHandler.getExceptionType();
                String newType = handler.getExceptionType();
                if (existingType == null) {
                    if (newType != null) continue;
                    if (existingHandler.getHandlerCodeAddress() != handler.getHandlerCodeAddress()) {
                        throw new InvalidTryException("Multiple overlapping catch all handlers with different handlers", new Object[0]);
                    }
                    return;
                }
                if (!existingType.equals(newType)) continue;
                return;
            }
            this.exceptionHandlers.add(handler);
        }
    }

    public static class InvalidTryException
    extends ExceptionWithContext {
        public InvalidTryException(String message, Object ... formatArgs) {
            super(message, formatArgs);
        }
    }

    private static class TryBounds<EH extends ExceptionHandler> {
        public final MutableTryBlock<EH> start;
        public final MutableTryBlock<EH> end;

        public TryBounds(MutableTryBlock<EH> start, MutableTryBlock<EH> end) {
            this.start = start;
            this.end = end;
        }
    }
}

