/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import MCview.PDBChain;
import jalview.ColourScheme;
import jalview.DrawableSequence;
import jalview.ResidueProperties;
import jalview.SequenceGroup;
import java.awt.Color;
import java.util.Hashtable;

public class ResidueColourScheme
implements ColourScheme {
    Color[] colors;
    int colourThreshold;
    Hashtable[] cons;

    public ResidueColourScheme() {
    }

    public ResidueColourScheme(Color[] colorArray, int n) {
        this(colorArray, n, null);
    }

    public ResidueColourScheme(Color[] colorArray, int n, Hashtable[] hashtableArray) {
        this.colors = colorArray;
        this.colourThreshold = n;
        this.cons = hashtableArray;
    }

    public Color findColour(DrawableSequence drawableSequence, String string, int n) {
        return this.colors[(Integer)ResidueProperties.aaHash.get(string)];
    }

    public void setColours(DrawableSequence drawableSequence, int n) {
        Color color = Color.white;
        String string = drawableSequence.getSequence().substring(n, n + 1);
        try {
            if (this.colourThreshold > 0 && this.cons != null) {
                if (this.aboveThreshold(drawableSequence, n, this.colourThreshold)) {
                    color = this.findColour(drawableSequence, string, n);
                }
            } else {
                color = this.findColour(drawableSequence, string, n);
            }
            drawableSequence.setResidueBoxColour(n, color);
            return;
        }
        catch (Exception exception) {
            drawableSequence.setResidueBoxColour(n, Color.white);
            return;
        }
    }

    public void setColours(DrawableSequence drawableSequence) {
        if (drawableSequence.pdb != null) {
            ((PDBChain)drawableSequence.pdb.chains.elementAt(drawableSequence.maxchain)).colourBySequence();
        }
        int n = 0;
        while (n < drawableSequence.sequence.length()) {
            this.setColours(drawableSequence, n);
            ++n;
        }
    }

    public void setColours(SequenceGroup sequenceGroup) {
        int n = 0;
        while (n < sequenceGroup.sequences.size()) {
            DrawableSequence drawableSequence = (DrawableSequence)sequenceGroup.sequences.elementAt(n);
            int n2 = 0;
            while (n2 < drawableSequence.getSequence().length()) {
                this.setColours(drawableSequence, n2);
                ++n2;
            }
            if (drawableSequence.pdb != null) {
                ((PDBChain)drawableSequence.pdb.chains.elementAt(drawableSequence.maxchain)).colourBySequence();
            }
            ++n;
        }
    }

    public boolean aboveThreshold(DrawableSequence drawableSequence, int n, int n2) {
        String string = drawableSequence.getSequence().substring(n, n + 1);
        if (this.cons != null && n < this.cons.length) {
            String cfr_ignored_0 = (String)this.cons[n].get("max");
            double d = 0.0;
            if (this.cons[n].contains(string)) {
                d = ((Double)this.cons[n].get(string)).floatValue();
                if (!string.equals("-") && !string.equals(".") && !string.equals(" ") && d >= (double)n2) {
                    return true;
                }
            }
        }
        return false;
    }
}

