/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.application.snapshot;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.util.Set;
import javax.swing.ImageIcon;
import org.graalvm.visualvm.application.snapshot.ApplicationSnapshotConfigurator;
import org.graalvm.visualvm.application.snapshot.ApplicationSnapshotProvider;
import org.graalvm.visualvm.application.snapshot.ApplicationSnapshotsSupport;
import org.graalvm.visualvm.core.snapshot.SnapshotsContainer;
import org.graalvm.visualvm.core.ui.actions.SingleDataSourceAction;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

class AddApplicationSnapshotAction
extends SingleDataSourceAction<SnapshotsContainer> {
    private static final String ICON_PATH = "org/graalvm/visualvm/application/resources/addApplicationSnapshot.png";
    private static final Image ICON = ImageUtilities.loadImage((String)"org/graalvm/visualvm/application/resources/addApplicationSnapshot.png");
    private boolean tracksSelection = false;
    private static AddApplicationSnapshotAction alwaysEnabled;
    private static AddApplicationSnapshotAction selectionAware;

    static synchronized AddApplicationSnapshotAction alwaysEnabled() {
        if (alwaysEnabled == null) {
            alwaysEnabled = new AddApplicationSnapshotAction();
            alwaysEnabled.putValue("SmallIcon", new ImageIcon(ICON));
            alwaysEnabled.putValue("iconBase", ICON_PATH);
        }
        return alwaysEnabled;
    }

    static synchronized AddApplicationSnapshotAction selectionAware() {
        if (selectionAware == null) {
            selectionAware = new AddApplicationSnapshotAction();
            AddApplicationSnapshotAction.selectionAware.tracksSelection = true;
        }
        return selectionAware;
    }

    protected void actionPerformed(SnapshotsContainer snapshotsContainer, ActionEvent actionEvent) {
        ApplicationSnapshotConfigurator newSnapshotConfiguration = ApplicationSnapshotConfigurator.defineSnapshot();
        if (newSnapshotConfiguration != null) {
            ApplicationSnapshotProvider provider = ApplicationSnapshotsSupport.getInstance().getSnapshotProvider();
            provider.addSnapshotArchive(newSnapshotConfiguration.getSnapshotFile(), newSnapshotConfiguration.deleteSourceFile());
        }
    }

    protected boolean isEnabled(SnapshotsContainer snapshotsContainer) {
        return true;
    }

    protected void updateState(Set<SnapshotsContainer> snapshotsContainerSet) {
        if (this.tracksSelection) {
            super.updateState(snapshotsContainerSet);
        }
    }

    private AddApplicationSnapshotAction() {
        super(SnapshotsContainer.class);
        this.putValue("Name", NbBundle.getMessage(AddApplicationSnapshotAction.class, (String)"LBL_Add_Application_Snapshot"));
        this.putValue("ShortDescription", NbBundle.getMessage(AddApplicationSnapshotAction.class, (String)"ToolTip_Add_Application_Snapshot"));
    }
}

