/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.jdi;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.VirtualMachine;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import sun.jvm.hotspot.jdi.BaseLineInfo;
import sun.jvm.hotspot.jdi.LineInfo;
import sun.jvm.hotspot.jdi.LocalVariableImpl;
import sun.jvm.hotspot.jdi.LocationImpl;
import sun.jvm.hotspot.jdi.MethodImpl;
import sun.jvm.hotspot.jdi.ReferenceTypeImpl;
import sun.jvm.hotspot.jdi.SDE;
import sun.jvm.hotspot.jdi.StratumLineInfo;
import sun.jvm.hotspot.oops.LineNumberTableElement;
import sun.jvm.hotspot.oops.LocalVariableTableElement;
import sun.jvm.hotspot.oops.Method;

public class ConcreteMethodImpl
extends MethodImpl {
    private SoftReference softBaseLocationXRefsRef;
    private SoftReference softOtherLocationXRefsRef;
    private SoftReference variablesRef = null;
    private int firstIndex = -1;
    private int lastIndex = -1;
    private Location location;
    private SoftReference bytecodesRef = null;

    ConcreteMethodImpl(VirtualMachine vm, ReferenceTypeImpl declaringType, Method saMethod) {
        super(vm, declaringType, saMethod);
    }

    @Override
    int argSlotCount() throws AbsentInformationException {
        return (int)this.saMethod.getSizeOfParameters();
    }

    private SoftLocationXRefs getLocations(SDE.Stratum stratum) {
        SoftLocationXRefs info;
        if (stratum.isJava()) {
            return this.getBaseLocations();
        }
        String stratumID = stratum.id();
        SoftLocationXRefs softLocationXRefs = info = this.softOtherLocationXRefsRef == null ? null : (SoftLocationXRefs)this.softOtherLocationXRefsRef.get();
        if (info != null && info.stratumID.equals(stratumID)) {
            return info;
        }
        ArrayList<LocationImpl> lineLocations = new ArrayList<LocationImpl>();
        HashMap<Integer, ArrayList<LocationImpl>> lineMapper = new HashMap<Integer, ArrayList<LocationImpl>>();
        int lowestLine = -1;
        int highestLine = -1;
        SDE.LineStratum lastLineStratum = null;
        SDE.Stratum baseStratum = this.declaringType.stratum("Java");
        for (LocationImpl loc : this.getBaseLocations().lineLocations) {
            int lineNumber;
            int baseLineNumber = loc.lineNumber(baseStratum);
            SDE.LineStratum lineStratum = stratum.lineStratum(this.declaringType, baseLineNumber);
            if (lineStratum == null || (lineNumber = lineStratum.lineNumber()) == -1 || lineStratum.equals(lastLineStratum)) continue;
            lastLineStratum = lineStratum;
            if (lineNumber > highestLine) {
                highestLine = lineNumber;
            }
            if (lineNumber < lowestLine || lowestLine == -1) {
                lowestLine = lineNumber;
            }
            loc.addStratumLineInfo(new StratumLineInfo(stratumID, lineNumber, lineStratum.sourceName(), lineStratum.sourcePath()));
            lineLocations.add(loc);
            Integer key = new Integer(lineNumber);
            ArrayList<LocationImpl> mappedLocs = (ArrayList<LocationImpl>)lineMapper.get(key);
            if (mappedLocs == null) {
                mappedLocs = new ArrayList<LocationImpl>(1);
                lineMapper.put(key, mappedLocs);
            }
            mappedLocs.add(loc);
        }
        info = new SoftLocationXRefs(stratumID, lineMapper, lineLocations, lowestLine, highestLine);
        this.softOtherLocationXRefsRef = new SoftReference<SoftLocationXRefs>(info);
        return info;
    }

    private SoftLocationXRefs getBaseLocations() {
        int count;
        SoftLocationXRefs info;
        SoftLocationXRefs softLocationXRefs = info = this.softBaseLocationXRefsRef == null ? null : (SoftLocationXRefs)this.softBaseLocationXRefsRef.get();
        if (info != null) {
            return info;
        }
        byte[] codeBuf = this.bytecodes();
        this.firstIndex = 0;
        this.lastIndex = codeBuf.length - 1;
        this.location = new LocationImpl(this.virtualMachine(), this, 0L);
        boolean hasLineInfo = this.saMethod.hasLineNumberTable();
        LineNumberTableElement[] lntab = null;
        if (hasLineInfo) {
            lntab = this.saMethod.getLineNumberTable();
            count = lntab.length;
        } else {
            count = 0;
        }
        ArrayList<LocationImpl> lineLocations = new ArrayList<LocationImpl>(count);
        HashMap<Integer, ArrayList<LocationImpl>> lineMapper = new HashMap<Integer, ArrayList<LocationImpl>>();
        int lowestLine = -1;
        int highestLine = -1;
        for (int i = 0; i < count; ++i) {
            long bci = lntab[i].getStartBCI();
            int lineNumber = lntab[i].getLineNumber();
            if (i + 1 != count && bci == (long)lntab[i + 1].getStartBCI()) continue;
            if (lineNumber > highestLine) {
                highestLine = lineNumber;
            }
            if (lineNumber < lowestLine || lowestLine == -1) {
                lowestLine = lineNumber;
            }
            LocationImpl loc = new LocationImpl(this.virtualMachine(), this, bci);
            loc.addBaseLineInfo(new BaseLineInfo(lineNumber, this.declaringType));
            lineLocations.add(loc);
            Integer key = new Integer(lineNumber);
            ArrayList<LocationImpl> mappedLocs = (ArrayList<LocationImpl>)lineMapper.get(key);
            if (mappedLocs == null) {
                mappedLocs = new ArrayList<LocationImpl>(1);
                lineMapper.put(key, mappedLocs);
            }
            mappedLocs.add(loc);
        }
        info = new SoftLocationXRefs("Java", lineMapper, lineLocations, lowestLine, highestLine);
        this.softBaseLocationXRefsRef = new SoftReference<SoftLocationXRefs>(info);
        return info;
    }

    List sourceNameFilter(List list, SDE.Stratum stratum, String sourceName) throws AbsentInformationException {
        if (sourceName == null) {
            return list;
        }
        ArrayList<LocationImpl> locs = new ArrayList<LocationImpl>();
        for (LocationImpl loc : list) {
            if (!loc.sourceName(stratum).equals(sourceName)) continue;
            locs.add(loc);
        }
        return locs;
    }

    @Override
    public List allLineLocations(SDE.Stratum stratum, String sourceName) throws AbsentInformationException {
        List lineLocations = this.getLocations((SDE.Stratum)stratum).lineLocations;
        if (lineLocations.size() == 0) {
            throw new AbsentInformationException();
        }
        return Collections.unmodifiableList(this.sourceNameFilter(lineLocations, stratum, sourceName));
    }

    @Override
    public List locationsOfLine(SDE.Stratum stratum, String sourceName, int lineNumber) throws AbsentInformationException {
        SoftLocationXRefs info = this.getLocations(stratum);
        if (info.lineLocations.size() == 0) {
            throw new AbsentInformationException();
        }
        ArrayList list = (ArrayList)info.lineMapper.get(new Integer(lineNumber));
        if (list == null) {
            list = new ArrayList(0);
        }
        return Collections.unmodifiableList(this.sourceNameFilter(list, stratum, sourceName));
    }

    @Override
    LineInfo codeIndexToLineInfo(SDE.Stratum stratum, long codeIndex) {
        LocationImpl current;
        if (this.firstIndex == -1) {
            this.getBaseLocations();
        }
        if (codeIndex < (long)this.firstIndex || codeIndex > (long)this.lastIndex) {
            throw new InternalError("Location with invalid code index");
        }
        List lineLocations = this.getLocations((SDE.Stratum)stratum).lineLocations;
        if (lineLocations.size() == 0) {
            return super.codeIndexToLineInfo(stratum, codeIndex);
        }
        Iterator iter = lineLocations.iterator();
        LocationImpl bestMatch = (LocationImpl)iter.next();
        while (iter.hasNext() && (current = (LocationImpl)iter.next()).codeIndex() <= codeIndex) {
            bestMatch = current;
        }
        return bestMatch.getLineInfo(stratum);
    }

    @Override
    public Location locationOfCodeIndex(long codeIndex) {
        if (this.firstIndex == -1) {
            this.getBaseLocations();
        }
        if (codeIndex < (long)this.firstIndex || codeIndex > (long)this.lastIndex) {
            return null;
        }
        return new LocationImpl(this.virtualMachine(), this, codeIndex);
    }

    public List variables() throws AbsentInformationException {
        return this.getVariables();
    }

    public List variablesByName(String name) throws AbsentInformationException {
        List variables = this.getVariables();
        ArrayList<LocalVariable> retList = new ArrayList<LocalVariable>(2);
        for (LocalVariable variable : variables) {
            if (!variable.name().equals(name)) continue;
            retList.add(variable);
        }
        return retList;
    }

    public List arguments() throws AbsentInformationException {
        if (this.argumentTypeNames().size() == 0) {
            return new ArrayList(0);
        }
        List variables = this.getVariables();
        ArrayList<LocalVariable> retList = new ArrayList<LocalVariable>(variables.size());
        for (LocalVariable variable : variables) {
            if (!variable.isArgument()) continue;
            retList.add(variable);
        }
        return retList;
    }

    @Override
    public byte[] bytecodes() {
        byte[] bytecodes;
        byte[] byArray = bytecodes = this.bytecodesRef == null ? null : (byte[])this.bytecodesRef.get();
        if (bytecodes == null) {
            bytecodes = this.saMethod.getByteCode();
            this.bytecodesRef = new SoftReference<byte[]>(bytecodes);
        }
        return (byte[])bytecodes.clone();
    }

    @Override
    public Location location() {
        if (this.location == null) {
            this.getBaseLocations();
        }
        return this.location;
    }

    private List getVariables() throws AbsentInformationException {
        List<LocalVariableImpl> variables;
        List<LocalVariableImpl> list = variables = this.variablesRef == null ? null : (List<LocalVariableImpl>)this.variablesRef.get();
        if (variables != null) {
            return variables;
        }
        if (this.saMethod.getMaxLocals() == 0L) {
            variables = Collections.unmodifiableList(new ArrayList(0));
            this.variablesRef = new SoftReference(variables);
            return variables;
        }
        if (!this.saMethod.hasLocalVariableTable()) {
            throw new AbsentInformationException();
        }
        LocalVariableTableElement[] locals = this.saMethod.getLocalVariableTable();
        int localCount = locals.length;
        variables = new ArrayList(localCount);
        for (int ii = 0; ii < localCount; ++ii) {
            boolean isInternalName;
            String name = this.saMethod.getConstants().getSymbolAt(locals[ii].getNameCPIndex()).asString();
            boolean bl = isInternalName = name.startsWith("this") && (name.length() == 4 || name.charAt(4) == '$' || !Character.isJavaIdentifierPart(name.charAt(4)));
            if (isInternalName) continue;
            int slot = locals[ii].getSlot();
            long codeIndex = locals[ii].getStartBCI();
            int length = locals[ii].getLength();
            LocationImpl scopeStart = new LocationImpl(this.virtualMachine(), this, codeIndex);
            LocationImpl scopeEnd = new LocationImpl(this.virtualMachine(), this, codeIndex + (long)length - 1L);
            String signature = this.saMethod.getConstants().getSymbolAt(locals[ii].getDescriptorCPIndex()).asString();
            int genericSigIndex = locals[ii].getSignatureCPIndex();
            String genericSignature = null;
            if (genericSigIndex != 0) {
                genericSignature = this.saMethod.getConstants().getSymbolAt(genericSigIndex).asString();
            }
            LocalVariableImpl variable = new LocalVariableImpl(this.virtualMachine(), this, slot, scopeStart, scopeEnd, name, signature, genericSignature);
            variables.add(variable);
        }
        variables = Collections.unmodifiableList(variables);
        this.variablesRef = new SoftReference(variables);
        return variables;
    }

    private static class SoftLocationXRefs {
        final String stratumID;
        final Map lineMapper;
        final List lineLocations;
        final int lowestLine;
        final int highestLine;

        SoftLocationXRefs(String stratumID, Map lineMapper, List lineLocations, int lowestLine, int highestLine) {
            this.stratumID = stratumID;
            this.lineMapper = Collections.unmodifiableMap(lineMapper);
            this.lineLocations = Collections.unmodifiableList(lineLocations);
            this.lowestLine = lowestLine;
            this.highestLine = highestLine;
        }
    }
}

