/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler;

import de.rub.nds.tlsattacker.core.protocol.handler.ClientKeyExchangeHandler;
import de.rub.nds.tlsattacker.core.protocol.message.DHClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.DHClientKeyExchangeParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.DHClientKeyExchangePreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.DHClientKeyExchangeSerializer;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import java.math.BigInteger;

public class DHClientKeyExchangeHandler
extends ClientKeyExchangeHandler<DHClientKeyExchangeMessage> {
    public DHClientKeyExchangeHandler(TlsContext tlsContext) {
        super(tlsContext);
    }

    @Override
    public DHClientKeyExchangeParser getParser(byte[] message, int pointer) {
        return new DHClientKeyExchangeParser(pointer, message, this.tlsContext.getChooser().getLastRecordVersion(), this.tlsContext.getConfig());
    }

    public DHClientKeyExchangePreparator getPreparator(DHClientKeyExchangeMessage message) {
        return new DHClientKeyExchangePreparator<DHClientKeyExchangeMessage>(this.tlsContext.getChooser(), message);
    }

    public DHClientKeyExchangeSerializer getSerializer(DHClientKeyExchangeMessage message) {
        return new DHClientKeyExchangeSerializer<DHClientKeyExchangeMessage>(message, this.tlsContext.getChooser().getSelectedProtocolVersion());
    }

    @Override
    public void adjustTLSContext(DHClientKeyExchangeMessage message) {
        this.adjustPremasterSecret(message);
        this.adjustMasterSecret(message);
        this.adjustClientPublicKey(message);
        this.setRecordCipher();
        this.spawnNewSession();
    }

    private void adjustClientPublicKey(DHClientKeyExchangeMessage message) {
        this.tlsContext.setClientDhPublicKey(new BigInteger((byte[])message.getPublicKey().getValue()));
    }
}

