/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.statistics;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.remote.CredentialsType;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.extensions.ModuleExtKt;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.conda.CondaEnvSdkFlavor;
import com.jetbrains.python.sdk.pipenv.PipenvKt;
import com.jetbrains.python.sdk.poetry.PoetryKt;
import com.jetbrains.python.sdk.uv.UvExtKt;
import com.jetbrains.python.statistics.InterpreterCreationMode;
import com.jetbrains.python.statistics.InterpreterTarget;
import com.jetbrains.python.statistics.InterpreterType;
import com.jetbrains.python.target.PyTargetAwareAdditionalData;
import com.jetbrains.python.venvReader.VirtualEnvReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000v\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u000b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u00072\u0006\u0010\r\u001a\u00020\u0002\u001a\u0018\u0010\u000b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u00072\u0006\u0010\u000e\u001a\u00020\b\u001a9\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u001a\u0010\u0015\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00160\u0001\"\u0006\u0012\u0002\b\u00030\u0016H\u0007\u00a2\u0006\u0002\u0010\u0017\"\u001b\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\"\u001b\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\"\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0011\u0010\u001c\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001b\"\u0011\u0010\u001e\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001b\"\u0011\u0010 \u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001b\"\u0011\u0010\"\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001b\"\u0014\u0010$\u001a\u00020%X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'\"\u0018\u0010(\u001a\u00020\u0014*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*\"\u0017\u0010+\u001a\u00020,*\u0004\u0018\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010.\"\u0015\u0010/\u001a\u000200*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b1\u00102\"\u0015\u00103\u001a\u000204*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b5\u00106\"\u0018\u0010/\u001a\u000200*\u0002078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00108\"\u0018\u0010/\u001a\u000200*\u0002098BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u0010:\u00a8\u0006;"}, d2={"modules", "", "Lcom/intellij/openapi/module/Module;", "Lcom/intellij/openapi/project/Project;", "getModules", "(Lcom/intellij/openapi/project/Project;)[Lcom/intellij/openapi/module/Module;", "sdks", "", "Lcom/intellij/openapi/projectRoots/Sdk;", "getSdks", "(Lcom/intellij/openapi/project/Project;)Ljava/util/List;", "getPythonSpecificInfo", "Lcom/intellij/internal/statistic/eventLog/events/EventPair;", "module", "sdk", "registerPythonSpecificEvent", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "group", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "eventId", "", "extraFields", "Lcom/intellij/internal/statistic/eventLog/events/EventField;", "(Lcom/intellij/internal/statistic/eventLog/EventLogGroup;Ljava/lang/String;[Lcom/intellij/internal/statistic/eventLog/events/EventField;)Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "PYTHON_VERSION", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "getPYTHON_VERSION", "()Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "PYTHON_IMPLEMENTATION", "getPYTHON_IMPLEMENTATION", "EXECUTION_TYPE", "getEXECUTION_TYPE", "INTERPRETER_TYPE", "getINTERPRETER_TYPE", "INTERPRETER_CREATION_MODE", "getINTERPRETER_CREATION_MODE", "PREVIOUSLY_CONFIGURED", "Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "getPREVIOUSLY_CONFIGURED", "()Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "pythonImplementation", "getPythonImplementation", "(Lcom/intellij/openapi/projectRoots/Sdk;)Ljava/lang/String;", "version", "Lcom/jetbrains/python/psi/LanguageLevel;", "getVersion", "(Lcom/intellij/openapi/projectRoots/Sdk;)Lcom/jetbrains/python/psi/LanguageLevel;", "executionType", "Lcom/jetbrains/python/statistics/InterpreterTarget;", "getExecutionType", "(Lcom/intellij/openapi/projectRoots/Sdk;)Lcom/jetbrains/python/statistics/InterpreterTarget;", "interpreterType", "Lcom/jetbrains/python/statistics/InterpreterType;", "getInterpreterType", "(Lcom/intellij/openapi/projectRoots/Sdk;)Lcom/jetbrains/python/statistics/InterpreterType;", "Lcom/jetbrains/python/target/PyTargetAwareAdditionalData;", "(Lcom/jetbrains/python/target/PyTargetAwareAdditionalData;)Lcom/jetbrains/python/statistics/InterpreterTarget;", "Lcom/jetbrains/python/remote/PyRemoteSdkAdditionalDataBase;", "(Lcom/jetbrains/python/remote/PyRemoteSdkAdditionalDataBase;)Lcom/jetbrains/python/statistics/InterpreterTarget;", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nPyStatisticTools.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyStatisticTools.kt\ncom/jetbrains/python/statistics/PyStatisticToolsKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,183:1\n11546#2,9:184\n13472#2:193\n13473#2:195\n11555#2:196\n1310#2,2:199\n1#3:194\n1#3:197\n19#4:198\n1563#5:201\n1634#5,3:202\n*S KotlinDebug\n*F\n+ 1 PyStatisticTools.kt\ncom/jetbrains/python/statistics/PyStatisticToolsKt\n*L\n35#1:184,9\n35#1:193\n35#1:195\n35#1:196\n181#1:199,2\n35#1:194\n151#1:198\n126#1:201\n126#1:202,3\n*E\n"})
public final class PyStatisticToolsKt {
    @NotNull
    private static final StringEventField PYTHON_VERSION;
    @NotNull
    private static final StringEventField PYTHON_IMPLEMENTATION;
    @NotNull
    private static final StringEventField EXECUTION_TYPE;
    @NotNull
    private static final StringEventField INTERPRETER_TYPE;
    @NotNull
    private static final StringEventField INTERPRETER_CREATION_MODE;
    @NotNull
    private static final BooleanEventField PREVIOUSLY_CONFIGURED;

    @NotNull
    public static final Module[] getModules(@NotNull Project $this$modules) {
        Intrinsics.checkNotNullParameter((Object)$this$modules, (String)"<this>");
        return ModuleManager.Companion.getInstance($this$modules).getModules();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Sdk> getSdks(@NotNull Project $this$sdks) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$sdks, (String)"<this>");
        Module[] $this$mapNotNull$iv = PyStatisticToolsKt.getModules($this$sdks);
        boolean $i$f$mapNotNull = false;
        Module[] moduleArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            Sdk it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            void p0 = element$iv$iv;
            boolean bl2 = false;
            if (ModuleExtKt.getSdk((Module)p0) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final List<EventPair<?>> getPythonSpecificInfo(@NotNull Module module2) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
                object = ModuleExtKt.getSdk(module2);
                if (object == null) break block2;
                Sdk sdk2 = object;
                boolean bl = false;
                List<EventPair<?>> list = PyStatisticToolsKt.getPythonSpecificInfo(sdk2);
                object = list;
                if (list != null) break block3;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @NotNull
    public static final List<EventPair<?>> getPythonSpecificInfo(@NotNull Sdk sdk2) {
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        ArrayList<EventPair> data = new ArrayList<EventPair>();
        if (!PythonSdkUtil.isPythonSdk(sdk2)) {
            return data;
        }
        data.add(EventFields.Language.with((Object)PythonLanguage.INSTANCE));
        data.add(PYTHON_VERSION.with((Object)PyStatisticToolsKt.getVersion(sdk2).toPythonVersion()));
        data.add(PYTHON_IMPLEMENTATION.with((Object)PyStatisticToolsKt.getPythonImplementation(sdk2)));
        data.add(EXECUTION_TYPE.with((Object)PyStatisticToolsKt.getExecutionType(sdk2).getValue()));
        data.add(INTERPRETER_TYPE.with((Object)PyStatisticToolsKt.getInterpreterType(sdk2).getValue()));
        return data;
    }

    @Deprecated(message="\n  It makes no sense to add a Python version or something similar to the event.\n  If you need to get an event with a specific execution type, interpreter type, or whatsoever, please use the corresponding segment in the analytics platform.\n  Thank you very much!\n  ")
    @NotNull
    public static final VarargEventId registerPythonSpecificEvent(@NotNull EventLogGroup group2, @NotNull String eventId, EventField<?> ... extraFields) {
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        Intrinsics.checkNotNullParameter(extraFields, (String)"extraFields");
        SpreadBuilder spreadBuilder = new SpreadBuilder(6);
        spreadBuilder.add((Object)EventFields.Language);
        spreadBuilder.add((Object)PYTHON_VERSION);
        spreadBuilder.add((Object)PYTHON_IMPLEMENTATION);
        spreadBuilder.add((Object)EXECUTION_TYPE);
        spreadBuilder.add((Object)INTERPRETER_TYPE);
        spreadBuilder.addSpread(extraFields);
        return group2.registerVarargEvent(eventId, (EventField[])spreadBuilder.toArray((Object[])new EventField[spreadBuilder.size()]));
    }

    @NotNull
    public static final StringEventField getPYTHON_VERSION() {
        return PYTHON_VERSION;
    }

    @NotNull
    public static final StringEventField getPYTHON_IMPLEMENTATION() {
        return PYTHON_IMPLEMENTATION;
    }

    @NotNull
    public static final StringEventField getEXECUTION_TYPE() {
        return EXECUTION_TYPE;
    }

    @NotNull
    public static final StringEventField getINTERPRETER_TYPE() {
        return INTERPRETER_TYPE;
    }

    @NotNull
    public static final StringEventField getINTERPRETER_CREATION_MODE() {
        return INTERPRETER_CREATION_MODE;
    }

    @NotNull
    public static final BooleanEventField getPREVIOUSLY_CONFIGURED() {
        return PREVIOUSLY_CONFIGURED;
    }

    private static final String getPythonImplementation(Sdk $this$pythonImplementation) {
        PythonSdkFlavor<?> pythonSdkFlavor = PythonSdkFlavor.getFlavor($this$pythonImplementation);
        if (pythonSdkFlavor == null || (pythonSdkFlavor = pythonSdkFlavor.getName()) == null) {
            pythonSdkFlavor = "Python";
        }
        return pythonSdkFlavor;
    }

    @NotNull
    public static final LanguageLevel getVersion(@Nullable Sdk $this$version) {
        LanguageLevel languageLevel = PySdkUtil.getLanguageLevelForSdk($this$version);
        Intrinsics.checkNotNullExpressionValue((Object)languageLevel, (String)"getLanguageLevelForSdk(...)");
        return languageLevel;
    }

    @NotNull
    public static final InterpreterTarget getExecutionType(@NotNull Sdk $this$executionType) {
        Intrinsics.checkNotNullParameter((Object)$this$executionType, (String)"<this>");
        SdkAdditionalData additionalData = $this$executionType.getSdkAdditionalData();
        return additionalData instanceof PyTargetAwareAdditionalData ? PyStatisticToolsKt.getExecutionType((PyTargetAwareAdditionalData)additionalData) : (additionalData instanceof PyRemoteSdkAdditionalDataBase ? PyStatisticToolsKt.getExecutionType((PyRemoteSdkAdditionalDataBase)additionalData) : InterpreterTarget.LOCAL);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final InterpreterType getInterpreterType(@NotNull Sdk $this$interpreterType) {
        InterpreterType interpreterType;
        block10: {
            block9: {
                Intrinsics.checkNotNullParameter((Object)$this$interpreterType, (String)"<this>");
                if (PipenvKt.isPipEnv($this$interpreterType)) {
                    interpreterType = InterpreterType.PIPENV;
                    return interpreterType;
                }
                if (UvExtKt.isUv($this$interpreterType)) {
                    interpreterType = InterpreterType.UV;
                    return interpreterType;
                }
                if (PoetryKt.isPoetry($this$interpreterType)) {
                    interpreterType = InterpreterType.POETRY;
                    return interpreterType;
                }
                if (PythonSdkUtil.isConda($this$interpreterType)) break block9;
                SdkAdditionalData $this$asSafely$iv = $this$interpreterType.getSdkAdditionalData();
                boolean $i$f$asSafely = false;
                SdkAdditionalData sdkAdditionalData = $this$asSafely$iv;
                if (!(sdkAdditionalData instanceof PythonSdkAdditionalData)) {
                    sdkAdditionalData = null;
                }
                PythonSdkAdditionalData pythonSdkAdditionalData = (PythonSdkAdditionalData)sdkAdditionalData;
                if (!((pythonSdkAdditionalData != null ? pythonSdkAdditionalData.getFlavor() : null) instanceof CondaEnvSdkFlavor)) break block10;
            }
            interpreterType = InterpreterType.CONDAVENV;
            return interpreterType;
        }
        if (VirtualEnvReader.Companion.getInstance().isPyenvSdk($this$interpreterType.getHomePath())) {
            interpreterType = InterpreterType.PYENV;
            return interpreterType;
        }
        if (PythonSdkUtil.isVirtualEnv($this$interpreterType)) {
            interpreterType = InterpreterType.VIRTUALENV;
            return interpreterType;
        }
        interpreterType = InterpreterType.REGULAR;
        return interpreterType;
    }

    private static final InterpreterTarget getExecutionType(PyTargetAwareAdditionalData $this$executionType) {
        Object object;
        block4: {
            block3: {
                object = $this$executionType.getTargetEnvironmentConfiguration();
                if (object == null || (object = object.getTypeId()) == null) break block3;
                Object typeId = object;
                boolean bl = false;
                Object object2 = typeId;
                InterpreterTarget interpreterTarget = Intrinsics.areEqual((Object)object2, (Object)InterpreterTarget.TARGET_SSH_WEB_DEVELOPMENT.getValue()) ? InterpreterTarget.REMOTE_WEB_DEPLOYMENT : (Intrinsics.areEqual((Object)object2, (Object)InterpreterTarget.TARGET_SSH_SFTP.getValue()) ? InterpreterTarget.REMOTE_SSH_CREDENTIALS : (Intrinsics.areEqual((Object)object2, (Object)InterpreterTarget.TARGET_DOCKER.getValue()) ? InterpreterTarget.REMOTE_DOCKER : (Intrinsics.areEqual((Object)object2, (Object)InterpreterTarget.TARGET_DOCKER_COMPOSE.getValue()) ? InterpreterTarget.REMOTE_DOCKER_COMPOSE : (Intrinsics.areEqual((Object)object2, (Object)InterpreterTarget.TARGET_VAGRANT.getValue()) ? InterpreterTarget.REMOTE_VAGRANT : (Intrinsics.areEqual((Object)object2, (Object)InterpreterTarget.TARGET_WSL.getValue()) ? InterpreterTarget.REMOTE_WSL : InterpreterTarget.REMOTE_UNKNOWN)))));
                object = interpreterTarget;
                if (interpreterTarget != null) break block4;
            }
            object = InterpreterTarget.REMOTE_UNKNOWN;
        }
        return object;
    }

    private static final InterpreterTarget getExecutionType(PyRemoteSdkAdditionalDataBase $this$executionType) {
        InterpreterTarget interpreterTarget;
        InterpreterTarget interpreterTarget2;
        block6: {
            Object object;
            CredentialsType type2 = $this$executionType.getRemoteConnectionType();
            boolean bl = false;
            if (type2 == null) {
                object = "Remote_null";
            } else if (PluginInfoDetectorKt.getPluginInfo(type2.getClass()).isDevelopedByJetBrains()) {
                String string = type2.getName();
                object = "Remote_" + (string != null ? StringsKt.replace$default((String)string, (char)' ', (char)'_', (boolean)false, (int)4, null) : null);
            } else {
                object = "third_party";
            }
            String name2 = object;
            boolean bl2 = false;
            InterpreterTarget[] $this$firstOrNull$iv = InterpreterTarget.values();
            boolean $i$f$firstOrNull = false;
            int n = $this$firstOrNull$iv.length;
            for (int i = 0; i < n; ++i) {
                InterpreterTarget element$iv;
                InterpreterTarget it = element$iv = $this$firstOrNull$iv[i];
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.getValue(), (Object)name2)) continue;
                interpreterTarget2 = element$iv;
                break block6;
            }
            interpreterTarget2 = interpreterTarget = null;
        }
        if (interpreterTarget2 == null) {
            interpreterTarget = InterpreterTarget.REMOTE_UNKNOWN;
        }
        return interpreterTarget;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_4;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        PYTHON_VERSION = EventFields.StringValidatedByRegexpReference$default((String)"python_version", (String)"version", null, (int)4, null);
        PYTHON_IMPLEMENTATION = EventFields.String((String)"python_implementation", (List)CollectionsKt.listOf((Object)"Python"));
        Object[] objectArray = new String[]{InterpreterTarget.LOCAL.getValue(), InterpreterTarget.REMOTE_DOCKER.getValue(), InterpreterTarget.REMOTE_DOCKER_COMPOSE.getValue(), InterpreterTarget.REMOTE_WSL.getValue(), InterpreterTarget.REMOTE_NULL.getValue(), InterpreterTarget.THIRD_PARTY.getValue(), InterpreterTarget.REMOTE_SSH_CREDENTIALS.getValue(), InterpreterTarget.REMOTE_VAGRANT.getValue(), InterpreterTarget.REMOTE_WEB_DEPLOYMENT.getValue(), InterpreterTarget.REMOTE_UNKNOWN.getValue()};
        EXECUTION_TYPE = EventFields.String((String)"executionType", (List)CollectionsKt.listOf((Object[])objectArray));
        objectArray = (Iterable)InterpreterType.getEntries();
        String string = "interpreterType";
        boolean $i$f$map = false;
        void var2_3 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            InterpreterType interpreterType = (InterpreterType)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getValue());
        }
        INTERPRETER_TYPE = EventFields.String((String)string, (List)((List)var3_4));
        objectArray = new String[]{InterpreterCreationMode.SIMPLE.getValue(), InterpreterCreationMode.CUSTOM.getValue(), InterpreterCreationMode.NA.getValue()};
        INTERPRETER_CREATION_MODE = EventFields.String((String)"interpreter_creation_mode", (List)CollectionsKt.listOf((Object[])objectArray));
        PREVIOUSLY_CONFIGURED = EventFields.Boolean((String)"previously_configured");
    }
}

