/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.codeInsight.controlflow.PyTypeAssertionEvaluator;
import com.jetbrains.python.codeInsight.stdlib.PyDataclassTypeProvider;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.PyCapturePattern;
import com.jetbrains.python.psi.PyCaseClause;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyClassPattern;
import com.jetbrains.python.psi.PyDoubleStarPattern;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyKeyValuePattern;
import com.jetbrains.python.psi.PyKeywordPattern;
import com.jetbrains.python.psi.PyMappingPattern;
import com.jetbrains.python.psi.PyMatchStatement;
import com.jetbrains.python.psi.PyPattern;
import com.jetbrains.python.psi.PySequencePattern;
import com.jetbrains.python.psi.PySingleStarPattern;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyElementImpl;
import com.jetbrains.python.psi.impl.PyEvaluator;
import com.jetbrains.python.psi.impl.PySequencePatternImpl;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyCollectionType;
import com.jetbrains.python.psi.types.PyCollectionTypeImpl;
import com.jetbrains.python.psi.types.PyLiteralType;
import com.jetbrains.python.psi.types.PyNeverType;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.PyTypeUtil;
import com.jetbrains.python.psi.types.PyTypedDictType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyCapturePatternImpl
extends PyElementImpl
implements PyCapturePattern {
    static Set<String> SPECIAL_BUILTINS = Set.of("bool", "bytearray", "bytes", "dict", "float", "frozenset", "int", "list", "set", "str", "tuple");

    public PyCapturePatternImpl(ASTNode astNode) {
        super(astNode);
    }

    @Override
    protected void acceptPyVisitor(PyElementVisitor pyVisitor) {
        pyVisitor.visitPyCapturePattern(this);
    }

    @Override
    @Nullable
    public PyType getType(@NotNull TypeEvalContext context, @NotNull TypeEvalContext.Key key) {
        if (context == null) {
            PyCapturePatternImpl.$$$reportNull$$$0(0);
        }
        if (key == null) {
            PyCapturePatternImpl.$$$reportNull$$$0(1);
        }
        return PyCapturePatternImpl.getCaptureType(this, context);
    }

    @Nullable
    static PyType getCaptureType(@NotNull PyPattern pattern, @NotNull TypeEvalContext context) {
        PyElement parentPattern;
        if (pattern == null) {
            PyCapturePatternImpl.$$$reportNull$$$0(2);
        }
        if (context == null) {
            PyCapturePatternImpl.$$$reportNull$$$0(3);
        }
        if ((parentPattern = (PyElement)PsiTreeUtil.getParentOfType((PsiElement)pattern, (Class[])new Class[]{PyCaseClause.class, PySingleStarPattern.class, PyDoubleStarPattern.class, PyKeyValuePattern.class, PySequencePattern.class, PyClassPattern.class, PyKeywordPattern.class})) instanceof PyCaseClause) {
            PyCaseClause caseClause = (PyCaseClause)parentPattern;
            PyMatchStatement matchStatement = PyUtil.as(caseClause.getParent(), PyMatchStatement.class);
            if (matchStatement == null) {
                return null;
            }
            PyExpression subject = matchStatement.getSubject();
            if (subject == null) {
                return null;
            }
            PyType subjectType = context.getType(subject);
            for (PyCaseClause cs : matchStatement.getCaseClauses()) {
                if (cs == caseClause) break;
                if (cs.getPattern() == null || cs.getGuardCondition() != null && !PyEvaluator.evaluateAsBoolean(cs.getGuardCondition(), false) || !cs.getPattern().canExcludePatternType(context)) continue;
                subjectType = (PyType)Ref.deref(PyTypeAssertionEvaluator.createAssertionType(subjectType, context.getType(cs.getPattern()), false, context));
            }
            return subjectType;
        }
        if (parentPattern instanceof PySingleStarPattern) {
            PySingleStarPattern starPattern = (PySingleStarPattern)parentPattern;
            PySequencePattern sequenceParent = PyUtil.as(starPattern.getParent(), PySequencePattern.class);
            if (sequenceParent == null) {
                return null;
            }
            PyType sequenceType = PySequencePatternImpl.getSequenceCaptureType(sequenceParent, context);
            PyType iteratedType = (PyType)PyTypeUtil.toStream(sequenceType).flatMap(it -> starPattern.getCapturedTypesFromSequenceType((PyType)it, context).stream()).collect(PyTypeUtil.toUnion());
            return PySequencePatternImpl.wrapInListType(iteratedType, (PsiElement)pattern);
        }
        if (parentPattern instanceof PyDoubleStarPattern) {
            PyMappingPattern mappingParent = PyUtil.as(parentPattern.getParent(), PyMappingPattern.class);
            if (mappingParent == null) {
                return null;
            }
            PyType mappingType = PyTypeUtil.convertToType(context.getType(mappingParent), "typing.Mapping", (PsiElement)pattern, context);
            if (mappingType instanceof PyCollectionType) {
                PyCollectionType collectionType = (PyCollectionType)mappingType;
                PyClass dict = PyBuiltinCache.getInstance((PsiElement)pattern).getClass("dict");
                return dict != null ? new PyCollectionTypeImpl(dict, false, collectionType.getElementTypes()) : null;
            }
            return null;
        }
        if (parentPattern instanceof PyKeyValuePattern) {
            PyKeyValuePattern keyValuePattern = (PyKeyValuePattern)parentPattern;
            PyMappingPattern mappingParent = PyUtil.as(keyValuePattern.getParent(), PyMappingPattern.class);
            if (mappingParent == null) {
                return null;
            }
            return (PyType)PyTypeUtil.toStream(PyCapturePatternImpl.getCaptureType(mappingParent, context)).map(type2 -> {
                PyType mappingType;
                if (type2 instanceof PyTypedDictType) {
                    PyLiteralType l;
                    PyExpression patt5645$temp;
                    PyTypedDictType typedDictType = (PyTypedDictType)type2;
                    PyType patt5583$temp = context.getType(keyValuePattern.getKeyPattern());
                    if (patt5583$temp instanceof PyLiteralType && (patt5645$temp = (l = (PyLiteralType)patt5583$temp).getExpression()) instanceof PyStringLiteralExpression) {
                        PyStringLiteralExpression str = (PyStringLiteralExpression)patt5645$temp;
                        return typedDictType.getElementType(str.getStringValue());
                    }
                }
                if ((mappingType = PyTypeUtil.convertToType(type2, "typing.Mapping", (PsiElement)pattern, context)) == null) {
                    return PyNeverType.NEVER;
                }
                if (mappingType instanceof PyCollectionType) {
                    PyCollectionType collectionType = (PyCollectionType)mappingType;
                    return collectionType.getElementTypes().get(1);
                }
                return null;
            }).collect(PyTypeUtil.toUnion());
        }
        if (parentPattern instanceof PySequencePattern) {
            PySequencePattern sequencePattern = (PySequencePattern)parentPattern;
            PyType sequenceType = PySequencePatternImpl.getSequenceCaptureType(sequencePattern, context);
            if (sequenceType == null) {
                return null;
            }
            PsiElement sequenceMember = PsiTreeUtil.findFirstParent((PsiElement)pattern, el -> el.getParent() == sequencePattern);
            List<PyPattern> elements = sequencePattern.getElements();
            int idx = elements.indexOf(sequenceMember);
            int starIdx = ContainerUtil.indexOf(elements, it2 -> it2 instanceof PySingleStarPattern);
            return (PyType)PyTypeUtil.toStream(sequenceType).map(it -> {
                PyTupleType tupleType;
                if (it instanceof PyTupleType && !(tupleType = (PyTupleType)it).isHomogeneous()) {
                    if (starIdx == -1 || idx < starIdx) {
                        return tupleType.getElementType(idx);
                    }
                    int starSpan = tupleType.getElementCount() - elements.size();
                    return tupleType.getElementType(idx + starSpan);
                }
                PyType upcast = PyTypeUtil.convertToType(it, "typing.Sequence", (PsiElement)pattern, context);
                if (upcast instanceof PyCollectionType) {
                    PyCollectionType collectionType = (PyCollectionType)upcast;
                    return collectionType.getIteratedItemType();
                }
                return null;
            }).collect(PyTypeUtil.toUnion());
        }
        if (parentPattern instanceof PyClassPattern) {
            PyClassPattern classPattern = (PyClassPattern)parentPattern;
            List<PyPattern> arguments = classPattern.getArgumentList().getPatterns();
            int index = arguments.indexOf(pattern);
            if (index < 0) {
                return null;
            }
            return (PyType)PyTypeUtil.toStream(context.getType(classPattern)).map(type2 -> {
                if (type2 instanceof PyClassType) {
                    PyClassType classType = (PyClassType)type2;
                    if (SPECIAL_BUILTINS.contains(classType.getClassQName())) {
                        if (index == 0) {
                            return classType;
                        }
                        return null;
                    }
                    List<String> matchArgs = PyCapturePatternImpl.getMatchArgs(classType, context);
                    if (matchArgs == null || matchArgs.size() > arguments.size()) {
                        return null;
                    }
                    PyTypedElement instanceAttribute = PyUtil.as(PyCapturePatternImpl.resolveTypeMember(classType, matchArgs.get(index), context), PyTypedElement.class);
                    if (instanceAttribute == null) {
                        return null;
                    }
                    return PyTypeChecker.substitute(context.getType(instanceAttribute), PyTypeChecker.unifyReceiver(classType, context), context);
                }
                return null;
            }).collect(PyTypeUtil.toUnion());
        }
        if (parentPattern instanceof PyKeywordPattern) {
            PyKeywordPattern keywordPattern = (PyKeywordPattern)parentPattern;
            PyClassPattern classPattern = (PyClassPattern)PsiTreeUtil.getParentOfType((PsiElement)keywordPattern, PyClassPattern.class);
            if (classPattern == null) {
                return null;
            }
            PyType elements = context.getType(classPattern);
            if (elements instanceof PyClassType) {
                PyClassType classType = (PyClassType)elements;
                PyTypedElement instanceAttribute = PyUtil.as(PyCapturePatternImpl.resolveTypeMember(classType, keywordPattern.getKeyword(), context), PyTypedElement.class);
                if (instanceAttribute == null) {
                    return null;
                }
                return context.getType(instanceAttribute);
            }
            return null;
        }
        return null;
    }

    static @Nullable List<@NotNull String> getMatchArgs(@NotNull PyClassType type2, @NotNull TypeEvalContext context) {
        PyClass cls;
        List<String> matchArgs;
        if (type2 == null) {
            PyCapturePatternImpl.$$$reportNull$$$0(4);
        }
        if (context == null) {
            PyCapturePatternImpl.$$$reportNull$$$0(5);
        }
        if ((matchArgs = (cls = type2.getPyClass()).getOwnMatchArgs()) == null) {
            matchArgs = PyDataclassTypeProvider.Companion.getGeneratedMatchArgs(cls, context);
        }
        return matchArgs;
    }

    @Nullable
    static PsiElement resolveTypeMember(@NotNull PyType type2, @NotNull String name2, @NotNull TypeEvalContext context) {
        PyResolveContext resolveContext;
        List<? extends RatedResolveResult> results;
        if (type2 == null) {
            PyCapturePatternImpl.$$$reportNull$$$0(6);
        }
        if (name2 == null) {
            PyCapturePatternImpl.$$$reportNull$$$0(7);
        }
        if (context == null) {
            PyCapturePatternImpl.$$$reportNull$$$0(8);
        }
        return !ContainerUtil.isEmpty(results = type2.resolveMember(name2, null, AccessDirection.READ, resolveContext = PyResolveContext.defaultContext(context))) ? results.get(0).getElement() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/psi/impl/PyCapturePatternImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getType";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getCaptureType";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getMatchArgs";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveTypeMember";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

