/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.ex.ConfigurableExtensionPointUtil;
import com.intellij.openapi.options.ex.ConfigurableVisitor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.backend.workspace.WorkspaceModelChangeListener;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.storage.EntityChange;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.VersionedStorageChange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.PathUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.workspaceModel.ide.impl.legacyBridge.module.ModuleEntityUtils;
import com.intellij.workspaceModel.ide.legacyBridge.ModuleBridge;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PythonIdeLanguageCustomization;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionExtension;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.projectModel.uv.UvProjectModelService;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.sdk.BasePySdkExtKt;
import com.jetbrains.python.sdk.PyDetectedSdk;
import com.jetbrains.python.sdk.PyInterpreterInspectionQuickFixData;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PySdkPopupFactory;
import com.jetbrains.python.sdk.PySdkProvider;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.conda.PyCondaSdkCustomizer;
import com.jetbrains.python.sdk.configuration.PyProjectSdkConfiguration;
import com.jetbrains.python.sdk.configuration.PyProjectSdkConfigurationExtension;
import com.jetbrains.python.ui.PyUiUtil;
import java.io.File;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Pair;
import kotlin.jvm.functions.Function0;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class PyInterpreterInspection
extends PyInspection {
    @NotNull
    private static final Logger LOGGER = Logger.getInstance(PyInterpreterInspection.class);
    @NotNull
    private static final Pattern NAME = Pattern.compile("Python (?<version>\\d\\.\\d+)\\s*(\\((?<name>.+?)\\))?");

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyInterpreterInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PyInterpreterInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(holder, PyInspectionVisitor.getContext(session));
    }

    @Nullable
    private static Module guessModule(@NotNull PsiElement element) {
        Module module2;
        if (element == null) {
            PyInterpreterInspection.$$$reportNull$$$0(2);
        }
        if ((module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)element)) == null) {
            Module[] modules = ModuleManager.getInstance((Project)element.getProject()).getModules();
            if (modules.length != 1) {
                return null;
            }
            module2 = modules[0];
        }
        return module2;
    }

    private static boolean isFileIgnored(@NotNull PyFile pyFile) {
        if (pyFile == null) {
            PyInterpreterInspection.$$$reportNull$$$0(3);
        }
        return PyInspectionExtension.EP_NAME.getExtensionList().stream().anyMatch(ep -> ep.ignoreInterpreterWarnings(pyFile));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyFile";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/inspections/PyInterpreterInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "guessModule";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isFileIgnored";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Visitor
    extends PyInspectionVisitor {
        private static final AsyncLoadingCache<Module, List<PyDetectedSdk>> DETECTED_ASSOCIATED_ENVS_CACHE = Caffeine.newBuilder().executor((Executor)AppExecutorUtil.getAppExecutorService()).expireAfterWrite(Duration.ofSeconds(20L)).weakKeys().buildAsync(module2 -> {
            List<Sdk> existingSdks = Visitor.getExistingSdks();
            UserDataHolderBase context = new UserDataHolderBase();
            return PySdkExtKt.detectAssociatedEnvironments(module2, existingSdks, (UserDataHolder)context);
        });

        public Visitor(@Nullable ProblemsHolder holder, @NotNull TypeEvalContext context) {
            if (context == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, context);
        }

        @Override
        public void visitPyFile(@NotNull PyFile node) {
            Module module2;
            if (node == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            if ((module2 = PyInterpreterInspection.guessModule((PsiElement)node)) == null || PyInterpreterInspection.isFileIgnored(node)) {
                return;
            }
            Sdk sdk2 = PythonSdkUtil.findPythonSdk(module2);
            boolean pyCharm = PythonIdeLanguageCustomization.isMainlyPythonIde();
            ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>();
            if (sdk2 == null) {
                @InspectionMessage String message = pyCharm ? PyPsiBundle.message("INSP.interpreter.no.python.interpreter.configured.for.project", new Object[0]) : PyPsiBundle.message("INSP.interpreter.no.python.interpreter.configured.for.module", new Object[0]);
                this.registerProblemWithCommonFixes(node, message, module2, null, fixes, pyCharm);
            } else {
                PyInterpreterInspectionQuickFixData fixData;
                @NlsSafe String associatedModulePath = PySdkExtKt.getAssociatedModulePath(sdk2);
                if (!(PlatformUtils.isFleetBackend() || associatedModulePath != null && !PySdkExtKt.isAssociatedWithAnotherModule(sdk2, module2) || Registry.is((String)"python.project.model.uv", (boolean)false) && Visitor.isAssociatedWithUvWorkspaceRootModule(associatedModulePath, module2) || (fixData = (PyInterpreterInspectionQuickFixData)PySdkProvider.EP_NAME.getExtensionList().stream().map(ext -> ext.createEnvironmentAssociationFix(module2, sdk2, pyCharm, associatedModulePath)).filter(it -> it != null).findFirst().orElse(null)) == null)) {
                    fixes.add(fixData.getQuickFix());
                    this.registerProblemWithCommonFixes(node, fixData.getMessage(), module2, sdk2, fixes, pyCharm);
                    return;
                }
                if (!PySdkExtKt.getSdkSeemsValid(sdk2)) {
                    @InspectionMessage String message = pyCharm ? PyPsiBundle.message("INSP.interpreter.invalid.python.interpreter.selected.for.project", new Object[0]) : PyPsiBundle.message("INSP.interpreter.invalid.python.interpreter.selected.for.module", new Object[0]);
                    this.registerProblemWithCommonFixes(node, message, module2, sdk2, fixes, pyCharm);
                } else {
                    LanguageLevel languageLevel = PythonSdkType.getLanguageLevelForSdk(sdk2);
                    if (!LanguageLevel.SUPPORTED_LEVELS.contains(languageLevel)) {
                        @InspectionMessage String message = pyCharm ? PyPsiBundle.message("INSP.interpreter.python.has.reached.its.end.of.life.and.is.no.longer.supported.in.pycharm", languageLevel) : PyPsiBundle.message("INSP.interpreter.python.has.reached.its.end.life.and.is.no.longer.supported.in.python.plugin", languageLevel);
                        this.registerProblemWithCommonFixes(node, message, module2, sdk2, fixes, pyCharm);
                    }
                }
            }
        }

        private static boolean isAssociatedWithUvWorkspaceRootModule(@Nullable String sdkAssociatedPath, @NotNull Module module2) {
            if (module2 == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            if (sdkAssociatedPath == null) {
                return false;
            }
            UvProjectModelService.UvWorkspace<@NotNull Module> uvWorkspace = UvProjectModelService.INSTANCE.findWorkspace(module2);
            if (uvWorkspace == null) {
                return false;
            }
            return sdkAssociatedPath.equals(BasePySdkExtKt.getBasePath(uvWorkspace.getRoot()));
        }

        private void registerProblemWithCommonFixes(PyFile node, @InspectionMessage String message, Module module2, Sdk sdk2, List<LocalQuickFix> fixes, boolean pyCharm) {
            if (pyCharm && sdk2 == null) {
                String sdkName2 = ProjectRootManager.getInstance((Project)node.getProject()).getProjectSdkName();
                ContainerUtil.addIfNotNull(fixes, (Object)Visitor.getSuitableSdkFix(sdkName2, module2));
            }
            if (pyCharm) {
                fixes.add(new ConfigureInterpreterFix());
            } else {
                fixes.add(new InterpreterSettingsQuickFix(module2));
            }
            this.registerProblem((PsiElement)node, message, fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
        }

        @Nullable
        private static LocalQuickFix getSuitableSdkFix(@Nullable String name2, @NotNull Module module2) {
            Sdk sharedCondaEnv;
            PyDetectedSdk detectedSystemWideSdk;
            Matcher matcher;
            List<Sdk> existingSdks;
            Sdk associatedSdk;
            if (module2 == null) {
                Visitor.$$$reportNull$$$0(3);
            }
            if ((associatedSdk = PySdkExtKt.mostPreferred(PySdkExtKt.filterAssociatedSdks(module2, existingSdks = Visitor.getExistingSdks()))) != null) {
                return new UseExistingInterpreterFix(associatedSdk, module2);
            }
            UserDataHolderBase context = new UserDataHolderBase();
            List detectedAssociatedEnvs = Collections.emptyList();
            while (true) {
                try {
                    detectedAssociatedEnvs = (List)DETECTED_ASSOCIATED_ENVS_CACHE.get((Object)module2).get(10L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException | TimeoutException ignored) {
                    ProgressManager.checkCanceled();
                    continue;
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to get suitable sdk fix for name " + name2 + " and module " + String.valueOf(module2), (Throwable)e);
                }
                break;
            }
            PyDetectedSdk detectedAssociatedSdk = (PyDetectedSdk)((Object)ContainerUtil.getFirstItem((List)detectedAssociatedEnvs));
            if (detectedAssociatedSdk != null) {
                return new UseDetectedInterpreterFix(detectedAssociatedSdk, existingSdks, true, module2);
            }
            Pair<@IntentionName String, PyProjectSdkConfigurationExtension> textAndExtension = PyProjectSdkConfigurationExtension.findForModule(module2);
            if (textAndExtension != null) {
                return new UseProvidedInterpreterFix(module2, (PyProjectSdkConfigurationExtension)textAndExtension.getSecond(), (String)textAndExtension.getFirst());
            }
            if (name2 != null && (matcher = NAME.matcher(name2)).matches()) {
                String venvName = matcher.group("name");
                if (venvName != null) {
                    PyDetectedSdk detectedAssociatedViaRootNameEnv = Visitor.detectAssociatedViaRootNameEnv(venvName, module2, existingSdks, context);
                    if (detectedAssociatedViaRootNameEnv != null) {
                        return new UseDetectedInterpreterFix(detectedAssociatedViaRootNameEnv, existingSdks, true, module2);
                    }
                } else {
                    detectedSystemWideSdk = Visitor.detectSystemWideSdk(matcher.group("version"), module2, existingSdks, context);
                    if (detectedSystemWideSdk != null) {
                        return new UseDetectedInterpreterFix(detectedSystemWideSdk, existingSdks, false, module2);
                    }
                }
            }
            if (PyCondaSdkCustomizer.Companion.getInstance().getSuggestSharedCondaEnvironments() && (sharedCondaEnv = PySdkExtKt.mostPreferred(PySdkExtKt.filterSharedCondaEnvs(module2, existingSdks))) != null) {
                return new UseExistingInterpreterFix(sharedCondaEnv, module2);
            }
            Sdk systemWideSdk = PySdkExtKt.mostPreferred(PySdkExtKt.filterSystemWideSdks(existingSdks));
            if (systemWideSdk != null) {
                return new UseExistingInterpreterFix(systemWideSdk, module2);
            }
            LocalQuickFix fallbackFix = PyCondaSdkCustomizer.Companion.getInstance().getFallbackInterpreterFix();
            if (fallbackFix != null) {
                return fallbackFix;
            }
            detectedSystemWideSdk = (PyDetectedSdk)((Object)ContainerUtil.getFirstItem(PySdkExtKt.detectSystemWideSdks(module2, existingSdks)));
            if (detectedSystemWideSdk != null) {
                return new UseDetectedInterpreterFix(detectedSystemWideSdk, existingSdks, false, module2);
            }
            return null;
        }

        private static @Unmodifiable @NotNull List<Sdk> getExistingSdks() {
            ProjectSdksModel model2 = new ProjectSdksModel();
            model2.reset(null);
            List list = ContainerUtil.filter((Object[])model2.getSdks(), it -> it.getSdkType() instanceof PythonSdkType);
            if (list == null) {
                Visitor.$$$reportNull$$$0(4);
            }
            return list;
        }

        @Nullable
        private static PyDetectedSdk detectAssociatedViaRootNameEnv(@NotNull String associatedName, @NotNull Module module2, @NotNull List<Sdk> existingSdks, @NotNull UserDataHolderBase context) {
            if (associatedName == null) {
                Visitor.$$$reportNull$$$0(5);
            }
            if (module2 == null) {
                Visitor.$$$reportNull$$$0(6);
            }
            if (existingSdks == null) {
                Visitor.$$$reportNull$$$0(7);
            }
            if (context == null) {
                Visitor.$$$reportNull$$$0(8);
            }
            return Visitor.findAssociatedViaRootNameEnv(associatedName, PySdkExtKt.detectVirtualEnvs(module2, existingSdks, (UserDataHolder)context), Visitor::getVirtualEnvRootName);
        }

        @Nullable
        private static PyDetectedSdk detectSystemWideSdk(@NotNull String version2, @NotNull Module module2, @NotNull List<Sdk> existingSdks, @NotNull UserDataHolderBase context) {
            LanguageLevel parsedVersion;
            if (version2 == null) {
                Visitor.$$$reportNull$$$0(9);
            }
            if (module2 == null) {
                Visitor.$$$reportNull$$$0(10);
            }
            if (existingSdks == null) {
                Visitor.$$$reportNull$$$0(11);
            }
            if (context == null) {
                Visitor.$$$reportNull$$$0(12);
            }
            if ((parsedVersion = LanguageLevel.fromPythonVersion((String)version2)).toString().equals(version2)) {
                return (PyDetectedSdk)((Object)ContainerUtil.find(PySdkExtKt.detectSystemWideSdks(module2, existingSdks, (UserDataHolder)context), sdk2 -> PySdkExtKt.getGuessedLanguageLevel(sdk2) == parsedVersion));
            }
            return null;
        }

        @Nullable
        private static PyDetectedSdk findAssociatedViaRootNameEnv(@NotNull String associatedName, @NotNull List<PyDetectedSdk> envs, @NotNull Function<PyDetectedSdk, String> envRootName) {
            if (associatedName == null) {
                Visitor.$$$reportNull$$$0(13);
            }
            if (envs == null) {
                Visitor.$$$reportNull$$$0(14);
            }
            if (envRootName == null) {
                Visitor.$$$reportNull$$$0(15);
            }
            return ((StreamEx)StreamEx.of(envs).filter(sdk2 -> associatedName.equals(envRootName.apply((PyDetectedSdk)((Object)sdk2))))).max(Comparator.comparing(PySdkExtKt::getGuessedLanguageLevel).thenComparing(ProjectJdkImpl::getHomePath)).orElse(null);
        }

        @Nullable
        private static String getVirtualEnvRootName(@NotNull PyDetectedSdk sdk2) {
            String path2;
            if (sdk2 == null) {
                Visitor.$$$reportNull$$$0(16);
            }
            return (path2 = sdk2.getHomePath()) == null ? null : Visitor.getEnvRootName(PythonSdkUtil.getVirtualEnvRoot(path2));
        }

        @Nullable
        private static String getEnvRootName(@Nullable File envRoot) {
            return envRoot == null ? null : PathUtil.getFileName((String)envRoot.getPath());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 2: 
                case 3: 
                case 6: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyInterpreterInspection$Visitor";
                    break;
                }
                case 5: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "associatedName";
                    break;
                }
                case 7: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "existingSdks";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "version";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "envs";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "envRootName";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdk";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyInterpreterInspection$Visitor";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExistingSdks";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "visitPyFile";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isAssociatedWithUvWorkspaceRootModule";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getSuitableSdkFix";
                    break;
                }
                case 4: {
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "detectAssociatedViaRootNameEnv";
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "detectSystemWideSdk";
                    break;
                }
                case 13: 
                case 14: 
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "findAssociatedViaRootNameEnv";
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "getVirtualEnvRootName";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }

        private static class CacheCleaner
        implements WorkspaceModelChangeListener,
        ProjectJdkTable.Listener {
            private CacheCleaner() {
            }

            public void jdkAdded(@NotNull Sdk jdk) {
                if (jdk == null) {
                    CacheCleaner.$$$reportNull$$$0(0);
                }
                CacheCleaner.invalidate();
            }

            public void jdkRemoved(@NotNull Sdk jdk) {
                if (jdk == null) {
                    CacheCleaner.$$$reportNull$$$0(1);
                }
                CacheCleaner.invalidate();
            }

            public void jdkNameChanged(@NotNull Sdk jdk, @NotNull String previousName) {
                if (jdk == null) {
                    CacheCleaner.$$$reportNull$$$0(2);
                }
                if (previousName == null) {
                    CacheCleaner.$$$reportNull$$$0(3);
                }
                CacheCleaner.invalidate();
            }

            public void beforeChanged(@NotNull VersionedStorageChange event) {
                if (event == null) {
                    CacheCleaner.$$$reportNull$$$0(4);
                }
                for (EntityChange change : event.getChanges(ModuleEntity.class)) {
                    ModuleBridge module2;
                    ModuleEntity entity = (ModuleEntity)change.getOldEntity();
                    if (entity == null || (module2 = ModuleEntityUtils.findModule((ModuleEntity)entity, (EntityStorage)event.getStorageBefore())) == null) continue;
                    DETECTED_ASSOCIATED_ENVS_CACHE.synchronous().invalidate((Object)module2);
                }
            }

            private static void invalidate() {
                DETECTED_ASSOCIATED_ENVS_CACHE.synchronous().invalidateAll();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "jdk";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "previousName";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/python/inspections/PyInterpreterInspection$Visitor$CacheCleaner";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "jdkAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "jdkRemoved";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "jdkNameChanged";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    private static final class UseDetectedInterpreterFix
    extends UseInterpreterFix<PyDetectedSdk> {
        @NotNull
        private final List<Sdk> myExistingSdks;
        private final boolean doAssociate;
        @NotNull
        private final Module myModule;

        private UseDetectedInterpreterFix(@NotNull PyDetectedSdk detectedSdk, @NotNull List<Sdk> existingSdks, boolean associate, @NotNull Module module2) {
            if (detectedSdk == null) {
                UseDetectedInterpreterFix.$$$reportNull$$$0(0);
            }
            if (existingSdks == null) {
                UseDetectedInterpreterFix.$$$reportNull$$$0(1);
            }
            if (module2 == null) {
                UseDetectedInterpreterFix.$$$reportNull$$$0(2);
            }
            super(detectedSdk);
            this.myExistingSdks = existingSdks;
            this.doAssociate = associate;
            this.myModule = module2;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            if (project == null) {
                UseDetectedInterpreterFix.$$$reportNull$$$0(3);
            }
            if (descriptor2 == null) {
                UseDetectedInterpreterFix.$$$reportNull$$$0(4);
            }
            PyUiUtil.clearFileLevelInspectionResults(descriptor2.getPsiElement().getContainingFile());
            Sdk newSdk2 = PySdkExtKt.setupAssociatedLogged((PyDetectedSdk)this.mySdk, this.myExistingSdks, BasePySdkExtKt.getBasePath(this.myModule), this.doAssociate);
            if (newSdk2 == null) {
                return;
            }
            SdkConfigurationUtil.addSdk((Sdk)newSdk2);
            PyProjectSdkConfiguration.INSTANCE.setReadyToUseSdk(project, this.myModule, newSdk2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "detectedSdk";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "existingSdks";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/PyInterpreterInspection$UseDetectedInterpreterFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyFix";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class UseExistingInterpreterFix
    extends UseInterpreterFix<Sdk> {
        @NotNull
        private final Module myModule;

        private UseExistingInterpreterFix(@NotNull Sdk existingSdk, @NotNull Module module2) {
            if (existingSdk == null) {
                UseExistingInterpreterFix.$$$reportNull$$$0(0);
            }
            if (module2 == null) {
                UseExistingInterpreterFix.$$$reportNull$$$0(1);
            }
            super(existingSdk);
            this.myModule = module2;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            if (project == null) {
                UseExistingInterpreterFix.$$$reportNull$$$0(2);
            }
            if (descriptor2 == null) {
                UseExistingInterpreterFix.$$$reportNull$$$0(3);
            }
            PyUiUtil.clearFileLevelInspectionResults(descriptor2.getPsiElement().getContainingFile());
            PyProjectSdkConfiguration.INSTANCE.setReadyToUseSdk(project, this.myModule, this.mySdk);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "existingSdk";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/PyInterpreterInspection$UseExistingInterpreterFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyFix";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class UseInterpreterFix<T extends Sdk>
    implements LocalQuickFix {
        @NotNull
        protected final T mySdk;

        protected UseInterpreterFix(@NotNull T sdk2) {
            if (sdk2 == null) {
                UseInterpreterFix.$$$reportNull$$$0(0);
            }
            this.mySdk = sdk2;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PyPsiBundle.message("INSP.interpreter.use.suggested.interpreter", new Object[0]);
            if (string == null) {
                UseInterpreterFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @IntentionName
        @NotNull
        public String getName() {
            String string = PyPsiBundle.message("INSP.interpreter.use.interpreter", PySdkPopupFactory.Companion.shortenNameInPopup((Sdk)this.mySdk, 75));
            if (string == null) {
                UseInterpreterFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdk";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyInterpreterInspection$UseInterpreterFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyInterpreterInspection$UseInterpreterFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    private static final class UseProvidedInterpreterFix
    implements LocalQuickFix {
        @NotNull
        private final Module myModule;
        @NotNull
        private final PyProjectSdkConfigurationExtension myExtension;
        @NotNull
        @IntentionName
        private final String myName;

        private UseProvidedInterpreterFix(@NotNull Module module2, @NotNull PyProjectSdkConfigurationExtension extension, @NotNull @IntentionName String name2) {
            if (module2 == null) {
                UseProvidedInterpreterFix.$$$reportNull$$$0(0);
            }
            if (extension == null) {
                UseProvidedInterpreterFix.$$$reportNull$$$0(1);
            }
            if (name2 == null) {
                UseProvidedInterpreterFix.$$$reportNull$$$0(2);
            }
            this.myModule = module2;
            this.myExtension = extension;
            this.myName = name2;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PyPsiBundle.message("INSP.interpreter.use.suggested.interpreter", new Object[0]);
            if (string == null) {
                UseProvidedInterpreterFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        @IntentionName
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                UseProvidedInterpreterFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            if (project == null) {
                UseProvidedInterpreterFix.$$$reportNull$$$0(5);
            }
            if (descriptor2 == null) {
                UseProvidedInterpreterFix.$$$reportNull$$$0(6);
            }
            PyProjectSdkConfiguration.INSTANCE.configureSdkUsingExtension(this.myModule, this.myExtension, (Function0<? extends Sdk>)((Function0)() -> this.myExtension.createAndAddSdkForInspection(this.myModule)));
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
            if (project == null) {
                UseProvidedInterpreterFix.$$$reportNull$$$0(7);
            }
            if (previewDescriptor == null) {
                UseProvidedInterpreterFix.$$$reportNull$$$0(8);
            }
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                UseProvidedInterpreterFix.$$$reportNull$$$0(9);
            }
            return intentionPreviewInfo;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 9 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extension";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 3: 
                case 4: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyInterpreterInspection$UseProvidedInterpreterFix";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previewDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyInterpreterInspection$UseProvidedInterpreterFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generatePreview";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 9: {
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "generatePreview";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 9 -> new IllegalStateException(string);
            };
        }
    }

    public static final class ConfigureInterpreterFix
    implements LocalQuickFix {
        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PyPsiBundle.message("INSP.interpreter.configure.python.interpreter", new Object[0]);
            if (string == null) {
                ConfigureInterpreterFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            PsiElement element;
            if (project == null) {
                ConfigureInterpreterFix.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                ConfigureInterpreterFix.$$$reportNull$$$0(2);
            }
            if ((element = descriptor2.getPsiElement()) == null) {
                return;
            }
            Module module2 = PyInterpreterInspection.guessModule(element);
            if (module2 == null) {
                return;
            }
            PySdkPopupFactory.Companion.createAndShow(module2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyInterpreterInspection$ConfigureInterpreterFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyInterpreterInspection$ConfigureInterpreterFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    public static final class InterpreterSettingsQuickFix
    implements LocalQuickFix {
        @NotNull
        private final Module myModule;

        public InterpreterSettingsQuickFix(@NotNull Module module2) {
            if (module2 == null) {
                InterpreterSettingsQuickFix.$$$reportNull$$$0(0);
            }
            this.myModule = module2;
        }

        @NotNull
        public String getFamilyName() {
            String string = PlatformUtils.isPyCharm() ? PyPsiBundle.message("INSP.interpreter.interpreter.settings", new Object[0]) : PyPsiBundle.message("INSP.interpreter.configure.python.interpreter", new Object[0]);
            if (string == null) {
                InterpreterSettingsQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            if (project == null) {
                InterpreterSettingsQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor2 == null) {
                InterpreterSettingsQuickFix.$$$reportNull$$$0(3);
            }
            InterpreterSettingsQuickFix.showPythonInterpreterSettings(project, this.myModule);
        }

        public static void showPythonInterpreterSettings(@NotNull Project project, @Nullable Module module2) {
            if (project == null) {
                InterpreterSettingsQuickFix.$$$reportNull$$$0(4);
            }
            String id = "com.jetbrains.python.configuration.PyActiveSdkModuleConfigurable";
            ConfigurableGroup group2 = ConfigurableExtensionPointUtil.getConfigurableGroup((Project)project, (boolean)true);
            if (ConfigurableVisitor.findById((String)"com.jetbrains.python.configuration.PyActiveSdkModuleConfigurable", Collections.singletonList(group2)) != null) {
                ShowSettingsUtilImpl.showSettingsDialog((Project)project, (String)"com.jetbrains.python.configuration.PyActiveSdkModuleConfigurable", null);
                return;
            }
            ProjectSettingsService settingsService = ProjectSettingsService.getInstance((Project)project);
            if (module2 == null || InterpreterSettingsQuickFix.justOneModuleInheritingSdk(project, module2)) {
                settingsService.openProjectSettings();
            } else {
                settingsService.openModuleSettings(module2);
            }
        }

        private static boolean justOneModuleInheritingSdk(@NotNull Project project, @NotNull Module module2) {
            if (project == null) {
                InterpreterSettingsQuickFix.$$$reportNull$$$0(5);
            }
            if (module2 == null) {
                InterpreterSettingsQuickFix.$$$reportNull$$$0(6);
            }
            return ProjectRootManager.getInstance((Project)project).getProjectSdk() == null && ModuleRootManager.getInstance((Module)module2).isSdkInherited() && ModuleManager.getInstance((Project)project).getModules().length < 2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyInterpreterInspection$InterpreterSettingsQuickFix";
                    break;
                }
                case 2: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyInterpreterInspection$InterpreterSettingsQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "showPythonInterpreterSettings";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "justOneModuleInheritingSdk";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

