/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.stat;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.LongEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.util.system.OS;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.statistics.PyStatisticToolsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u001e\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aR\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/jupyter/py/stat/JupyterPyFeaturesCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "<init>", "()V", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "GROUP", "OS_TYPE", "Lcom/intellij/internal/statistic/eventLog/events/EnumEventField;", "Lcom/intellij/util/system/OS;", "DURATION", "Lcom/intellij/internal/statistic/eventLog/events/LongEventField;", "IS_SUCCESS", "Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "installFailed", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "sdkUsed", "sdkIsUsedForJupyter", "", "pythonSdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "packageInstallResult", "isSuccess", "", "sdk", "durationMs", "", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\nJupyterPyFeaturesCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterPyFeaturesCollector.kt\ncom/intellij/jupyter/py/stat/JupyterPyFeaturesCollector\n+ 2 EventFields.kt\ncom/intellij/internal/statistic/eventLog/events/EventFields\n*L\n1#1,61:1\n249#2,3:62\n*S KotlinDebug\n*F\n+ 1 JupyterPyFeaturesCollector.kt\ncom/intellij/jupyter/py/stat/JupyterPyFeaturesCollector\n*L\n16#1:62,3\n*E\n"})
public final class JupyterPyFeaturesCollector
extends CounterUsagesCollector {
    @NotNull
    public static final JupyterPyFeaturesCollector INSTANCE;
    @NotNull
    private static final EventLogGroup GROUP;
    @NotNull
    private static final EnumEventField<OS> OS_TYPE;
    @NotNull
    private static final LongEventField DURATION;
    @NotNull
    private static final BooleanEventField IS_SUCCESS;
    @NotNull
    private static final VarargEventId installFailed;
    @NotNull
    private static final VarargEventId sdkUsed;

    private JupyterPyFeaturesCollector() {
    }

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    public final void sdkIsUsedForJupyter(@Nullable Sdk pythonSdk) {
        if (pythonSdk == null) {
            return;
        }
        if (!PythonSdkUtil.isPythonSdk((Sdk)pythonSdk)) {
            return;
        }
        List pythonSpecificInfo = PyStatisticToolsKt.getPythonSpecificInfo((Sdk)pythonSdk);
        sdkUsed.log(pythonSpecificInfo);
    }

    public final void packageInstallResult(boolean isSuccess, @NotNull Sdk sdk, long durationMs) {
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        long durationInTensOfSeconds = durationMs / (long)10000;
        Object[] objectArray = new EventPair[6];
        objectArray[0] = IS_SUCCESS.with((Object)isSuccess);
        objectArray[1] = PyStatisticToolsKt.getPYTHON_VERSION().with((Object)PyStatisticToolsKt.getVersion((Sdk)sdk).toPythonVersion());
        objectArray[2] = PyStatisticToolsKt.getEXECUTION_TYPE().with((Object)PyStatisticToolsKt.getExecutionType((Sdk)sdk).getValue());
        objectArray[3] = PyStatisticToolsKt.getINTERPRETER_TYPE().with((Object)PyStatisticToolsKt.getInterpreterType((Sdk)sdk).getValue());
        OS oS = OS.CURRENT;
        Intrinsics.checkNotNullExpressionValue((Object)oS, (String)"CURRENT");
        objectArray[4] = OS_TYPE.with((Object)oS);
        objectArray[5] = DURATION.with((Object)(durationInTensOfSeconds * (long)10));
        List data = CollectionsKt.listOf((Object[])objectArray);
        installFailed.log(data);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$iv;
        INSTANCE = new JupyterPyFeaturesCollector();
        GROUP = new EventLogGroup("jupyter.py.features", 5, null, 4, null);
        EventField[] eventFieldArray = EventFields.INSTANCE;
        String name$iv = "OS";
        Function1 transform$iv = $this$iv.getDefaultEnumTransform();
        boolean $i$f$Enum = false;
        OS_TYPE = new EnumEventField(name$iv, OS.class, null, transform$iv);
        DURATION = EventFields.Long$default((String)"duration_sec", null, (int)2, null);
        IS_SUCCESS = EventFields.Boolean((String)"success");
        eventFieldArray = new EventField[]{IS_SUCCESS, OS_TYPE, PyStatisticToolsKt.getPYTHON_VERSION(), PyStatisticToolsKt.getEXECUTION_TYPE(), PyStatisticToolsKt.getINTERPRETER_TYPE(), DURATION};
        installFailed = GROUP.registerVarargEvent("jupyter.package.install", "Jupyter Package install conditions", eventFieldArray);
        eventFieldArray = new EventField[]{EventFields.Language, PyStatisticToolsKt.getPYTHON_VERSION(), PyStatisticToolsKt.getPYTHON_IMPLEMENTATION(), PyStatisticToolsKt.getEXECUTION_TYPE(), PyStatisticToolsKt.getINTERPRETER_TYPE()};
        sdkUsed = GROUP.registerVarargEvent("jupyter.py.started.with.sdk", "SDK parameters of interpreter with which Jupyter was started.", eventFieldArray);
    }
}

