/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.llmInstaller.jupyter;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.scriptLoader.utils.JupyterCoroutineKt;
import com.intellij.llmInstaller.api.AiPluginCoreConstants;
import com.intellij.llmInstaller.jupyter.JupyterLLMPromotionLicenseUtils;
import com.intellij.llmInstaller.jupyter.LLMJupyterPromotionStatistics;
import com.intellij.llmInstaller.ui.hub.AIHubPopupAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.PermanentInstallationID;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.PlatformUtils;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000f\u001a\u00020\rH\u0002J\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0013\u001a\u00020\rH\u0002J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u000e\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lcom/intellij/llmInstaller/jupyter/LLMJupyterPromotionUtils;", "", "<init>", "()V", "PROMOTE_JUPYTER_EXPIRED", "", "PROMOTE_JUPYTER_BUTTON_CLICKED", "AIA_PLUGIN_INSTALLED_FLAG", "PROMOTE_JUPYTER_LLM_FIRST_SHOW_TIMESTAMP", "PROMOTE_JUPYTER_TIME_DIFF", "", "USER_PERCENTAGE", "isEnterpriseUser", "", "Ljava/lang/Boolean;", "isAiaPluginAvailable", "checkIsPromotionEnabled", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isUserInTargetPercentage", "getPromotionExpiredFlag", "appLevelPropertiesComponent", "Lcom/intellij/ide/util/PropertiesComponent;", "getAiaPluginInstalledFlag", "getPromoteTimestamp", "", "getPromoteButtonClickedFlag", "openPromotionIfNecessary", "intellij.llmInstaller.jupyter"})
public final class LLMJupyterPromotionUtils {
    @NotNull
    public static final LLMJupyterPromotionUtils INSTANCE = new LLMJupyterPromotionUtils();
    @NotNull
    private static final String PROMOTE_JUPYTER_EXPIRED = "llm.jupyter.promotion.expired";
    @NotNull
    private static final String PROMOTE_JUPYTER_BUTTON_CLICKED = "llm.jupyter.promote.button.clicked";
    @NotNull
    private static final String AIA_PLUGIN_INSTALLED_FLAG = "llm.jupyter.promotion.aia.plugin.installed";
    @NotNull
    private static final String PROMOTE_JUPYTER_LLM_FIRST_SHOW_TIMESTAMP = "llm.jupyter.promote.first.show.timestamp";
    private static final int PROMOTE_JUPYTER_TIME_DIFF = 1209600000;
    private static final int USER_PERCENTAGE = 20;
    @Nullable
    private static Boolean isEnterpriseUser;

    private LLMJupyterPromotionUtils() {
    }

    private final boolean isAiaPluginAvailable() {
        if (!PluginManager.isPluginInstalled((PluginId)AiPluginCoreConstants.INSTANCE.getLLM_PLUGIN_ID())) {
            return false;
        }
        IdeaPluginDescriptor ideaPluginDescriptor = PluginManager.getInstance().findEnabledPlugin(AiPluginCoreConstants.INSTANCE.getLLM_PLUGIN_ID());
        if (ideaPluginDescriptor == null) {
            return false;
        }
        IdeaPluginDescriptor findEnabledPlugin = ideaPluginDescriptor;
        return PluginManagerCore.isLoaded((PluginDescriptor)((PluginDescriptor)findEnabledPlugin));
    }

    public final boolean checkIsPromotionEnabled(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        PropertiesComponent appLevelPropertiesComponent = PropertiesComponent.getInstance();
        if (this.isAiaPluginAvailable()) {
            Intrinsics.checkNotNull((Object)appLevelPropertiesComponent);
            if (!this.getAiaPluginInstalledFlag(appLevelPropertiesComponent) && this.getPromoteButtonClickedFlag(appLevelPropertiesComponent)) {
                appLevelPropertiesComponent.setValue(AIA_PLUGIN_INSTALLED_FLAG, true);
                LLMJupyterPromotionStatistics.INSTANCE.logAiaPluginInstalled();
            }
            return false;
        }
        if (PlatformUtils.isDataSpell()) {
            return true;
        }
        Intrinsics.checkNotNull((Object)appLevelPropertiesComponent);
        if (this.getPromotionExpiredFlag(appLevelPropertiesComponent) || this.getPromoteButtonClickedFlag(appLevelPropertiesComponent)) {
            return false;
        }
        long promoteTimestamp = this.getPromoteTimestamp(appLevelPropertiesComponent);
        long currentTimestamp = System.currentTimeMillis();
        if (promoteTimestamp == 0L) {
            LLMJupyterPromotionStatistics.INSTANCE.logFirstShown();
            appLevelPropertiesComponent.setValue(PROMOTE_JUPYTER_LLM_FIRST_SHOW_TIMESTAMP, String.valueOf(currentTimestamp));
        } else {
            boolean isWithinTimeFrame;
            boolean bl = isWithinTimeFrame = currentTimestamp - promoteTimestamp < 1209600000L;
            if (!isWithinTimeFrame) {
                LLMJupyterPromotionStatistics.INSTANCE.logExpiredWithoutClick();
                appLevelPropertiesComponent.setValue(PROMOTE_JUPYTER_EXPIRED, true);
                return false;
            }
        }
        if (Registry.Companion.is("llm.jupyter.promotion.always.on")) {
            return true;
        }
        if (!this.isUserInTargetPercentage()) {
            return false;
        }
        if (isEnterpriseUser == null) {
            JupyterCoroutineKt.launchBackground((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
                int label;

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            v0 = JupyterLLMPromotionLicenseUtils.INSTANCE.isEnterpriseUser((Continuation<? super Boolean>)((Continuation)this));
                            if (v0 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl14
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl14:
                            // 2 sources

                            LLMJupyterPromotionUtils.access$setEnterpriseUser$p((Boolean)v0);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
            return false;
        }
        return Intrinsics.areEqual((Object)isEnterpriseUser, (Object)false);
    }

    private final boolean isUserInTargetPercentage() {
        String string = PermanentInstallationID.get();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
        String userId = string;
        int hash = userId.hashCode();
        int normalizedHash = Math.abs(hash) % 100;
        return normalizedHash < 20;
    }

    private final boolean getPromotionExpiredFlag(PropertiesComponent appLevelPropertiesComponent) {
        return appLevelPropertiesComponent.getBoolean(PROMOTE_JUPYTER_EXPIRED, false);
    }

    private final boolean getAiaPluginInstalledFlag(PropertiesComponent appLevelPropertiesComponent) {
        return appLevelPropertiesComponent.getBoolean(AIA_PLUGIN_INSTALLED_FLAG, false);
    }

    private final long getPromoteTimestamp(PropertiesComponent appLevelPropertiesComponent) {
        return appLevelPropertiesComponent.getLong(PROMOTE_JUPYTER_LLM_FIRST_SHOW_TIMESTAMP, 0L);
    }

    private final boolean getPromoteButtonClickedFlag(PropertiesComponent appLevelPropertiesComponent) {
        return appLevelPropertiesComponent.getBoolean(PROMOTE_JUPYTER_BUTTON_CLICKED, false);
    }

    public final boolean openPromotionIfNecessary(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.checkIsPromotionEnabled(event)) {
            LLMJupyterPromotionStatistics.INSTANCE.logClicked();
            new AIHubPopupAction().actionPerformed(event);
            PropertiesComponent appLevelPropertiesComponent = PropertiesComponent.getInstance();
            appLevelPropertiesComponent.setValue(PROMOTE_JUPYTER_BUTTON_CLICKED, true);
            return true;
        }
        return false;
    }

    public static final /* synthetic */ void access$setEnterpriseUser$p(Boolean bl) {
        isEnterpriseUser = bl;
    }
}

