/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch.dashboard;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.branch.GroupingKey;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.idea.AppMode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.vcs.impl.shared.rpc.RepositoryId;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SmartExpander;
import com.intellij.ui.hover.TreeHoverListener;
import com.intellij.util.ui.JBUI;
import com.intellij.vcs.branch.BranchData;
import com.intellij.vcs.branch.BranchPresentation;
import com.intellij.vcs.branch.LinkedBranchDataImpl;
import com.intellij.vcs.git.shared.branch.GitInOutCountersInProject;
import com.intellij.vcs.git.shared.branch.GitInOutStateKt;
import com.intellij.vcs.git.shared.ui.GitBranchesTreeIconProvider;
import com.intellij.vcs.git.shared.ui.GitIncomingOutgoingUi;
import com.intellij.vcsUtil.VcsImplUtil;
import git4idea.GitLocalBranch;
import git4idea.GitReference;
import git4idea.config.GitVcsSettings;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.ui.branch.dashboard.BranchInfo;
import git4idea.ui.branch.dashboard.BranchNodeDescriptor;
import git4idea.ui.branch.dashboard.BranchTreeNode;
import git4idea.ui.branch.dashboard.BranchesTreeKt;
import git4idea.ui.branch.dashboard.BranchesTreeSelection;
import git4idea.ui.branch.dashboard.RefInfo;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0012B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0016J\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0002R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesTreeComponent;", "Lcom/intellij/ide/dnd/aware/DnDAwareTree;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "searchField", "Lcom/intellij/ui/SearchTextField;", "getSearchField", "()Lcom/intellij/ui/SearchTextField;", "setSearchField", "(Lcom/intellij/ui/SearchTextField;)V", "hasFocus", "", "getSelection", "Lgit4idea/ui/branch/dashboard/BranchesTreeSelection;", "initDnD", "", "BranchTreeCellRenderer", "intellij.vcs.git"})
public final class BranchesTreeComponent
extends DnDAwareTree {
    @Nullable
    private SearchTextField searchField;

    public BranchesTreeComponent(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.putClientProperty(DnDAwareTree.AUTO_SELECT_ON_MOUSE_PRESSED, false);
        this.setCellRenderer((TreeCellRenderer)((Object)new BranchTreeCellRenderer(project)));
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setOpaque(false);
        this.setHorizontalAutoScrollingEnabled(false);
        SmartExpander.installOn((JTree)((JTree)((Object)this)));
        if (!AppMode.isRemoteDevHost()) {
            TreeHoverListener.DEFAULT.addTo((JComponent)((Object)this));
        }
        this.initDnD();
    }

    @Nullable
    public final SearchTextField getSearchField() {
        return this.searchField;
    }

    public final void setSearchField(@Nullable SearchTextField searchTextField) {
        this.searchField = searchTextField;
    }

    public boolean hasFocus() {
        SearchTextField searchTextField;
        return super.hasFocus() || ((searchTextField = this.searchField) != null && (searchTextField = searchTextField.getTextEditor()) != null ? searchTextField.hasFocus() : false);
    }

    @NotNull
    public final BranchesTreeSelection getSelection() {
        return new BranchesTreeSelection(this.getSelectionPaths());
    }

    private final void initDnD() {
        if (!GraphicsEnvironment.isHeadless()) {
            this.setTransferHandler(BranchesTreeKt.access$getBRANCH_TREE_TRANSFER_HANDLER$p());
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005JB\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0016H\u0016J\b\u0010\u001c\u001a\u00020\u0016H\u0014J$\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#H\u0002J\u0010\u0010%\u001a\u00020\u00102\u0006\u0010&\u001a\u00020'H\u0016R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lgit4idea/ui/branch/dashboard/BranchesTreeComponent$BranchTreeCellRenderer;", "Lcom/intellij/ui/ColoredTreeCellRenderer;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lgit4idea/ui/branch/dashboard/BranchesTreeComponent;Lcom/intellij/openapi/project/Project;)V", "repositoryManager", "Lgit4idea/repo/GitRepositoryManager;", "Lorg/jetbrains/annotations/NotNull;", "settings", "Lgit4idea/config/GitVcsSettings;", "kotlin.jvm.PlatformType", "incomingLabel", "Ljavax/swing/JLabel;", "outgoingLabel", "customizeCellRenderer", "", "tree", "Ljavax/swing/JTree;", "value", "", "selected", "", "expanded", "leaf", "row", "", "hasFocus", "calcFocusedState", "getBranchesTooltipData", "", "Lcom/intellij/vcs/branch/BranchData;", "branchName", "", "repositories", "", "Lgit4idea/repo/GitRepository;", "paint", "g", "Ljava/awt/Graphics;", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nBranchesTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BranchesTree.kt\ngit4idea/ui/branch/dashboard/BranchesTreeComponent$BranchTreeCellRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,514:1\n1563#2:515\n1634#2,3:516\n*S KotlinDebug\n*F\n+ 1 BranchesTree.kt\ngit4idea/ui/branch/dashboard/BranchesTreeComponent$BranchTreeCellRenderer\n*L\n149#1:515\n149#1:516,3\n*E\n"})
    private final class BranchTreeCellRenderer
    extends ColoredTreeCellRenderer {
        @NotNull
        private final GitRepositoryManager repositoryManager;
        private final GitVcsSettings settings;
        @NotNull
        private final JLabel incomingLabel;
        @NotNull
        private final JLabel outgoingLabel;

        public BranchTreeCellRenderer(Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            GitRepositoryManager gitRepositoryManager = GitRepositoryManager.getInstance(project);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)gitRepositoryManager), (String)"getInstance(...)");
            this.repositoryManager = gitRepositoryManager;
            this.settings = GitVcsSettings.getInstance((Project)project);
            this.incomingLabel = GitIncomingOutgoingUi.INSTANCE.createIncomingLabel();
            this.outgoingLabel = GitIncomingOutgoingUi.INSTANCE.createOutgoingLabel();
        }

        public void customizeCellRenderer(@NotNull JTree tree, @Nullable Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            boolean repositoryGrouping;
            RefInfo refInfo;
            Icon icon;
            Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
            if (!(value instanceof BranchTreeNode)) {
                return;
            }
            BranchNodeDescriptor descriptor = ((BranchTreeNode)value).getNodeDescriptor();
            BranchNodeDescriptor branchNodeDescriptor = descriptor;
            if (branchNodeDescriptor instanceof BranchNodeDescriptor.Ref) {
                icon = GitBranchesTreeIconProvider.forRef$default((GitBranchesTreeIconProvider)GitBranchesTreeIconProvider.INSTANCE, (GitReference)((BranchNodeDescriptor.Ref)descriptor).getRefInfo().getRef(), (boolean)((BranchNodeDescriptor.Ref)descriptor).getRefInfo().isCurrent(), (boolean)((BranchNodeDescriptor.Ref)descriptor).getRefInfo().isFavorite(), (boolean)selected, (boolean)false, (int)16, null);
            } else if (branchNodeDescriptor instanceof BranchNodeDescriptor.Group || branchNodeDescriptor instanceof BranchNodeDescriptor.RemoteGroup) {
                icon = GitBranchesTreeIconProvider.INSTANCE.forGroup();
            } else if (branchNodeDescriptor instanceof BranchNodeDescriptor.Repository) {
                Project project = ((BranchNodeDescriptor.Repository)descriptor).getRepository().getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                RepositoryId repositoryId = ((BranchNodeDescriptor.Repository)descriptor).getRepository().getRpcId();
                Intrinsics.checkNotNullExpressionValue((Object)repositoryId, (String)"getRpcId(...)");
                icon = GitBranchesTreeIconProvider.INSTANCE.forRepository(project, repositoryId);
            } else {
                icon = null;
            }
            this.setIcon(icon);
            this.append(((BranchTreeNode)value).getNodeDescriptor().getDisplayName(), SimpleTextAttributes.REGULAR_ATTRIBUTES, true);
            BranchNodeDescriptor.Ref ref = descriptor instanceof BranchNodeDescriptor.Ref ? (BranchNodeDescriptor.Ref)descriptor : null;
            RefInfo refInfo2 = refInfo = ref != null ? ref.getRefInfo() : null;
            if (refInfo != null && !(repositoryGrouping = this.settings.getBranchSettings().isGroupingEnabled(GroupingKey.GROUPING_BY_REPOSITORY)) && refInfo.getRepositories().size() < this.repositoryManager.getRepositories().size()) {
                this.append(" (" + DvcsUtil.getShortNames((Collection)refInfo.getRepositories()) + ")", SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
            if (refInfo instanceof BranchInfo) {
                this.setToolTipText(((BranchInfo)refInfo).isLocalBranch() ? BranchPresentation.INSTANCE.getTooltip((Collection)this.getBranchesTooltipData(((BranchInfo)refInfo).getBranchName(), (Collection<? extends GitRepository>)BranchesTreeSelection.Companion.getSelectedRepositories((BranchTreeNode)value))) : null);
                GitInOutCountersInProject incomingOutgoingState = ((BranchInfo)refInfo).getIncomingOutgoingState();
                GitIncomingOutgoingUi.INSTANCE.updateIncomingCommitLabel(this.incomingLabel, incomingOutgoingState);
                GitIncomingOutgoingUi.INSTANCE.updateOutgoingCommitLabel(this.outgoingLabel, incomingOutgoingState);
                FontMetrics fontMetrics = this.incomingLabel.getFontMetrics(this.incomingLabel.getFont());
                this.incomingLabel.setSize(new Dimension(fontMetrics.stringWidth(this.incomingLabel.getText()) + JBUI.scale((int)1) + this.incomingLabel.getIcon().getIconWidth(), fontMetrics.getHeight()));
                this.outgoingLabel.setSize(new Dimension(fontMetrics.stringWidth(this.outgoingLabel.getText()) + JBUI.scale((int)1) + this.outgoingLabel.getIcon().getIconWidth(), fontMetrics.getHeight()));
                tree.setToolTipText(GitInOutStateKt.calcTooltip((GitInOutCountersInProject)incomingOutgoingState));
            } else {
                this.incomingLabel.setVisible(false);
                this.outgoingLabel.setVisible(false);
                tree.setToolTipText(null);
            }
        }

        protected boolean calcFocusedState() {
            SearchTextField searchTextField;
            return super.calcFocusedState() || ((searchTextField = BranchesTreeComponent.this.getSearchField()) != null && (searchTextField = searchTextField.getTextEditor()) != null ? searchTextField.hasFocus() : false);
        }

        /*
         * WARNING - void declaration
         */
        private final List<BranchData> getBranchesTooltipData(String branchName, Collection<? extends GitRepository> repositories) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = repositories;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String presentableRootName;
                void repo;
                GitRepository gitRepository = (GitRepository)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                GitLocalBranch gitLocalBranch = repo.getBranches().findLocalBranch(branchName);
                String trackedBranchName = gitLocalBranch != null && (gitLocalBranch = gitLocalBranch.findTrackedBranch((GitRepository)repo)) != null ? gitLocalBranch.getName() : null;
                Intrinsics.checkNotNullExpressionValue((Object)VcsImplUtil.getShortVcsRootName((Project)repo.getProject(), (VirtualFile)repo.getRoot()), (String)"getShortVcsRootName(...)");
                collection.add(new LinkedBranchDataImpl(presentableRootName, branchName, trackedBranchName));
            }
            return (List)destination$iv$iv;
        }

        public void paint(@NotNull Graphics g) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            super.paint(g);
            int xOffset = this.getPreferredSize().width + this.getTree().getInsets().left;
            boolean yShifted = false;
            if (this.incomingLabel.isVisible()) {
                Icon incIcon = this.incomingLabel.getIcon();
                g.translate(xOffset, (this.getSize().height - incIcon.getIconHeight()) / 2);
                yShifted = true;
                this.incomingLabel.paint(g);
                xOffset = this.incomingLabel.getWidth() + JBUI.scale((int)3);
            }
            if (this.outgoingLabel.isVisible()) {
                Icon outIcon = this.outgoingLabel.getIcon();
                g.translate(xOffset, yShifted ? 0 : (this.getSize().height - outIcon.getIconHeight()) / 2);
                this.outgoingLabel.paint(g);
            }
        }
    }
}

