/*
 * Decompiled with CFR 0.152.
 */
package com.michaelbaranov.microba;

import com.michaelbaranov.microba.calendar.ui.basic.BasicCalendarPaneUI;
import com.michaelbaranov.microba.calendar.ui.basic.BasicDatePickerUI;
import com.michaelbaranov.microba.common.MicrobaComponent;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

public final class Microba {
    private static final UIChangeListener changeListener = new UIChangeListener();
    private static final Map<String, Map<String, Color>> lookAndFeelToOverride = new HashMap<String, Map<String, Color>>();

    public static synchronized void init() {
        Microba.setLookAndFeelProperties(UIManager.getLookAndFeel());
        UIManager.removePropertyChangeListener(changeListener);
        UIManager.addPropertyChangeListener(changeListener);
    }

    private static synchronized void setLookAndFeelProperties(LookAndFeel lookAndFeel) {
        if (lookAndFeel == null) {
            return;
        }
        String packagePrefix = "com.michaelbaranov.microba.";
        UIManager.put("microba.CalendarPaneUI", packagePrefix + "calendar.ui.basic.BasicCalendarPaneUI");
        UIManager.put(packagePrefix + "calendar.ui.basic.BasicCalendarPaneUI", BasicCalendarPaneUI.class);
        UIManager.put("microba.DatePickerUI", packagePrefix + "calendar.ui.basic.BasicDatePickerUI");
        UIManager.put(packagePrefix + "calendar.ui.basic.BasicDatePickerUI", BasicDatePickerUI.class);
    }

    public static void setColorOverrideMap(String lookAndFeel, Map<String, Color> overrides) {
        lookAndFeelToOverride.put(lookAndFeel, overrides);
    }

    public static synchronized Color getOverridenColor(String colorConstant, MicrobaComponent component) {
        Map<String, Color> componentOverrideMap = component.getColorOverrideMap();
        if (componentOverrideMap != null && componentOverrideMap.containsKey(colorConstant)) {
            Color val = componentOverrideMap.get(colorConstant);
            if (val != null) {
                return val;
            }
            return UIManager.getColor(val);
        }
        String currentLookAndFeel = UIManager.getLookAndFeel().getID();
        Map<String, Color> overrides = lookAndFeelToOverride.get(currentLookAndFeel);
        if (overrides != null && overrides.containsKey(colorConstant)) {
            Color val = overrides.get(colorConstant);
            if (val != null) {
                return val;
            }
            return UIManager.getColor(val);
        }
        return null;
    }

    public static synchronized Color getOverridenColor(String colorConstant, MicrobaComponent component, Color defaultColor) {
        Color overridden = Microba.getOverridenColor(colorConstant, component);
        if (overridden != null) {
            return overridden;
        }
        return defaultColor;
    }

    private static final class UIChangeListener
    implements PropertyChangeListener {
        private UIChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if ("lookAndFeel".equals(event.getPropertyName())) {
                Microba.setLookAndFeelProperties((LookAndFeel)event.getNewValue());
            }
        }
    }
}

