/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n24#3:393\n24#3:394\n24#3:395\n24#3:396\n24#3:397\n24#3:398\n24#3:399\n24#3:400\n24#3:401\n24#3:402\n24#3:403\n24#3:404\n24#3:405\n24#3:406\n24#3:407\n24#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 87058454925987L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(532144200 + 23627, -532144200 + -29760, (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(532144200 + 23626, -532144200 + -15638, (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 65022108982073L;
                thread = Thread.currentThread();
                String string = SshAgentIpcService.D();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (string != null) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(-599120970 - -((char)-28331), -599120970 - -((char)-10014), (int)l2) + string + WindowsNamedPipeAgentIpc.b(-599120970 - -((char)-28332), 599120970 - (char)-13661, (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(-599120970 - -((char)-28329), -599120970 - -28619, (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        long l2;
        block14: {
            block15: {
                String string;
                l2 = 42063022208084L;
                Object object = this.lock;
                synchronized (object) {
                    boolean bl;
                    string = SshAgentIpcService.D();
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string2 = WindowsNamedPipeAgentIpc.b(1887539070 - (char)-19171, -1887539070 - -((char)-10087), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1887539070 - (char)-19172, 1887539070 - (char)-24365, (int)l2) + this.state;
                        throw new IllegalArgumentException(string2.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(1887539070 - (char)-19173, 1887539070 - (char)-409, (int)l2));
                        this.hPipe = hANDLE;
                        windowsNamedPipeAgentIpc = this;
                        if (string != null) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(1887539070 - (char)-19182, -1887539070 - -((char)-17544), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1887539070 - (char)-19183, -1887539070 - -((char)-28623), (int)l2) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1887539070 - (char)-19184, 1887539070 - (char)-9725, (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(1887539070 - (char)-19182, -1887539070 - -((char)-17544), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1887539070 - (char)-19185, 1887539070 - (char)-7535, (int)l2));
            if (ActionTimestamp.D()) {
                SshAgentIpcService.D("fzDxS");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                String string;
                block6: {
                    long l2 = 124769953294669L;
                    string = SshAgentIpcService.D();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (string != null) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (string != null) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        block32: {
            boolean bl;
            block34: {
                block33: {
                    Object object;
                    Object object2;
                    String string;
                    long l2;
                    block28: {
                        block29: {
                            l2 = 29305869994102L;
                            this.assertConnectionThread();
                            Object object3 = this.lock;
                            synchronized (object3) {
                                boolean bl2;
                                NamedPipeState namedPipeState;
                                NamedPipeState namedPipeState2;
                                block26: {
                                    block27: {
                                        string = SshAgentIpcService.D();
                                        boolean bl3 = false;
                                        try {
                                            namedPipeState2 = this.state;
                                            namedPipeState = NamedPipeState.Closing;
                                            if (string != null) break block26;
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block27;
                                        }
                                        catch (IllegalArgumentException illegalArgumentException) {
                                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                        }
                                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                                        boolean bl4 = false;
                                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1308078600 + -((char)-6226), -1308078600 + -((char)-11513), (int)l2));
                                        logger.info(WindowsNamedPipeAgentIpc.b(-1308078600 + -((char)-6230), 1308078600 + (char)-6704, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1308078600 + -((char)-6227), 1308209670 - (char)-2291, (int)l2) + this.state);
                                        throw new ClosedChannelException();
                                    }
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Open;
                                }
                                try {
                                    bl2 = namedPipeState2 == namedPipeState;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                if (!bl2) {
                                    boolean bl5 = false;
                                    String string2 = WindowsNamedPipeAgentIpc.b(-1308078600 + -((char)-6230), 1308078600 + (char)-6704, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1308078600 + -((char)-6224), 1308209670 - (char)-5140, (int)l2) + this.state;
                                    throw new IllegalArgumentException(string2.toString());
                                }
                                this.state = NamedPipeState.Connecting;
                                Unit unit = Unit.INSTANCE;
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl6 = false;
                            try {
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1308078600 + -((char)-6226), -1308078600 + -((char)-11513), (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(-1308078600 + -((char)-6230), 1308078600 + (char)-6704, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1308078600 + -((char)-6225), -1308078600 + -((char)-6256), (int)l2));
                                object2 = Kernel32.INSTANCE;
                                if (string != null) break block28;
                                if (object2.ConnectNamedPipe(this.hPipe, null)) break block29;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            int n2 = Kernel32.INSTANCE.GetLastError();
                            if (n2 == 535) {
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                                boolean bl7 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1308078600 + -((char)-6226), -1308078600 + -((char)-11513), (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(-1308078600 + -((char)-6230), 1308078600 + (char)-6704, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1308078600 + -((char)-6238), -1308078600 + -((char)-10739), (int)l2));
                            } else {
                                throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(-1308078600 + -((char)-6230), 1308078600 + (char)-6704, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1308078600 + -((char)-6239), 1308209670 - (char)-12196, (int)l2) + ErrorToolsKt.prettyHRESULT(n2)).toString());
                            }
                        }
                        object2 = this.lock;
                    }
                    Kernel32 kernel32 = object2;
                    synchronized (kernel32) {
                        boolean bl8;
                        NamedPipeState namedPipeState;
                        NamedPipeState namedPipeState3;
                        block30: {
                            block31: {
                                boolean bl9 = false;
                                namedPipeState3 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (string != null) break block30;
                                try {
                                    block35: {
                                        if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block31;
                                        break block35;
                                        catch (IllegalArgumentException illegalArgumentException) {
                                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                        }
                                    }
                                    throw new ClosedChannelException();
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                            }
                            namedPipeState3 = this.state;
                            namedPipeState = NamedPipeState.Connecting;
                        }
                        try {
                            bl8 = namedPipeState3 == namedPipeState;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        if (!bl8) {
                            boolean bl10 = false;
                            String string3 = WindowsNamedPipeAgentIpc.b(-1308078600 + -((char)-6230), 1308078600 + (char)-6704, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1308078600 + -((char)-6224), 1308209670 - (char)-5140, (int)l2) + this.state;
                            throw new IllegalArgumentException(string3.toString());
                        }
                        this.state = NamedPipeState.Connected;
                        object = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                    boolean bl11 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1308078600 + -((char)-6226), -1308078600 + -((char)-11513), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1308078600 + -((char)-6230), 1308078600 + (char)-6704, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1308078600 + -((char)-6236), 1308078600 + (char)-10082, (int)l2));
                    long l3 = this.getRequesterPid();
                    this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
                    object = new PipeReadableByteChannel(this);
                    PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
                    try {
                        try {
                            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                                final /* synthetic */ PipeReadableByteChannel $read;
                                final /* synthetic */ PipeWritableByteChannel $write;
                                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                                private static final String[] a;
                                private static final String[] b;
                                {
                                    this.$read = $read;
                                    this.$write = $write;
                                    this.this$0 = $receiver;
                                }

                                public InputStream getInputStream() {
                                    long l2 = 122478888549778L;
                                    InputStream inputStream = Channels.newInputStream(this.$read);
                                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(693884580 - (char)-31994, -693884580 - -((char)-14403), (int)l2));
                                    return inputStream;
                                }

                                public OutputStream getOutputStream() {
                                    long l2 = 58742253884996L;
                                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(13762350 + (char)-18149, -13762350 + -((char)-14269), (int)l2));
                                    return outputStream;
                                }

                                public void close() {
                                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                                }

                                /*
                                 * Unable to fully structure code
                                 */
                                static {
                                    block13: {
                                        var5 = new String[2];
                                        var3_1 = 0;
                                        var2_2 = "x\u00d0\u00ec\u0019o\u0093\u00c3\u00f1\u0087\u00878j\u00fa\u0011\u00b3\u00bbB1\u008f\u0014,\u00def\u00de%\u00a9\u00f73\u0083\u00d9}u\u0090\u000b?s>\u00ee\u0007\u00bf";
                                        var4_3 = "x\u00d0\u00ec\u0019o\u0093\u00c3\u00f1\u0087\u00878j\u00fa\u0011\u00b3\u00bbB1\u008f\u0014,\u00def\u00de%\u00a9\u00f73\u0083\u00d9}u\u0090\u000b?s>\u00ee\u0007\u00bf".length();
                                        var1_4 = 19;
                                        var0_5 = -1;
lbl7:
                                        // 2 sources

                                        while (true) {
                                            continue;
                                            break;
                                        }
lbl9:
                                        // 1 sources

                                        while (true) {
                                            var5[var3_1++] = new String(v0).intern();
                                            if ((var0_5 += var1_4) < var4_3) {
                                                var1_4 = var2_2.charAt(var0_5);
                                                ** continue;
                                            }
                                            break block13;
                                            break;
                                        }
                                        v1 = ++var0_5;
                                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                                        v3 = v2.length;
                                        var6_6 = 0;
                                        v4 = 47;
                                        v5 = v2;
                                        v6 = v3;
                                        if (v3 > 1) ** GOTO lbl67
                                        do {
                                            v7 = v4;
                                            v5 = v5;
                                            v8 = v5;
                                            v9 = v4;
                                            v10 = var6_6;
                                            while (true) {
                                                switch (var6_6 % 7) {
                                                    case 0: {
                                                        v11 = 6;
                                                        break;
                                                    }
                                                    case 1: {
                                                        v11 = 90;
                                                        break;
                                                    }
                                                    case 2: {
                                                        v11 = 61;
                                                        break;
                                                    }
                                                    case 3: {
                                                        v11 = 2;
                                                        break;
                                                    }
                                                    case 4: {
                                                        v11 = 104;
                                                        break;
                                                    }
                                                    case 5: {
                                                        v11 = 42;
                                                        break;
                                                    }
                                                    default: {
                                                        v11 = 63;
                                                    }
                                                }
                                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                                ++var6_6;
                                                v4 = v7;
                                                if (v7 != 0) break;
                                                v7 = v4;
                                                v5 = v5;
                                                v10 = v4;
                                                v8 = v5;
                                                v9 = v4;
                                            }
lbl67:
                                            // 2 sources

                                            v0 = v5;
                                            v6 = v6;
                                        } while (v6 > var6_6);
                                        ** while (true)
                                    }
                                    accept.3.a = var5;
                                    accept.3.b = new String[2];
                                }

                                private static String a(int n2, int n3, int n4) {
                                    int n5 = (n2 ^ n4 ^ 0xFFFFAE0C) & 0xFFFF;
                                    if (b[n5] == null) {
                                        int n6;
                                        char[] cArray = a[n5].toCharArray();
                                        int n7 = switch (cArray[0] & 0xFF) {
                                            case 0 -> 230;
                                            case 1 -> 128;
                                            case 2 -> 60;
                                            case 3 -> 179;
                                            case 4 -> 20;
                                            case 5 -> 96;
                                            case 6 -> 69;
                                            case 7 -> 90;
                                            case 8 -> 176;
                                            case 9 -> 89;
                                            case 10 -> 222;
                                            case 11 -> 25;
                                            case 12 -> 229;
                                            case 13 -> 26;
                                            case 14 -> 178;
                                            case 15 -> 78;
                                            case 16 -> 87;
                                            case 17 -> 108;
                                            case 18 -> 39;
                                            case 19 -> 97;
                                            case 20 -> 134;
                                            case 21 -> 253;
                                            case 22 -> 7;
                                            case 23 -> 155;
                                            case 24 -> 121;
                                            case 25 -> 62;
                                            case 26 -> 235;
                                            case 27 -> 172;
                                            case 28 -> 34;
                                            case 29 -> 9;
                                            case 30 -> 63;
                                            case 31 -> 189;
                                            case 32 -> 8;
                                            case 33 -> 91;
                                            case 34 -> 27;
                                            case 35 -> 240;
                                            case 36 -> 135;
                                            case 37 -> 177;
                                            case 38 -> 100;
                                            case 39 -> 187;
                                            case 40 -> 143;
                                            case 41 -> 224;
                                            case 42 -> 70;
                                            case 43 -> 53;
                                            case 44 -> 228;
                                            case 45 -> 17;
                                            case 46 -> 237;
                                            case 47 -> 163;
                                            case 48 -> 92;
                                            case 49 -> 207;
                                            case 50 -> 243;
                                            case 51 -> 141;
                                            case 52 -> 61;
                                            case 53 -> 85;
                                            case 54 -> 114;
                                            case 55 -> 197;
                                            case 56 -> 77;
                                            case 57 -> 233;
                                            case 58 -> 245;
                                            case 59 -> 239;
                                            case 60 -> 214;
                                            case 61 -> 22;
                                            case 62 -> 120;
                                            case 63 -> 247;
                                            case 64 -> 56;
                                            case 65 -> 199;
                                            case 66 -> 67;
                                            case 67 -> 160;
                                            case 68 -> 149;
                                            case 69 -> 158;
                                            case 70 -> 46;
                                            case 71 -> 42;
                                            case 72 -> 19;
                                            case 73 -> 246;
                                            case 74 -> 98;
                                            case 75 -> 201;
                                            case 76 -> 159;
                                            case 77 -> 213;
                                            case 78 -> 118;
                                            case 79 -> 129;
                                            case 80 -> 193;
                                            case 81 -> 76;
                                            case 82 -> 194;
                                            case 83 -> 93;
                                            case 84 -> 115;
                                            case 85 -> 103;
                                            case 86 -> 157;
                                            case 87 -> 231;
                                            case 88 -> 80;
                                            case 89 -> 104;
                                            case 90 -> 131;
                                            case 91 -> 242;
                                            case 92 -> 198;
                                            case 93 -> 232;
                                            case 94 -> 126;
                                            case 95 -> 124;
                                            case 96 -> 4;
                                            case 97 -> 137;
                                            case 98 -> 156;
                                            case 99 -> 72;
                                            case 100 -> 136;
                                            case 101 -> 51;
                                            case 102 -> 125;
                                            case 103 -> 195;
                                            case 104 -> 13;
                                            case 105 -> 144;
                                            case 106 -> 206;
                                            case 107 -> 219;
                                            case 108 -> 225;
                                            case 109 -> 148;
                                            case 110 -> 200;
                                            case 111 -> 234;
                                            case 112 -> 109;
                                            case 113 -> 28;
                                            case 114 -> 3;
                                            case 115 -> 10;
                                            case 116 -> 44;
                                            case 117 -> 209;
                                            case 118 -> 227;
                                            case 119 -> 182;
                                            case 120 -> 212;
                                            case 121 -> 106;
                                            case 122 -> 48;
                                            case 123 -> 191;
                                            case 124 -> 221;
                                            case 125 -> 2;
                                            case 126 -> 202;
                                            case 127 -> 150;
                                            case 128 -> 164;
                                            case 129 -> 101;
                                            case 130 -> 165;
                                            case 131 -> 65;
                                            case 132 -> 40;
                                            case 133 -> 37;
                                            case 134 -> 43;
                                            case 135 -> 14;
                                            case 136 -> 117;
                                            case 137 -> 217;
                                            case 138 -> 58;
                                            case 139 -> 226;
                                            case 140 -> 79;
                                            case 141 -> 154;
                                            case 142 -> 127;
                                            case 143 -> 122;
                                            case 144 -> 105;
                                            case 145 -> 82;
                                            case 146 -> 173;
                                            case 147 -> 55;
                                            case 148 -> 30;
                                            case 149 -> 181;
                                            case 150 -> 161;
                                            case 151 -> 145;
                                            case 152 -> 218;
                                            case 153 -> 47;
                                            case 154 -> 6;
                                            case 155 -> 66;
                                            case 156 -> 130;
                                            case 157 -> 166;
                                            case 158 -> 211;
                                            case 159 -> 168;
                                            case 160 -> 38;
                                            case 161 -> 208;
                                            case 162 -> 248;
                                            case 163 -> 45;
                                            case 164 -> 132;
                                            case 165 -> 99;
                                            case 166 -> 1;
                                            case 167 -> 250;
                                            case 168 -> 241;
                                            case 169 -> 68;
                                            case 170 -> 112;
                                            case 171 -> 216;
                                            case 172 -> 238;
                                            case 173 -> 36;
                                            case 174 -> 31;
                                            case 175 -> 146;
                                            case 176 -> 215;
                                            case 177 -> 75;
                                            case 178 -> 244;
                                            case 179 -> 220;
                                            case 180 -> 107;
                                            case 181 -> 95;
                                            case 182 -> 110;
                                            case 183 -> 86;
                                            case 184 -> 18;
                                            case 185 -> 196;
                                            case 186 -> 41;
                                            case 187 -> 29;
                                            case 188 -> 116;
                                            case 189 -> 183;
                                            case 190 -> 140;
                                            case 191 -> 147;
                                            case 192 -> 188;
                                            case 193 -> 74;
                                            case 194 -> 123;
                                            case 195 -> 52;
                                            case 196 -> 180;
                                            case 197 -> 64;
                                            case 198 -> 184;
                                            case 199 -> 171;
                                            case 200 -> 255;
                                            case 201 -> 32;
                                            case 202 -> 15;
                                            case 203 -> 203;
                                            case 204 -> 236;
                                            case 205 -> 170;
                                            case 206 -> 175;
                                            case 207 -> 174;
                                            case 208 -> 119;
                                            case 209 -> 186;
                                            case 210 -> 84;
                                            case 211 -> 204;
                                            case 212 -> 252;
                                            case 213 -> 16;
                                            case 214 -> 94;
                                            case 215 -> 50;
                                            case 216 -> 153;
                                            case 217 -> 133;
                                            case 218 -> 81;
                                            case 219 -> 192;
                                            case 220 -> 49;
                                            case 221 -> 57;
                                            case 222 -> 139;
                                            case 223 -> 73;
                                            case 224 -> 142;
                                            case 225 -> 251;
                                            case 226 -> 33;
                                            case 227 -> 138;
                                            case 228 -> 249;
                                            case 229 -> 24;
                                            case 230 -> 113;
                                            case 231 -> 151;
                                            case 232 -> 210;
                                            case 233 -> 167;
                                            case 234 -> 223;
                                            case 235 -> 162;
                                            case 236 -> 71;
                                            case 237 -> 205;
                                            case 238 -> 254;
                                            case 239 -> 185;
                                            case 240 -> 83;
                                            case 241 -> 102;
                                            case 242 -> 59;
                                            case 243 -> 23;
                                            case 244 -> 88;
                                            case 245 -> 11;
                                            case 246 -> 190;
                                            case 247 -> 0;
                                            case 248 -> 169;
                                            case 249 -> 35;
                                            case 250 -> 5;
                                            case 251 -> 111;
                                            case 252 -> 152;
                                            case 253 -> 54;
                                            case 254 -> 21;
                                            default -> 12;
                                        };
                                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                                        if (n8 < 0) {
                                            n8 += 256;
                                        }
                                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                                            n6 += 256;
                                        }
                                        int n9 = 0;
                                        while (n9 < cArray.length) {
                                            int n10 = n9 % 2;
                                            int n11 = n9;
                                            char[] cArray2 = cArray;
                                            char c = cArray[n11];
                                            if (n10 == 0) {
                                                cArray2[n11] = (char)(c ^ n8);
                                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                                            } else {
                                                cArray2[n11] = (char)(c ^ n6);
                                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                                            }
                                            ++n9;
                                        }
                                        accept.3.b[n5] = new String(cArray).intern();
                                    }
                                    return b[n5];
                                }
                            };
                            if (string == null) break block32;
                            if (ActionTimestamp.D()) break block33;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = false;
                        break block34;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = true;
            }
            ActionTimestamp.D(bl);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 51654850923359L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    String string = SshAgentIpcService.D();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (string != null) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(720753930 - 12199, 720753930 - 6962, (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(720753930 - 12195, -720753930 - -10747, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(720753930 - 12174, -720753930 - -11544, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(720753930 - 12199, 720753930 - 6962, (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(720753930 - 12195, -720753930 - -10747, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(720753930 - 12175, 720753930 - 6394, (int)l3) + ErrorToolsKt.prettyHRESULT(n3));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    String string2;
                    block13: {
                        long l2 = 75888895531207L;
                        String string3 = SshAgentIpcService.D();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(-1118420310 - -((char)-19400), 1118420310 - (char)-26481, (int)l2));
                        string2 = string3;
                        try {
                            try {
                                try {
                                    try {
                                        if (string2 != null || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string4 = object.toString();
                                string = string4;
                                object = string4;
                                if (string2 != null) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(-1118420310 - -((char)-19401), -1118420310 - -((char)-27346), (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (string2 != null) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        String string;
        long l2;
        block25: {
            block26: {
                l2 = 15374692800851L;
                this.assertConnectionThread();
                Object object2 = this.lock;
                string = SshAgentIpcService.D();
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (string != null) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (string != null) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1290122010 + 1109, 1290122010 - 1862, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(1290122010 + 1105, -1290122010 + -1513, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1290122010 + 1114, -1290122010 - -9981, (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string2 = WindowsNamedPipeAgentIpc.b(1290122010 + 1105, -1290122010 + -1513, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1290122010 + 1107, -1290122010 + -13735, (int)l2) + this.state;
                        throw new IllegalArgumentException(string2.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1290122010 + 1109, 1290122010 - 1862, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1290122010 + 1105, -1290122010 + -1513, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1290122010 + 1121, 1290122010 - 930, (int)l2));
                    object = Kernel32.INSTANCE;
                    if (string != null) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1290122010 + 1109, 1290122010 - 1862, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(1290122010 + 1105, -1290122010 + -1513, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1290122010 + 1120, -1290122010 + -11702, (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (string != null) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1290122010 + 1109, 1290122010 - 1862, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(1290122010 + 1105, -1290122010 + -1513, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1290122010 + 1119, -1290122010 - -4066, (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                String string;
                block16: {
                    l2 = 29211528656322L;
                    Object object = this.lock;
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                string = SshAgentIpcService.D();
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (string != null) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1456056630 + -15052, -1456056630 + -20357, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(-1456056630 + -15056, 1456056630 + 16694, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1456056630 + -15073, 1456056630 - 6797, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(-1456056630 + -15068, 1456056630 - 9962, (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1456056630 + -15052, -1456056630 + -20357, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-1456056630 + -15056, 1456056630 + 16694, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1456056630 + -15067, -1456056630 - -8546, (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (string != null) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (string != null) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1456056630 + -15052, -1456056630 + -20357, (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(-1456056630 + -15056, 1456056630 + 16694, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1456056630 + -15070, 1456056630 + 20017, (int)l2) + ErrorToolsKt.prettyHRESULT(n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1456056630 + -15052, -1456056630 + -20357, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1456056630 + -15056, 1456056630 + 16694, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1456056630 + -15069, 1456056630 - 2337, (int)l2));
                    if (string != null) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1456056630 + -15052, -1456056630 + -20357, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-1456056630 + -15056, 1456056630 + 16694, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1456056630 + -15096, -1456056630 + -21316, (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-1456056630 + -15095, 1456056630 + 20786, (int)l2));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "\u00d4\u0004\u00f0\u00c44\u00ca\u00e6<\u0014\u00f3\u00b0,\u00b5Ql\u00e5\u00f20\u00cfl\u00d0\u00bc\u00ddM\b8\u00b4?\u00ec\u0006\u00b1\u00d9\\\u007f\u00cb\u00fc\u0018/\u00e7\u00d7o\u00ac\u00f2X\u00e1O\u00d0\u008cC\u00c6PP;2\u00bbP\u0090\u00f98\u00a9\u0097\t\u00bb\u00ac\u00db\u00b7Fv\u001d9\u00db\u0005vr\u00a4\n\u00ce\b?k\u008dX\u00c9\u007f_h\u0014\u0097S\u00d8R\u00a2\u0098\u00ae\u00fb73'\u00fb\u009f\u001b\u0092=\u00d1\u00c1\u00fb\u0000\u0005\u00e0\u0003v$\u0094\u001e\u00aej\u00aam\u0092v=\u000bF\u0099\u00e6\u00ed\u00c7\u00a5\u00d2\u00e1\u0083q\u00b4=\u00c9\u00a2\u00a3\tI\u00adL\u00a8\u0087\u00a2\u0010\u00f34\u00e5c,\u0085\u001c\u008c\u001f\u00db@X\u0015F'\u0002\t\u0018\u0086y\u00e3A\u00db\u00db\u0013\u00ed\u0010\u00dd\u00df \u001e\u0094*\u000by\u00fde\u001c\u008f\u009e\u00bcV]?\u00ec\u00fe\u00ea\u00ff\u0097-\u0018\f\u0093\u00a8\u00190\u0087\u00e8\u00e7q\u00e0\u0006\u00a5\u0016e\u0095M\u0089\u0084U\u00f8\u0003&\u0081'\u0003B\u00c5N\u0098S\u009c|\u00b4\u00fas\u00d5#\u00bf\"?i\u000b\u00f6.\u0094\u00ca\u00e9\u001e#Y\u00f4\u001f\u0087i\"\u00a4\b\u00e8\u00bbwB\u0096<\u00b4\u0000\f\u00cf\u00ce\u0083\u00f7\u0015\u00e8*\u009d\u00f0\u00b1\u00ef\u0011F\u00ab|\u000f\u00a1\u0084\"\u0018\u00c4\u00b6\u0096-1\u0097\u00c0\u00faR\u00bf\u0005N\u00d9\n>\u00a3\u00ceo\u0096vpH\u00c6\u00d0\u00d7\u0080\u00e9\u00d4<\u00daE\u00e6K:\u0099F\u0085\u0013s\u00fe>\u00d4\u00e4\u00b3|\u0096b\u0083Iu\u00cd\f\u001c88\u00d2\u00adzu\u00b3+\u00a6\n\u001f\u0086B\u00afh2\u00d6)\u001f\u00c4\u001b\u00b6\u00bd\u00cd\u00b2\u0098\u00b2\u00b1\u00f3\u008f\u00a7eq\u00e1\u00d8`G~9\u00dca@\u000b\t*[k\u000e{I\u00ef\u009c\u00f3h\u0015\u00b2\u0005,\u008d\u00e7\u00cf\u0098\u0004\u0098n \u00d8\u00a1\u00b2\b\u00e4X\u00ado\u0015O)\u001f\u00d6\u009c\u00faT\u0084\u00e5U]R\u0085\u0094\u00af\u009dJR\u00b4g\u00f4\u0092\u00fa\u00af\u00d4\u001b\u00a9v\u0090g.^\u009c\u00fa\u00f7\u00e9\\\u00b1\u00d5\u00e9\u008cw\u00d4\u00070\u0095s\u0088\u008d\u0097E\u0007w\u00ec\u00ff\u00cb\u00fb\u0010\u009d(2\u009auR\u00d9\u00fb\u00a2\u009d\u00c5\u009c\u00bc{\u00ab\u00e1\u0088^\u00ebK\u00b1T3I\u0082\f\u00f3(m\u00d7\u00a6(V-Ux\u0096.6gcU\u000f\u00a5\u00e1\u00c9\u0014\u00a6_\u00e8\u00ca\u00f9\u00fb\u009a\u00c6\u00cf\u0002\u009a\"\u001b\u008f\u001c\u00d1D\u00e1\u00e7\u00f9\u001d\u00c7\u008d&\u00ad\u00c7n\u00d7\u00db\u00fe\u0093\u00e3\u00fc\u0081\u00b4\u008e6\u0090\u00aee\u00cd,B\u00b3\u00023\u000e<\u00f7\u00fa\u00d6\u00c0\u0007$\u00c1`\u009a\u00a9\u00ea\u00a5\u008d\u001b\u00ca\u008b#\\\u0000\u00e3\u00a9\u0001\u0086\u0005\u00f8\u0018\u00df\u00e5\u0006\u0085~\u001e\u009ac\u00e6\u00a5\u0084\u00ac{\u00b9R\n\u009f\u00e3MV\u00d9FA\u009f0\u00b4\u0018\u0007\u00d7\u009a\u00da6\u008fN\u00d2d\u00b6f\u00f1\u00b5\u008b\u00b7i?\u0082e\u0089a\u00b3/=)\u00ceZ\u00a6k\u0013\u00b6\r\u0013@\u009a&\u008d\u00df\u00b7\u00dbl\u00f8\u00d5\u00a2\u0001\n\u00cd\u0083[6\u00ec\u00fe\u00d8\u00b0\u00f5\u00f4\u001e\u00df\u00ab\u008cm\u0011V\u0014\u0080\u00c7\t\u00cd:\u00c3j\u001c%&\u0097\u00ef";
                var4_3 = "\u00d4\u0004\u00f0\u00c44\u00ca\u00e6<\u0014\u00f3\u00b0,\u00b5Ql\u00e5\u00f20\u00cfl\u00d0\u00bc\u00ddM\b8\u00b4?\u00ec\u0006\u00b1\u00d9\\\u007f\u00cb\u00fc\u0018/\u00e7\u00d7o\u00ac\u00f2X\u00e1O\u00d0\u008cC\u00c6PP;2\u00bbP\u0090\u00f98\u00a9\u0097\t\u00bb\u00ac\u00db\u00b7Fv\u001d9\u00db\u0005vr\u00a4\n\u00ce\b?k\u008dX\u00c9\u007f_h\u0014\u0097S\u00d8R\u00a2\u0098\u00ae\u00fb73'\u00fb\u009f\u001b\u0092=\u00d1\u00c1\u00fb\u0000\u0005\u00e0\u0003v$\u0094\u001e\u00aej\u00aam\u0092v=\u000bF\u0099\u00e6\u00ed\u00c7\u00a5\u00d2\u00e1\u0083q\u00b4=\u00c9\u00a2\u00a3\tI\u00adL\u00a8\u0087\u00a2\u0010\u00f34\u00e5c,\u0085\u001c\u008c\u001f\u00db@X\u0015F'\u0002\t\u0018\u0086y\u00e3A\u00db\u00db\u0013\u00ed\u0010\u00dd\u00df \u001e\u0094*\u000by\u00fde\u001c\u008f\u009e\u00bcV]?\u00ec\u00fe\u00ea\u00ff\u0097-\u0018\f\u0093\u00a8\u00190\u0087\u00e8\u00e7q\u00e0\u0006\u00a5\u0016e\u0095M\u0089\u0084U\u00f8\u0003&\u0081'\u0003B\u00c5N\u0098S\u009c|\u00b4\u00fas\u00d5#\u00bf\"?i\u000b\u00f6.\u0094\u00ca\u00e9\u001e#Y\u00f4\u001f\u0087i\"\u00a4\b\u00e8\u00bbwB\u0096<\u00b4\u0000\f\u00cf\u00ce\u0083\u00f7\u0015\u00e8*\u009d\u00f0\u00b1\u00ef\u0011F\u00ab|\u000f\u00a1\u0084\"\u0018\u00c4\u00b6\u0096-1\u0097\u00c0\u00faR\u00bf\u0005N\u00d9\n>\u00a3\u00ceo\u0096vpH\u00c6\u00d0\u00d7\u0080\u00e9\u00d4<\u00daE\u00e6K:\u0099F\u0085\u0013s\u00fe>\u00d4\u00e4\u00b3|\u0096b\u0083Iu\u00cd\f\u001c88\u00d2\u00adzu\u00b3+\u00a6\n\u001f\u0086B\u00afh2\u00d6)\u001f\u00c4\u001b\u00b6\u00bd\u00cd\u00b2\u0098\u00b2\u00b1\u00f3\u008f\u00a7eq\u00e1\u00d8`G~9\u00dca@\u000b\t*[k\u000e{I\u00ef\u009c\u00f3h\u0015\u00b2\u0005,\u008d\u00e7\u00cf\u0098\u0004\u0098n \u00d8\u00a1\u00b2\b\u00e4X\u00ado\u0015O)\u001f\u00d6\u009c\u00faT\u0084\u00e5U]R\u0085\u0094\u00af\u009dJR\u00b4g\u00f4\u0092\u00fa\u00af\u00d4\u001b\u00a9v\u0090g.^\u009c\u00fa\u00f7\u00e9\\\u00b1\u00d5\u00e9\u008cw\u00d4\u00070\u0095s\u0088\u008d\u0097E\u0007w\u00ec\u00ff\u00cb\u00fb\u0010\u009d(2\u009auR\u00d9\u00fb\u00a2\u009d\u00c5\u009c\u00bc{\u00ab\u00e1\u0088^\u00ebK\u00b1T3I\u0082\f\u00f3(m\u00d7\u00a6(V-Ux\u0096.6gcU\u000f\u00a5\u00e1\u00c9\u0014\u00a6_\u00e8\u00ca\u00f9\u00fb\u009a\u00c6\u00cf\u0002\u009a\"\u001b\u008f\u001c\u00d1D\u00e1\u00e7\u00f9\u001d\u00c7\u008d&\u00ad\u00c7n\u00d7\u00db\u00fe\u0093\u00e3\u00fc\u0081\u00b4\u008e6\u0090\u00aee\u00cd,B\u00b3\u00023\u000e<\u00f7\u00fa\u00d6\u00c0\u0007$\u00c1`\u009a\u00a9\u00ea\u00a5\u008d\u001b\u00ca\u008b#\\\u0000\u00e3\u00a9\u0001\u0086\u0005\u00f8\u0018\u00df\u00e5\u0006\u0085~\u001e\u009ac\u00e6\u00a5\u0084\u00ac{\u00b9R\n\u009f\u00e3MV\u00d9FA\u009f0\u00b4\u0018\u0007\u00d7\u009a\u00da6\u008fN\u00d2d\u00b6f\u00f1\u00b5\u008b\u00b7i?\u0082e\u0089a\u00b3/=)\u00ceZ\u00a6k\u0013\u00b6\r\u0013@\u009a&\u008d\u00df\u00b7\u00dbl\u00f8\u00d5\u00a2\u0001\n\u00cd\u0083[6\u00ec\u00fe\u00d8\u00b0\u00f5\u00f4\u001e\u00df\u00ab\u008cm\u0011V\u0014\u0080\u00c7\t\u00cd:\u00c3j\u001c%&\u0097\u00ef".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 98;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "_\u00fc,\u0007\u00fa\u0083\u0088\rH\u00e1\u009fZP\u00f5\u0092\u009ci\u007fxh\u00bcg\u001eh\u0096.\u00c3}?\u0014\u00ddTQ\u0091FP\u00bf\u00cd\u00c3\u0090\u00aa\u0083\u00dc\u000f\u00f9\u00ea\u0016PB\u00c8";
                    var4_3 = "_\u00fc,\u0007\u00fa\u0083\u0088\rH\u00e1\u009fZP\u00f5\u0092\u009ci\u007fxh\u00bcg\u001eh\u0096.\u00c3}?\u0014\u00ddTQ\u0091FP\u00bf\u00cd\u00c3\u0090\u00aa\u0083\u00dc\u000f\u00f9\u00ea\u0016PB\u00c8".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 20;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 72;
                            break;
                        }
                        case 1: {
                            v15 = 35;
                            break;
                        }
                        case 2: {
                            v15 = 67;
                            break;
                        }
                        case 3: {
                            v15 = 47;
                            break;
                        }
                        case 4: {
                            v15 = 66;
                            break;
                        }
                        case 5: {
                            v15 = 49;
                            break;
                        }
                        default: {
                            v15 = 40;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0xFFFFEE30) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 223;
                case 1 -> 72;
                case 2 -> 201;
                case 3 -> 11;
                case 4 -> 61;
                case 5 -> 121;
                case 6 -> 12;
                case 7 -> 134;
                case 8 -> 228;
                case 9 -> 205;
                case 10 -> 76;
                case 11 -> 227;
                case 12 -> 56;
                case 13 -> 94;
                case 14 -> 19;
                case 15 -> 50;
                case 16 -> 17;
                case 17 -> 158;
                case 18 -> 78;
                case 19 -> 240;
                case 20 -> 171;
                case 21 -> 208;
                case 22 -> 111;
                case 23 -> 16;
                case 24 -> 120;
                case 25 -> 229;
                case 26 -> 150;
                case 27 -> 214;
                case 28 -> 224;
                case 29 -> 104;
                case 30 -> 149;
                case 31 -> 160;
                case 32 -> 100;
                case 33 -> 0;
                case 34 -> 8;
                case 35 -> 183;
                case 36 -> 173;
                case 37 -> 97;
                case 38 -> 239;
                case 39 -> 137;
                case 40 -> 191;
                case 41 -> 21;
                case 42 -> 235;
                case 43 -> 90;
                case 44 -> 141;
                case 45 -> 215;
                case 46 -> 203;
                case 47 -> 31;
                case 48 -> 144;
                case 49 -> 88;
                case 50 -> 177;
                case 51 -> 213;
                case 52 -> 124;
                case 53 -> 64;
                case 54 -> 18;
                case 55 -> 49;
                case 56 -> 114;
                case 57 -> 3;
                case 58 -> 123;
                case 59 -> 204;
                case 60 -> 152;
                case 61 -> 122;
                case 62 -> 67;
                case 63 -> 165;
                case 64 -> 181;
                case 65 -> 197;
                case 66 -> 238;
                case 67 -> 53;
                case 68 -> 66;
                case 69 -> 188;
                case 70 -> 135;
                case 71 -> 249;
                case 72 -> 43;
                case 73 -> 176;
                case 74 -> 42;
                case 75 -> 174;
                case 76 -> 46;
                case 77 -> 106;
                case 78 -> 186;
                case 79 -> 209;
                case 80 -> 30;
                case 81 -> 136;
                case 82 -> 119;
                case 83 -> 138;
                case 84 -> 73;
                case 85 -> 1;
                case 86 -> 44;
                case 87 -> 48;
                case 88 -> 169;
                case 89 -> 225;
                case 90 -> 4;
                case 91 -> 9;
                case 92 -> 35;
                case 93 -> 241;
                case 94 -> 82;
                case 95 -> 126;
                case 96 -> 125;
                case 97 -> 242;
                case 98 -> 129;
                case 99 -> 22;
                case 100 -> 86;
                case 101 -> 34;
                case 102 -> 128;
                case 103 -> 202;
                case 104 -> 57;
                case 105 -> 219;
                case 106 -> 10;
                case 107 -> 109;
                case 108 -> 140;
                case 109 -> 2;
                case 110 -> 91;
                case 111 -> 231;
                case 112 -> 127;
                case 113 -> 79;
                case 114 -> 25;
                case 115 -> 15;
                case 116 -> 170;
                case 117 -> 139;
                case 118 -> 84;
                case 119 -> 55;
                case 120 -> 255;
                case 121 -> 151;
                case 122 -> 80;
                case 123 -> 180;
                case 124 -> 62;
                case 125 -> 172;
                case 126 -> 85;
                case 127 -> 132;
                case 128 -> 107;
                case 129 -> 226;
                case 130 -> 47;
                case 131 -> 71;
                case 132 -> 41;
                case 133 -> 194;
                case 134 -> 65;
                case 135 -> 103;
                case 136 -> 166;
                case 137 -> 24;
                case 138 -> 254;
                case 139 -> 6;
                case 140 -> 146;
                case 141 -> 220;
                case 142 -> 217;
                case 143 -> 118;
                case 144 -> 108;
                case 145 -> 251;
                case 146 -> 248;
                case 147 -> 210;
                case 148 -> 28;
                case 149 -> 112;
                case 150 -> 68;
                case 151 -> 154;
                case 152 -> 175;
                case 153 -> 14;
                case 154 -> 221;
                case 155 -> 182;
                case 156 -> 164;
                case 157 -> 196;
                case 158 -> 39;
                case 159 -> 243;
                case 160 -> 60;
                case 161 -> 185;
                case 162 -> 27;
                case 163 -> 187;
                case 164 -> 189;
                case 165 -> 230;
                case 166 -> 192;
                case 167 -> 38;
                case 168 -> 156;
                case 169 -> 161;
                case 170 -> 7;
                case 171 -> 179;
                case 172 -> 70;
                case 173 -> 40;
                case 174 -> 212;
                case 175 -> 168;
                case 176 -> 52;
                case 177 -> 200;
                case 178 -> 54;
                case 179 -> 36;
                case 180 -> 81;
                case 181 -> 245;
                case 182 -> 206;
                case 183 -> 148;
                case 184 -> 87;
                case 185 -> 198;
                case 186 -> 130;
                case 187 -> 153;
                case 188 -> 37;
                case 189 -> 69;
                case 190 -> 74;
                case 191 -> 96;
                case 192 -> 93;
                case 193 -> 155;
                case 194 -> 116;
                case 195 -> 190;
                case 196 -> 237;
                case 197 -> 157;
                case 198 -> 147;
                case 199 -> 218;
                case 200 -> 252;
                case 201 -> 133;
                case 202 -> 244;
                case 203 -> 58;
                case 204 -> 5;
                case 205 -> 45;
                case 206 -> 23;
                case 207 -> 184;
                case 208 -> 51;
                case 209 -> 29;
                case 210 -> 75;
                case 211 -> 92;
                case 212 -> 246;
                case 213 -> 89;
                case 214 -> 117;
                case 215 -> 222;
                case 216 -> 20;
                case 217 -> 113;
                case 218 -> 216;
                case 219 -> 253;
                case 220 -> 207;
                case 221 -> 101;
                case 222 -> 105;
                case 223 -> 163;
                case 224 -> 145;
                case 225 -> 142;
                case 226 -> 162;
                case 227 -> 59;
                case 228 -> 199;
                case 229 -> 63;
                case 230 -> 234;
                case 231 -> 250;
                case 232 -> 143;
                case 233 -> 233;
                case 234 -> 159;
                case 235 -> 236;
                case 236 -> 195;
                case 237 -> 131;
                case 238 -> 115;
                case 239 -> 83;
                case 240 -> 232;
                case 241 -> 95;
                case 242 -> 167;
                case 243 -> 26;
                case 244 -> 211;
                case 245 -> 33;
                case 246 -> 110;
                case 247 -> 247;
                case 248 -> 178;
                case 249 -> 32;
                case 250 -> 102;
                case 251 -> 98;
                case 252 -> 193;
                case 253 -> 13;
                case 254 -> 77;
                default -> 99;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 74707740999590L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1079885730 - -((char)-29985), -1079885730 - -30347, (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        String string;
                        block4: {
                            l2 = 47789365763786L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            string = SshAgentIpcService.D();
                            try {
                                hANDLE2 = hANDLE;
                                if (string != null) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (string != null) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(735302700 + (char)-27100, -735302700 + -22926, (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(735302700 + (char)-27097, -735302700 + -((char)-28202), (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(735302700 + (char)-27098, 735302700 + 16230, (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "\u00c7\u00f70\u008c\u008cZh\u00fa\u0010\u00efz\u00c4\u009c\u00a8\u00e3\u0015\u0094?zr\u00cc\u00caM\bb";
                    var4_3 = "\u00c7\u00f70\u008c\u008cZh\u00fa\u0010\u00efz\u00c4\u009c\u00a8\u00e3\u0015\u0094?zr\u00cc\u00caM\bb".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 55;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "W4\u00f5#\u00935!\u00b7,?zy\u0080\u00bb-\u00f3u\u00ea\n\u00b4\u00c2\u0000/\u0000\u00bc\t\u0014\u00f0\u0019\u0004\u008e<\u00e8J\u00b7N\u00b1\\\u001b\u00dc/\u00f9l\u00ef>\u00c6L\\\u0097\u00f8\u00d7S\u00b7\u009b\u00e0]\u0096\u00b1y";
                        var4_3 = "W4\u00f5#\u00935!\u00b7,?zy\u0080\u00bb-\u00f3u\u00ea\n\u00b4\u00c2\u0000/\u0000\u00bc\t\u0014\u00f0\u0019\u0004\u008e<\u00e8J\u00b7N\u00b1\\\u001b\u00dc/\u00f9l\u00ef>\u00c6L\\\u0097\u00f8\u00d7S\u00b7\u009b\u00e0]\u0096\u00b1y".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 107;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 35;
                                break;
                            }
                            case 1: {
                                v15 = 116;
                                break;
                            }
                            case 2: {
                                v15 = 115;
                                break;
                            }
                            case 3: {
                                v15 = 12;
                                break;
                            }
                            case 4: {
                                v15 = 27;
                                break;
                            }
                            case 5: {
                                v15 = 51;
                                break;
                            }
                            default: {
                                v15 = 101;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFF49B) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 33;
                    case 1 -> 75;
                    case 2 -> 0;
                    case 3 -> 152;
                    case 4 -> 120;
                    case 5 -> 204;
                    case 6 -> 155;
                    case 7 -> 137;
                    case 8 -> 140;
                    case 9 -> 245;
                    case 10 -> 135;
                    case 11 -> 22;
                    case 12 -> 207;
                    case 13 -> 173;
                    case 14 -> 202;
                    case 15 -> 181;
                    case 16 -> 99;
                    case 17 -> 47;
                    case 18 -> 68;
                    case 19 -> 97;
                    case 20 -> 17;
                    case 21 -> 125;
                    case 22 -> 112;
                    case 23 -> 113;
                    case 24 -> 201;
                    case 25 -> 52;
                    case 26 -> 56;
                    case 27 -> 176;
                    case 28 -> 205;
                    case 29 -> 106;
                    case 30 -> 209;
                    case 31 -> 197;
                    case 32 -> 35;
                    case 33 -> 148;
                    case 34 -> 250;
                    case 35 -> 238;
                    case 36 -> 158;
                    case 37 -> 163;
                    case 38 -> 186;
                    case 39 -> 144;
                    case 40 -> 20;
                    case 41 -> 214;
                    case 42 -> 220;
                    case 43 -> 154;
                    case 44 -> 57;
                    case 45 -> 246;
                    case 46 -> 72;
                    case 47 -> 59;
                    case 48 -> 105;
                    case 49 -> 126;
                    case 50 -> 162;
                    case 51 -> 223;
                    case 52 -> 185;
                    case 53 -> 117;
                    case 54 -> 151;
                    case 55 -> 235;
                    case 56 -> 196;
                    case 57 -> 30;
                    case 58 -> 225;
                    case 59 -> 14;
                    case 60 -> 37;
                    case 61 -> 96;
                    case 62 -> 150;
                    case 63 -> 138;
                    case 64 -> 76;
                    case 65 -> 210;
                    case 66 -> 227;
                    case 67 -> 169;
                    case 68 -> 226;
                    case 69 -> 241;
                    case 70 -> 1;
                    case 71 -> 224;
                    case 72 -> 79;
                    case 73 -> 242;
                    case 74 -> 83;
                    case 75 -> 233;
                    case 76 -> 53;
                    case 77 -> 229;
                    case 78 -> 182;
                    case 79 -> 69;
                    case 80 -> 174;
                    case 81 -> 45;
                    case 82 -> 189;
                    case 83 -> 139;
                    case 84 -> 65;
                    case 85 -> 194;
                    case 86 -> 39;
                    case 87 -> 78;
                    case 88 -> 255;
                    case 89 -> 19;
                    case 90 -> 156;
                    case 91 -> 92;
                    case 92 -> 8;
                    case 93 -> 38;
                    case 94 -> 190;
                    case 95 -> 104;
                    case 96 -> 171;
                    case 97 -> 95;
                    case 98 -> 94;
                    case 99 -> 218;
                    case 100 -> 153;
                    case 101 -> 108;
                    case 102 -> 168;
                    case 103 -> 237;
                    case 104 -> 131;
                    case 105 -> 5;
                    case 106 -> 164;
                    case 107 -> 236;
                    case 108 -> 208;
                    case 109 -> 184;
                    case 110 -> 115;
                    case 111 -> 62;
                    case 112 -> 71;
                    case 113 -> 48;
                    case 114 -> 24;
                    case 115 -> 4;
                    case 116 -> 200;
                    case 117 -> 82;
                    case 118 -> 60;
                    case 119 -> 203;
                    case 120 -> 51;
                    case 121 -> 103;
                    case 122 -> 146;
                    case 123 -> 132;
                    case 124 -> 232;
                    case 125 -> 54;
                    case 126 -> 42;
                    case 127 -> 111;
                    case 128 -> 93;
                    case 129 -> 167;
                    case 130 -> 128;
                    case 131 -> 43;
                    case 132 -> 206;
                    case 133 -> 13;
                    case 134 -> 66;
                    case 135 -> 178;
                    case 136 -> 179;
                    case 137 -> 98;
                    case 138 -> 157;
                    case 139 -> 109;
                    case 140 -> 130;
                    case 141 -> 248;
                    case 142 -> 215;
                    case 143 -> 198;
                    case 144 -> 25;
                    case 145 -> 122;
                    case 146 -> 123;
                    case 147 -> 253;
                    case 148 -> 170;
                    case 149 -> 85;
                    case 150 -> 247;
                    case 151 -> 211;
                    case 152 -> 118;
                    case 153 -> 77;
                    case 154 -> 73;
                    case 155 -> 199;
                    case 156 -> 90;
                    case 157 -> 187;
                    case 158 -> 180;
                    case 159 -> 26;
                    case 160 -> 18;
                    case 161 -> 234;
                    case 162 -> 41;
                    case 163 -> 212;
                    case 164 -> 116;
                    case 165 -> 67;
                    case 166 -> 10;
                    case 167 -> 124;
                    case 168 -> 27;
                    case 169 -> 7;
                    case 170 -> 252;
                    case 171 -> 149;
                    case 172 -> 63;
                    case 173 -> 110;
                    case 174 -> 102;
                    case 175 -> 121;
                    case 176 -> 239;
                    case 177 -> 133;
                    case 178 -> 64;
                    case 179 -> 251;
                    case 180 -> 175;
                    case 181 -> 74;
                    case 182 -> 244;
                    case 183 -> 55;
                    case 184 -> 141;
                    case 185 -> 58;
                    case 186 -> 28;
                    case 187 -> 23;
                    case 188 -> 228;
                    case 189 -> 84;
                    case 190 -> 177;
                    case 191 -> 81;
                    case 192 -> 217;
                    case 193 -> 36;
                    case 194 -> 9;
                    case 195 -> 165;
                    case 196 -> 183;
                    case 197 -> 89;
                    case 198 -> 86;
                    case 199 -> 192;
                    case 200 -> 193;
                    case 201 -> 216;
                    case 202 -> 191;
                    case 203 -> 80;
                    case 204 -> 11;
                    case 205 -> 230;
                    case 206 -> 16;
                    case 207 -> 114;
                    case 208 -> 101;
                    case 209 -> 221;
                    case 210 -> 166;
                    case 211 -> 172;
                    case 212 -> 254;
                    case 213 -> 87;
                    case 214 -> 29;
                    case 215 -> 46;
                    case 216 -> 107;
                    case 217 -> 49;
                    case 218 -> 129;
                    case 219 -> 147;
                    case 220 -> 231;
                    case 221 -> 34;
                    case 222 -> 88;
                    case 223 -> 12;
                    case 224 -> 70;
                    case 225 -> 50;
                    case 226 -> 159;
                    case 227 -> 100;
                    case 228 -> 134;
                    case 229 -> 127;
                    case 230 -> 44;
                    case 231 -> 160;
                    case 232 -> 21;
                    case 233 -> 188;
                    case 234 -> 2;
                    case 235 -> 31;
                    case 236 -> 136;
                    case 237 -> 15;
                    case 238 -> 213;
                    case 239 -> 249;
                    case 240 -> 40;
                    case 241 -> 3;
                    case 242 -> 145;
                    case 243 -> 6;
                    case 244 -> 61;
                    case 245 -> 32;
                    case 246 -> 161;
                    case 247 -> 119;
                    case 248 -> 222;
                    case 249 -> 143;
                    case 250 -> 91;
                    case 251 -> 240;
                    case 252 -> 243;
                    case 253 -> 219;
                    case 254 -> 142;
                    default -> 195;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 99526240646630L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "G/\u0017i&\u0015y\u001e\t@%\u0004ckWd\u0002c";
                    var5_4 = "G/\u0017i&\u0015y\u001e\t@%\u0004ckWd\u0002c".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 14;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 34;
                                    break;
                                }
                                case 1: {
                                    v11 = 68;
                                    break;
                                }
                                case 2: {
                                    v11 = 107;
                                    break;
                                }
                                case 3: {
                                    v11 = 9;
                                    break;
                                }
                                case 4: {
                                    v11 = 77;
                                    break;
                                }
                                case 5: {
                                    v11 = 119;
                                    break;
                                }
                                default: {
                                    v11 = 68;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 61051206042876L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "\u0015\u0004T\u001ak\u0000L\u0004\u0013\u001aX\u0000\n\u001f\u0005S\u0000g\u0002T5\u0004Z\t\u001f\u0005S\u0000g\u0002T9\u000e\r\u0018\u0003N\rm\u000fN9\tI\u0007l\u0006";
                    var5_4 = "\u0015\u0004T\u001ak\u0000L\u0004\u0013\u001aX\u0000\n\u001f\u0005S\u0000g\u0002T5\u0004Z\t\u001f\u0005S\u0000g\u0002T9\u000e\r\u0018\u0003N\rm\u000fN9\tI\u0007l\u0006".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 17;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "\u0001\u0018L\u0003u\u0011Y\u0006\u0001\u0018L\u0003y\u001b";
                        var5_4 = "\u0001\u0018L\u0003u\u0011Y\u0006\u0001\u0018L\u0003y\u001b".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 15;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 77;
                                break;
                            }
                            case 1: {
                                v15 = 123;
                                break;
                            }
                            case 2: {
                                v15 = 44;
                                break;
                            }
                            case 3: {
                                v15 = 127;
                                break;
                            }
                            case 4: {
                                v15 = 19;
                                break;
                            }
                            case 5: {
                                v15 = 112;
                                break;
                            }
                            default: {
                                v15 = 49;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n24#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 116544518842838L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(581295450 - (char)-16094, 581295450 - (char)-10744, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 34677340818699L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "xv\\`\u00b7\u0003\u00a8\u0088\u00f2\u0005\u0007\u00d7\u0095\u0090m\r\u00d51\u00f9\u0006\u0015wS\u0010\u00a5\u00d3\u00da\u0091k\u0010v\u00c5Js\\LQJ,\u001c\b%\u00d7\u00aa\u0080\u0005\u0005`\u00ccy\u00f3\u00f03w\u0015\u008a\u00bf\u0091\u0091\u00d8\u00e5`\u0014\n\rQ\u00fe|\u0090\u00a2\u00c6\u0088T8\u00a1\u00b6\u00cc\u007fH\u00ba\u009f\u00bf\f\u00e5\u0086\u00a2\u00a4\u00f5a\u0081\u00d4\u00fcY\f\u00f8r\u0012p\u00b3\u00df(i\u00e7\u001b";
                    var4_3 = "xv\\`\u00b7\u0003\u00a8\u0088\u00f2\u0005\u0007\u00d7\u0095\u0090m\r\u00d51\u00f9\u0006\u0015wS\u0010\u00a5\u00d3\u00da\u0091k\u0010v\u00c5Js\\LQJ,\u001c\b%\u00d7\u00aa\u0080\u0005\u0005`\u00ccy\u00f3\u00f03w\u0015\u008a\u00bf\u0091\u0091\u00d8\u00e5`\u0014\n\rQ\u00fe|\u0090\u00a2\u00c6\u0088T8\u00a1\u00b6\u00cc\u007fH\u00ba\u009f\u00bf\f\u00e5\u0086\u00a2\u00a4\u00f5a\u0081\u00d4\u00fcY\f\u00f8r\u0012p\u00b3\u00df(i\u00e7\u001b".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 69;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00a9Y5d7*\u00b8\u0002\u0095\u0091\u00bb\u0010%\u0088Z\u00c5L\\E|-4\u00cb\u00b6P\u00ddH\u001e\u0092\u009fV\u009eg\u007fmHS\u00cc\u00a1\u0086\u00ea\u00de\u00e3/\u00a8s'\u0017\bh\u001fY\u008e\u00a2s&O\u00e5C\u0004\u009c/8{\u00e5\u008b\u00ee+\u00bd\u00ef\u0014\n\u00a9\u00a4o\u00f4g!\t\u00c2\u0085\u0013\u00eb\u00ce\u0098\u00ef\u00ec\u00c6\u00e0\u009b\u00a2\u00d9=";
                        var4_3 = "\u00a9Y5d7*\u00b8\u0002\u0095\u0091\u00bb\u0010%\u0088Z\u00c5L\\E|-4\u00cb\u00b6P\u00ddH\u001e\u0092\u009fV\u009eg\u007fmHS\u00cc\u00a1\u0086\u00ea\u00de\u00e3/\u00a8s'\u0017\bh\u001fY\u008e\u00a2s&O\u00e5C\u0004\u009c/8{\u00e5\u008b\u00ee+\u00bd\u00ef\u0014\n\u00a9\u00a4o\u00f4g!\t\u00c2\u0085\u0013\u00eb\u00ce\u0098\u00ef\u00ec\u00c6\u00e0\u009b\u00a2\u00d9=".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 65;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 124;
                                break;
                            }
                            case 1: {
                                v15 = 94;
                                break;
                            }
                            case 2: {
                                v15 = 25;
                                break;
                            }
                            case 3: {
                                v15 = 109;
                                break;
                            }
                            case 4: {
                                v15 = 79;
                                break;
                            }
                            case 5: {
                                v15 = 113;
                                break;
                            }
                            default: {
                                v15 = 9;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x75EE) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 241;
                    case 1 -> 84;
                    case 2 -> 113;
                    case 3 -> 134;
                    case 4 -> 3;
                    case 5 -> 76;
                    case 6 -> 168;
                    case 7 -> 186;
                    case 8 -> 250;
                    case 9 -> 163;
                    case 10 -> 85;
                    case 11 -> 21;
                    case 12 -> 5;
                    case 13 -> 11;
                    case 14 -> 58;
                    case 15 -> 46;
                    case 16 -> 233;
                    case 17 -> 224;
                    case 18 -> 242;
                    case 19 -> 42;
                    case 20 -> 174;
                    case 21 -> 139;
                    case 22 -> 212;
                    case 23 -> 61;
                    case 24 -> 89;
                    case 25 -> 201;
                    case 26 -> 83;
                    case 27 -> 53;
                    case 28 -> 49;
                    case 29 -> 187;
                    case 30 -> 94;
                    case 31 -> 240;
                    case 32 -> 162;
                    case 33 -> 91;
                    case 34 -> 184;
                    case 35 -> 221;
                    case 36 -> 75;
                    case 37 -> 225;
                    case 38 -> 47;
                    case 39 -> 69;
                    case 40 -> 251;
                    case 41 -> 243;
                    case 42 -> 64;
                    case 43 -> 140;
                    case 44 -> 166;
                    case 45 -> 128;
                    case 46 -> 207;
                    case 47 -> 200;
                    case 48 -> 0;
                    case 49 -> 96;
                    case 50 -> 44;
                    case 51 -> 99;
                    case 52 -> 238;
                    case 53 -> 204;
                    case 54 -> 74;
                    case 55 -> 1;
                    case 56 -> 160;
                    case 57 -> 210;
                    case 58 -> 171;
                    case 59 -> 117;
                    case 60 -> 72;
                    case 61 -> 82;
                    case 62 -> 78;
                    case 63 -> 169;
                    case 64 -> 16;
                    case 65 -> 100;
                    case 66 -> 68;
                    case 67 -> 222;
                    case 68 -> 153;
                    case 69 -> 104;
                    case 70 -> 156;
                    case 71 -> 39;
                    case 72 -> 88;
                    case 73 -> 109;
                    case 74 -> 37;
                    case 75 -> 217;
                    case 76 -> 179;
                    case 77 -> 223;
                    case 78 -> 254;
                    case 79 -> 189;
                    case 80 -> 25;
                    case 81 -> 203;
                    case 82 -> 24;
                    case 83 -> 31;
                    case 84 -> 198;
                    case 85 -> 65;
                    case 86 -> 150;
                    case 87 -> 252;
                    case 88 -> 144;
                    case 89 -> 218;
                    case 90 -> 32;
                    case 91 -> 146;
                    case 92 -> 59;
                    case 93 -> 228;
                    case 94 -> 190;
                    case 95 -> 8;
                    case 96 -> 182;
                    case 97 -> 213;
                    case 98 -> 34;
                    case 99 -> 148;
                    case 100 -> 161;
                    case 101 -> 202;
                    case 102 -> 67;
                    case 103 -> 116;
                    case 104 -> 199;
                    case 105 -> 130;
                    case 106 -> 123;
                    case 107 -> 2;
                    case 108 -> 125;
                    case 109 -> 132;
                    case 110 -> 43;
                    case 111 -> 92;
                    case 112 -> 77;
                    case 113 -> 4;
                    case 114 -> 142;
                    case 115 -> 209;
                    case 116 -> 173;
                    case 117 -> 180;
                    case 118 -> 167;
                    case 119 -> 112;
                    case 120 -> 17;
                    case 121 -> 143;
                    case 122 -> 121;
                    case 123 -> 10;
                    case 124 -> 87;
                    case 125 -> 175;
                    case 126 -> 194;
                    case 127 -> 205;
                    case 128 -> 33;
                    case 129 -> 12;
                    case 130 -> 244;
                    case 131 -> 19;
                    case 132 -> 63;
                    case 133 -> 71;
                    case 134 -> 51;
                    case 135 -> 26;
                    case 136 -> 135;
                    case 137 -> 149;
                    case 138 -> 93;
                    case 139 -> 246;
                    case 140 -> 197;
                    case 141 -> 154;
                    case 142 -> 247;
                    case 143 -> 127;
                    case 144 -> 105;
                    case 145 -> 208;
                    case 146 -> 55;
                    case 147 -> 115;
                    case 148 -> 22;
                    case 149 -> 70;
                    case 150 -> 147;
                    case 151 -> 28;
                    case 152 -> 131;
                    case 153 -> 120;
                    case 154 -> 181;
                    case 155 -> 215;
                    case 156 -> 137;
                    case 157 -> 235;
                    case 158 -> 57;
                    case 159 -> 38;
                    case 160 -> 13;
                    case 161 -> 20;
                    case 162 -> 114;
                    case 163 -> 216;
                    case 164 -> 177;
                    case 165 -> 126;
                    case 166 -> 229;
                    case 167 -> 255;
                    case 168 -> 226;
                    case 169 -> 30;
                    case 170 -> 183;
                    case 171 -> 195;
                    case 172 -> 73;
                    case 173 -> 245;
                    case 174 -> 40;
                    case 175 -> 253;
                    case 176 -> 234;
                    case 177 -> 172;
                    case 178 -> 185;
                    case 179 -> 95;
                    case 180 -> 45;
                    case 181 -> 101;
                    case 182 -> 192;
                    case 183 -> 15;
                    case 184 -> 220;
                    case 185 -> 7;
                    case 186 -> 159;
                    case 187 -> 56;
                    case 188 -> 86;
                    case 189 -> 36;
                    case 190 -> 145;
                    case 191 -> 102;
                    case 192 -> 151;
                    case 193 -> 98;
                    case 194 -> 219;
                    case 195 -> 14;
                    case 196 -> 35;
                    case 197 -> 48;
                    case 198 -> 50;
                    case 199 -> 62;
                    case 200 -> 110;
                    case 201 -> 227;
                    case 202 -> 193;
                    case 203 -> 165;
                    case 204 -> 108;
                    case 205 -> 232;
                    case 206 -> 9;
                    case 207 -> 119;
                    case 208 -> 79;
                    case 209 -> 155;
                    case 210 -> 157;
                    case 211 -> 106;
                    case 212 -> 178;
                    case 213 -> 249;
                    case 214 -> 122;
                    case 215 -> 239;
                    case 216 -> 164;
                    case 217 -> 80;
                    case 218 -> 170;
                    case 219 -> 196;
                    case 220 -> 158;
                    case 221 -> 103;
                    case 222 -> 54;
                    case 223 -> 230;
                    case 224 -> 60;
                    case 225 -> 66;
                    case 226 -> 191;
                    case 227 -> 133;
                    case 228 -> 107;
                    case 229 -> 81;
                    case 230 -> 236;
                    case 231 -> 138;
                    case 232 -> 41;
                    case 233 -> 136;
                    case 234 -> 52;
                    case 235 -> 152;
                    case 236 -> 23;
                    case 237 -> 237;
                    case 238 -> 248;
                    case 239 -> 211;
                    case 240 -> 176;
                    case 241 -> 29;
                    case 242 -> 129;
                    case 243 -> 231;
                    case 244 -> 124;
                    case 245 -> 118;
                    case 246 -> 214;
                    case 247 -> 206;
                    case 248 -> 111;
                    case 249 -> 97;
                    case 250 -> 6;
                    case 251 -> 141;
                    case 252 -> 188;
                    case 253 -> 90;
                    case 254 -> 27;
                    default -> 18;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 49828344699502L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(-1865912520 - -((char)-18351), -1865781450 + -((char)-3389), (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 130913441432809L;
                    String string = SshAgentIpcService.D();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(-1456711980 - -8763, 1456711980 + 21874, (int)l2));
                    String string2 = string;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (string2 != null) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 24602576964217L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "b\u00dc\u0085\u0007\u00f9\u0003\u0018\u00db\u009c";
                var4_3 = "b\u00dc\u0085\u0007\u00f9\u0003\u0018\u00db\u009c".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 41;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 21;
                                break;
                            }
                            case 1: {
                                v11 = 26;
                                break;
                            }
                            case 2: {
                                v11 = 79;
                                break;
                            }
                            case 3: {
                                v11 = 54;
                                break;
                            }
                            case 4: {
                                v11 = 17;
                                break;
                            }
                            case 5: {
                                v11 = 14;
                                break;
                            }
                            default: {
                                v11 = 107;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x3DE7) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 9;
                    case 1 -> 162;
                    case 2 -> 112;
                    case 3 -> 42;
                    case 4 -> 237;
                    case 5 -> 54;
                    case 6 -> 36;
                    case 7 -> 172;
                    case 8 -> 57;
                    case 9 -> 146;
                    case 10 -> 133;
                    case 11 -> 232;
                    case 12 -> 157;
                    case 13 -> 181;
                    case 14 -> 109;
                    case 15 -> 7;
                    case 16 -> 16;
                    case 17 -> 113;
                    case 18 -> 125;
                    case 19 -> 29;
                    case 20 -> 167;
                    case 21 -> 223;
                    case 22 -> 195;
                    case 23 -> 152;
                    case 24 -> 169;
                    case 25 -> 168;
                    case 26 -> 143;
                    case 27 -> 249;
                    case 28 -> 197;
                    case 29 -> 6;
                    case 30 -> 58;
                    case 31 -> 251;
                    case 32 -> 225;
                    case 33 -> 63;
                    case 34 -> 15;
                    case 35 -> 148;
                    case 36 -> 32;
                    case 37 -> 56;
                    case 38 -> 123;
                    case 39 -> 3;
                    case 40 -> 142;
                    case 41 -> 198;
                    case 42 -> 44;
                    case 43 -> 186;
                    case 44 -> 67;
                    case 45 -> 116;
                    case 46 -> 69;
                    case 47 -> 11;
                    case 48 -> 147;
                    case 49 -> 99;
                    case 50 -> 230;
                    case 51 -> 154;
                    case 52 -> 117;
                    case 53 -> 102;
                    case 54 -> 101;
                    case 55 -> 200;
                    case 56 -> 118;
                    case 57 -> 46;
                    case 58 -> 48;
                    case 59 -> 61;
                    case 60 -> 115;
                    case 61 -> 23;
                    case 62 -> 138;
                    case 63 -> 93;
                    case 64 -> 78;
                    case 65 -> 233;
                    case 66 -> 18;
                    case 67 -> 159;
                    case 68 -> 62;
                    case 69 -> 238;
                    case 70 -> 53;
                    case 71 -> 247;
                    case 72 -> 60;
                    case 73 -> 191;
                    case 74 -> 73;
                    case 75 -> 158;
                    case 76 -> 75;
                    case 77 -> 2;
                    case 78 -> 94;
                    case 79 -> 187;
                    case 80 -> 183;
                    case 81 -> 114;
                    case 82 -> 110;
                    case 83 -> 4;
                    case 84 -> 27;
                    case 85 -> 173;
                    case 86 -> 218;
                    case 87 -> 8;
                    case 88 -> 96;
                    case 89 -> 59;
                    case 90 -> 45;
                    case 91 -> 35;
                    case 92 -> 14;
                    case 93 -> 40;
                    case 94 -> 222;
                    case 95 -> 55;
                    case 96 -> 236;
                    case 97 -> 215;
                    case 98 -> 74;
                    case 99 -> 205;
                    case 100 -> 30;
                    case 101 -> 72;
                    case 102 -> 5;
                    case 103 -> 50;
                    case 104 -> 39;
                    case 105 -> 211;
                    case 106 -> 182;
                    case 107 -> 239;
                    case 108 -> 201;
                    case 109 -> 105;
                    case 110 -> 149;
                    case 111 -> 33;
                    case 112 -> 240;
                    case 113 -> 79;
                    case 114 -> 174;
                    case 115 -> 64;
                    case 116 -> 185;
                    case 117 -> 0;
                    case 118 -> 235;
                    case 119 -> 41;
                    case 120 -> 77;
                    case 121 -> 164;
                    case 122 -> 26;
                    case 123 -> 128;
                    case 124 -> 245;
                    case 125 -> 84;
                    case 126 -> 111;
                    case 127 -> 220;
                    case 128 -> 161;
                    case 129 -> 255;
                    case 130 -> 92;
                    case 131 -> 194;
                    case 132 -> 97;
                    case 133 -> 122;
                    case 134 -> 219;
                    case 135 -> 228;
                    case 136 -> 180;
                    case 137 -> 214;
                    case 138 -> 139;
                    case 139 -> 51;
                    case 140 -> 124;
                    case 141 -> 106;
                    case 142 -> 151;
                    case 143 -> 229;
                    case 144 -> 144;
                    case 145 -> 1;
                    case 146 -> 19;
                    case 147 -> 66;
                    case 148 -> 135;
                    case 149 -> 104;
                    case 150 -> 160;
                    case 151 -> 153;
                    case 152 -> 119;
                    case 153 -> 80;
                    case 154 -> 163;
                    case 155 -> 227;
                    case 156 -> 38;
                    case 157 -> 190;
                    case 158 -> 127;
                    case 159 -> 68;
                    case 160 -> 242;
                    case 161 -> 192;
                    case 162 -> 196;
                    case 163 -> 206;
                    case 164 -> 121;
                    case 165 -> 252;
                    case 166 -> 166;
                    case 167 -> 70;
                    case 168 -> 221;
                    case 169 -> 212;
                    case 170 -> 210;
                    case 171 -> 34;
                    case 172 -> 129;
                    case 173 -> 145;
                    case 174 -> 31;
                    case 175 -> 231;
                    case 176 -> 207;
                    case 177 -> 120;
                    case 178 -> 130;
                    case 179 -> 248;
                    case 180 -> 150;
                    case 181 -> 137;
                    case 182 -> 17;
                    case 183 -> 136;
                    case 184 -> 175;
                    case 185 -> 156;
                    case 186 -> 25;
                    case 187 -> 241;
                    case 188 -> 100;
                    case 189 -> 47;
                    case 190 -> 179;
                    case 191 -> 208;
                    case 192 -> 203;
                    case 193 -> 107;
                    case 194 -> 89;
                    case 195 -> 226;
                    case 196 -> 141;
                    case 197 -> 178;
                    case 198 -> 216;
                    case 199 -> 224;
                    case 200 -> 202;
                    case 201 -> 24;
                    case 202 -> 108;
                    case 203 -> 88;
                    case 204 -> 10;
                    case 205 -> 165;
                    case 206 -> 177;
                    case 207 -> 37;
                    case 208 -> 49;
                    case 209 -> 43;
                    case 210 -> 176;
                    case 211 -> 21;
                    case 212 -> 71;
                    case 213 -> 243;
                    case 214 -> 131;
                    case 215 -> 134;
                    case 216 -> 103;
                    case 217 -> 244;
                    case 218 -> 98;
                    case 219 -> 85;
                    case 220 -> 209;
                    case 221 -> 91;
                    case 222 -> 87;
                    case 223 -> 82;
                    case 224 -> 90;
                    case 225 -> 132;
                    case 226 -> 234;
                    case 227 -> 204;
                    case 228 -> 199;
                    case 229 -> 188;
                    case 230 -> 28;
                    case 231 -> 65;
                    case 232 -> 246;
                    case 233 -> 76;
                    case 234 -> 184;
                    case 235 -> 213;
                    case 236 -> 155;
                    case 237 -> 52;
                    case 238 -> 95;
                    case 239 -> 140;
                    case 240 -> 171;
                    case 241 -> 13;
                    case 242 -> 253;
                    case 243 -> 217;
                    case 244 -> 22;
                    case 245 -> 20;
                    case 246 -> 12;
                    case 247 -> 86;
                    case 248 -> 170;
                    case 249 -> 83;
                    case 250 -> 254;
                    case 251 -> 126;
                    case 252 -> 81;
                    case 253 -> 250;
                    case 254 -> 193;
                    default -> 189;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

