/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openvr.RenderModelVertex;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Platform;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct RenderModel_t")
public class RenderModel
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int RVERTEXDATA;
    public static final int UNVERTEXCOUNT;
    public static final int INDEXDATA;
    public static final int UNTRIANGLECOUNT;
    public static final int DIFFUSETEXTUREID;

    public RenderModel(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), RenderModel.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="RenderModel_Vertex_t const *")
    public RenderModelVertex.Buffer rVertexData() {
        return RenderModel.nrVertexData(this.address());
    }

    @NativeType(value="uint32_t")
    public int unVertexCount() {
        return RenderModel.nunVertexCount(this.address());
    }

    @NativeType(value="uint16_t const *")
    public ShortBuffer IndexData() {
        return RenderModel.nIndexData(this.address());
    }

    @NativeType(value="uint32_t")
    public int unTriangleCount() {
        return RenderModel.nunTriangleCount(this.address());
    }

    @NativeType(value="TextureID_t")
    public int diffuseTextureId() {
        return RenderModel.ndiffuseTextureId(this.address());
    }

    public static RenderModel malloc() {
        return (RenderModel)RenderModel.wrap(RenderModel.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static RenderModel calloc() {
        return (RenderModel)RenderModel.wrap(RenderModel.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static RenderModel create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (RenderModel)RenderModel.wrap(RenderModel.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static RenderModel create(long address) {
        return (RenderModel)RenderModel.wrap(RenderModel.class, (long)address);
    }

    @Nullable
    public static RenderModel createSafe(long address) {
        return address == 0L ? null : (RenderModel)RenderModel.wrap(RenderModel.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)RenderModel.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)RenderModel.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)RenderModel.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = RenderModel.__create((int)capacity, (int)SIZEOF);
        return (Buffer)RenderModel.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)RenderModel.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)RenderModel.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static RenderModel mallocStack() {
        return RenderModel.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static RenderModel callocStack() {
        return RenderModel.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static RenderModel mallocStack(MemoryStack stack) {
        return RenderModel.malloc(stack);
    }

    @Deprecated
    public static RenderModel callocStack(MemoryStack stack) {
        return RenderModel.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return RenderModel.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return RenderModel.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return RenderModel.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return RenderModel.calloc(capacity, stack);
    }

    public static RenderModel malloc(MemoryStack stack) {
        return (RenderModel)RenderModel.wrap(RenderModel.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static RenderModel calloc(MemoryStack stack) {
        return (RenderModel)RenderModel.wrap(RenderModel.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)RenderModel.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)RenderModel.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static RenderModelVertex.Buffer nrVertexData(long struct) {
        return RenderModelVertex.create(MemoryUtil.memGetAddress((long)(struct + (long)RVERTEXDATA)), RenderModel.nunVertexCount(struct));
    }

    public static int nunVertexCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)UNVERTEXCOUNT);
    }

    public static ShortBuffer nIndexData(long struct) {
        return MemoryUtil.memShortBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)INDEXDATA)), (int)(RenderModel.nunTriangleCount(struct) * 3));
    }

    public static int nunTriangleCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)UNTRIANGLECOUNT);
    }

    public static int ndiffuseTextureId(long struct) {
        return UNSAFE.getInt(null, struct + (long)DIFFUSETEXTUREID);
    }

    static {
        Struct.Layout layout = RenderModel.__struct((int)(Platform.get() == Platform.LINUX || Platform.get() == Platform.MACOSX ? 4 : DEFAULT_PACK_ALIGNMENT), (int)0, (Struct.Member[])new Struct.Member[]{RenderModel.__member((int)POINTER_SIZE), RenderModel.__member((int)4), RenderModel.__member((int)POINTER_SIZE), RenderModel.__member((int)4), RenderModel.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        RVERTEXDATA = layout.offsetof(0);
        UNVERTEXCOUNT = layout.offsetof(1);
        INDEXDATA = layout.offsetof(2);
        UNTRIANGLECOUNT = layout.offsetof(3);
        DIFFUSETEXTUREID = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<RenderModel, Buffer>
    implements NativeResource {
        private static final RenderModel ELEMENT_FACTORY = RenderModel.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected RenderModel getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="RenderModel_Vertex_t const *")
        public RenderModelVertex.Buffer rVertexData() {
            return RenderModel.nrVertexData(this.address());
        }

        @NativeType(value="uint32_t")
        public int unVertexCount() {
            return RenderModel.nunVertexCount(this.address());
        }

        @NativeType(value="uint16_t const *")
        public ShortBuffer IndexData() {
            return RenderModel.nIndexData(this.address());
        }

        @NativeType(value="uint32_t")
        public int unTriangleCount() {
            return RenderModel.nunTriangleCount(this.address());
        }

        @NativeType(value="TextureID_t")
        public int diffuseTextureId() {
            return RenderModel.ndiffuseTextureId(this.address());
        }
    }
}

