/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import org.lwjgl.llvm.LLVMCore;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class LLVMComdat {
    public static final int LLVMAnyComdatSelectionKind = 0;
    public static final int LLVMExactMatchComdatSelectionKind = 1;
    public static final int LLVMLargestComdatSelectionKind = 2;
    public static final int LLVMNoDeduplicateComdatSelectionKind = 3;
    public static final int LLVMSameSizeComdatSelectionKind = 4;

    protected LLVMComdat() {
        throw new UnsupportedOperationException();
    }

    public static long nLLVMGetOrInsertComdat(long M, long Name) {
        long __functionAddress = Functions.GetOrInsertComdat;
        if (Checks.CHECKS) {
            Checks.check((long)M);
        }
        return JNI.invokePPP((long)M, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMComdatRef")
    public static long LLVMGetOrInsertComdat(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMComdat.nLLVMGetOrInsertComdat(M, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMComdatRef")
    public static long LLVMGetOrInsertComdat(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMComdat.nLLVMGetOrInsertComdat(M, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMComdatRef")
    public static long LLVMGetComdat(@NativeType(value="LLVMValueRef") long V) {
        long __functionAddress = Functions.GetComdat;
        if (Checks.CHECKS) {
            Checks.check((long)V);
        }
        return JNI.invokePP((long)V, (long)__functionAddress);
    }

    public static void LLVMSetComdat(@NativeType(value="LLVMValueRef") long V, @NativeType(value="LLVMComdatRef") long C) {
        long __functionAddress = Functions.SetComdat;
        if (Checks.CHECKS) {
            Checks.check((long)V);
            Checks.check((long)C);
        }
        JNI.invokePPV((long)V, (long)C, (long)__functionAddress);
    }

    @NativeType(value="LLVMComdatSelectionKind")
    public static int LLVMGetComdatSelectionKind(@NativeType(value="LLVMComdatRef") long C) {
        long __functionAddress = Functions.GetComdatSelectionKind;
        if (Checks.CHECKS) {
            Checks.check((long)C);
        }
        return JNI.invokePI((long)C, (long)__functionAddress);
    }

    public static void LLVMSetComdatSelectionKind(@NativeType(value="LLVMComdatRef") long C, @NativeType(value="LLVMComdatSelectionKind") int Kind) {
        long __functionAddress = Functions.SetComdatSelectionKind;
        if (Checks.CHECKS) {
            Checks.check((long)C);
        }
        JNI.invokePV((long)C, (int)Kind, (long)__functionAddress);
    }

    public static final class Functions {
        public static final long GetOrInsertComdat = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMGetOrInsertComdat");
        public static final long GetComdat = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMGetComdat");
        public static final long SetComdat = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMSetComdat");
        public static final long GetComdatSelectionKind = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMGetComdatSelectionKind");
        public static final long SetComdatSelectionKind = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMSetComdatSelectionKind");

        private Functions() {
        }
    }
}

